/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.util;

import com.pingidentity.csd.server.datacollector.task.ExternalCollectorTask;
import com.pingidentity.csd.server.datacollector.task.metrics.DbmsCommandDataCollector;
import com.pingidentity.csd.server.datacollector.task.metrics.DbmsTableDataCollector;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.types.OperatingSystem;
import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.collectsupportdata.LDIFUtils;
import com.unboundid.directory.mon.tools.setup.PostgresArch;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.messages.Message;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MetricsEngineUtils {
    private static String[] TABLES = new String[]{"facet", "metric_qualifier", "poll", "dimension_value", "rollup", "histogram"};
    public static String DB_TYPE_DERBY = "derby";
    public static String DB_TYPE_POSTGRES = "postgresql";

    public static List<ExternalCollectorTask> getSupportDataCollectors(CollectSupportData.ZipParentPath dbmsParent, CollectSupportData csd) {
        ArrayList<ExternalCollectorTask> collectors = new ArrayList<ExternalCollectorTask>();
        File configFile = new File(csd.getServerRoot(), "config" + File.separator + "config.ldif");
        for (String table : TABLES) {
            collectors.add(new DbmsTableDataCollector(table, dbmsParent, Message.raw("Done", new Object[0]), table));
        }
        try {
            List<Entry> monitoringDatabases = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.MONITORING_DATABASE, new String[0]);
            if (monitoringDatabases.size() == 0) {
                return collectors;
            }
            Entry monitoringDatabase = monitoringDatabases.get(0);
            File cmdsRoot = new File(csd.getServerRoot(), "commands");
            for (File cmdFile : StaticUtils.listFiles(cmdsRoot, new CommandFileFilter(MetricsEngineUtils.getDbType(monitoringDatabase), ".sql"))) {
                collectors.add(new DbmsCommandDataCollector(cmdFile.getName(), dbmsParent, Message.raw("Done", new Object[0]), cmdFile));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return collectors;
    }

    public static List<String[]> getCommandsToExecute(CollectSupportData csd) {
        ArrayList<String[]> commands = new ArrayList<String[]>();
        File configFile = new File(csd.getServerRoot(), "config" + File.separator + "config.ldif");
        Integer httpPort = null;
        try {
            List<Entry> httpConnectionHandlers = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.HTTP_CONNECTION_HANDLERS, new String[0]);
            for (Entry handler : httpConnectionHandlers) {
                Boolean useSSL;
                Boolean isEnabled = handler.getAttributeValueAsBoolean(LDIFUtils.ENABLED);
                if (isEnabled == null) {
                    isEnabled = false;
                }
                if ((useSSL = handler.getAttributeValueAsBoolean(LDIFUtils.USE_SSL)) == null) {
                    useSSL = false;
                }
                if (httpPort != null || !isEnabled.booleanValue() || useSSL.booleanValue()) continue;
                httpPort = handler.getAttributeValueAsInteger(LDIFUtils.LISTEN_PORT);
            }
        }
        catch (Exception httpConnectionHandlers) {
            // empty catch block
        }
        try {
            Integer port;
            Entry monitoringDatabase = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.MONITORING_DATABASE, new String[0]).get(0);
            String dbType = MetricsEngineUtils.getDbType(monitoringDatabase);
            String host = monitoringDatabase.getAttributeValue(LDIFUtils.SERVER_HOST_NAME);
            if (host == null && dbType.equals(DB_TYPE_POSTGRES)) {
                host = "localhost";
            }
            if ((port = monitoringDatabase.getAttributeValueAsInteger(LDIFUtils.SERVER_PORT)) == null && dbType.equals(DB_TYPE_POSTGRES)) {
                port = 5432;
            }
            File serverRoot = new File(csd.getServerRoot());
            File cmdsRoot = new File(serverRoot, "commands");
            File homeDir = new File(System.getProperty("user.home"));
            File pgPass = new File(homeDir, ".pgpass");
            File[] cmdFiles = cmdsRoot.listFiles(new CommandFileFilter(dbType, ".psql"));
            if (cmdFiles != null && cmdFiles.length > 0 && !pgPass.exists()) {
                csd.log("-----------------------------------------");
                csd.log("execution of " + cmdFiles.length + " command files skipped because ~/.pgpass is missing");
                csd.log("to capture this data, create ~/.pgpass with the following line:");
                csd.log("");
                csd.log(String.format("%s:%d:*:*:<password>", host, port));
                csd.log("");
                csd.log("Please see http://www.postgresql.org/docs/9.2/static/libpq-pgpass.html for more information regarding .pgpass");
                csd.log("-----------------------------------------");
            }
            PostgresArch arch = PostgresArch.findArch();
            if (pgPass.exists() && arch != null) {
                File pgRoot = arch.getPostgresRoot(serverRoot);
                File pgBinDir = arch.getBinDir(pgRoot);
                File psqlFile = new File(pgBinDir, "psql");
                for (File cmdFile : cmdFiles) {
                    String schemaName;
                    ArrayList<String> cmdParts = new ArrayList<String>();
                    String dbName = monitoringDatabase.getAttributeValue(LDIFUtils.DATABASE_NAME);
                    if (dbName == null) {
                        dbName = "unboundid";
                    }
                    if ((schemaName = monitoringDatabase.getAttributeValue(LDIFUtils.USER_NAME)) == null || dbType.equals(DB_TYPE_DERBY)) {
                        schemaName = "unboundid";
                    }
                    cmdParts.addAll(Arrays.asList(cmdFile.getName(), psqlFile.getAbsolutePath(), "-d", dbName, "-U", schemaName, "-f", cmdFile.getAbsolutePath(), "--no-password"));
                    if (host != null && host.length() > 0) {
                        cmdParts.add("-h");
                        cmdParts.add(host);
                    }
                    if (port > 0) {
                        cmdParts.add("-p");
                        cmdParts.add("" + port);
                    }
                    commands.add(cmdParts.toArray(new String[0]));
                }
            }
            if (httpPort != null) {
                OperatingSystem os = OperatingSystem.forName(System.getProperty("os.name"));
                String cmdBaseDir = "bin";
                if (!OperatingSystem.isUNIXBased(os)) {
                    cmdBaseDir = "bat";
                }
                File commandRoot = new File(serverRoot, cmdBaseDir);
                File queryMetricFile = new File(commandRoot, "query-metric");
                commands.add(new String[]{"query-metric", queryMetricFile.getAbsolutePath(), "explore", "--httpPort", "" + httpPort, "--outputDir", "tmp/explore-metrics", "--overwrite", "--no-prompt", "--pivot", "instance", "--pivot", "dim1", "--rateScaling", "second", "--maxIntervals", "200"});
            } else {
                csd.log("-----------------------------------------");
                csd.log("Could not determine HTTP port - skipping metrics data collection");
                csd.log("-----------------------------------------");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return commands;
    }

    public static List<File> getDirectoriesToList(CollectSupportData csd) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            File postgresDataDir = MetricsEngineUtils.getPostgresDataDir(csd);
            if (postgresDataDir == null) {
                csd.log("unable to locate postgres data directory");
                return files;
            }
            files.add(postgresDataDir);
            files.add(new File(postgresDataDir, "logs"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return files;
    }

    public static List<File> getFilesToCat(CollectSupportData csd) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            File postgresDataDir = MetricsEngineUtils.getPostgresDataDir(csd);
            if (postgresDataDir == null) {
                csd.log("unable to locate postgres data directory");
                return files;
            }
            files.add(new File(postgresDataDir, "pg_hba.conf"));
            files.add(new File(postgresDataDir, "postgresql.conf"));
            File logDir = new File(postgresDataDir, "logs");
            if (logDir.exists() && logDir.isDirectory()) {
                for (File file : StaticUtils.listFiles(logDir, null)) {
                    if (!file.getName().endsWith(".log")) continue;
                    files.add(file);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return files;
    }

    private static String getDbType(Entry monitoringDatabase) {
        if (monitoringDatabase.hasAttributeValue(LDIFUtils.OBJECT_CLASS, LDIFUtils.POSTGRES_MONITORING_DATABASE)) {
            return DB_TYPE_POSTGRES;
        }
        return DB_TYPE_DERBY;
    }

    private static File getPostgresDataDir(CollectSupportData csd) {
        try {
            File configFile = new File(csd.getServerRoot(), "config" + File.separator + "config.ldif");
            List<Entry> monitoringDatabases = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.POSTGRES_MONITORING_DATABASE, new String[0]);
            if (monitoringDatabases.size() == 0) {
                return null;
            }
            Entry monitoringDatabase = monitoringDatabases.get(0);
            String dataDir = monitoringDatabase.getAttributeValue(LDIFUtils.EMBEDDED_POSTGRES_DATA_DIR);
            if (dataDir == null || dataDir.length() == 0) {
                return null;
            }
            File serverRoot = new File(csd.getServerRoot());
            return new File(serverRoot, dataDir);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class CommandFileFilter
    implements FilenameFilter {
        private final String dbtype;
        private final String suffix;

        private CommandFileFilter(String dbtype, String suffix) {
            this.dbtype = dbtype.toLowerCase();
            this.suffix = suffix.toLowerCase();
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().startsWith(this.dbtype) && name.toLowerCase().endsWith(this.suffix);
        }
    }
}

