/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.util;

import com.unboundid.common.util.SystemUtils;
import com.unboundid.csd.messages.UBIDTool2Messages;
import com.unboundid.csd.messages.UBIDToolMessages;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.messages.Message;
import com.unboundid.messages.MessageUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ServerUtils {
    public static final String SERVER_HOSTNAME_FILE_NAME = "config/server.host";
    public static final String SERVER_HOSTNAME_PROPERTY = "hostname";

    public static List<Entry> getEntriesFromLDIF(InputStream ldif, Filter filter) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        if (ldif == null) {
            return entries;
        }
        try {
            Entry entry;
            LDIFReader reader = new LDIFReader(ldif);
            while ((entry = reader.readEntry()) != null) {
                if (filter == null) {
                    entries.add(entry);
                    continue;
                }
                if (!filter.matchesEntry(entry)) continue;
                entries.add(entry);
            }
        }
        catch (Exception ex) {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(ba);
            ex.printStackTrace(ps);
            ServerUtils.errorLoggerLog(Message.raw("Failed to load ldif entries: " + new String(ba.toByteArray()), new Object[0]));
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setLocalHostName(File serverRoot, String hostName, String toolName) throws IOException {
        if (!SystemUtils.isLocalHostName((String)hostName)) {
            return false;
        }
        Properties p = new Properties();
        p.setProperty(SERVER_HOSTNAME_PROPERTY, hostName);
        OutputStreamWriter writer = null;
        try {
            File hostNameFile = new File(serverRoot, SERVER_HOSTNAME_FILE_NAME);
            if (!hostNameFile.getParentFile().exists() && !hostNameFile.getParentFile().mkdirs()) {
                throw new IOException(UBIDToolMessages.ERR_DIR_CREATE_FAILURE.get(hostNameFile.getParentFile().getPath()).toString());
            }
            writer = new FileWriter(hostNameFile);
            p.store(writer, MessageUtils.punctuate(UBIDTool2Messages.INFO_SERVER_HOSTNAME_FILE_HEADER.get(toolName)).toString());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalHostName(File serverRoot) {
        String hostName = null;
        File hostNameFile = new File(serverRoot, SERVER_HOSTNAME_FILE_NAME);
        if (hostNameFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(hostNameFile);
                Properties p = new Properties();
                p.load(fis);
                hostName = p.getProperty(SERVER_HOSTNAME_PROPERTY);
            }
            catch (IOException iOException) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (hostName != null && !SystemUtils.isLocalHostName((String)hostName)) {
                hostNameFile.delete();
                hostName = null;
            }
        }
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hostName == null ? "" : hostName;
    }

    public static String getServerUserName(File serverRoot) {
        String serverUserName = null;
        try {
            String userProperty = "server.user";
            File configDir = new File(serverRoot, "config");
            File userFile = new File(configDir, "server.user");
            Properties p = new Properties();
            if (userFile.exists()) {
                FileReader fileReader = new FileReader(userFile);
                p.load(fileReader);
                fileReader.close();
                serverUserName = p.getProperty("server.user");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverUserName;
    }

    public static String ipv6Format(String host) {
        if (host != null && host.contains(":")) {
            if (!(host = host.trim()).startsWith("[")) {
                host = "[" + host;
            }
            if (!host.endsWith("]")) {
                host = host + "]";
            }
        }
        return host;
    }

    private ServerUtils() {
    }

    private static void errorLoggerLog(Message message) {
        System.err.println(message);
    }
}

