/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.collectsupportdata;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfigurationList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class ConfigFileUtil {
    public static DataCollectorConfigurationList readDataCollectorConfigurationListFromYamlFile(String filePath) {
        DataCollectorConfigurationList dataCollectorConfigurationList = new DataCollectorConfigurationList();
        InputStream inputStream = ConfigFileUtil.getInputStream(filePath);
        if (inputStream != null) {
            Yaml yaml = new Yaml();
            try {
                dataCollectorConfigurationList = yaml.loadAs(inputStream, DataCollectorConfigurationList.class);
            }
            catch (YAMLException e) {
                System.err.println("ERROR: Unable to load " + filePath + " as a data collector list. Please validate all fields in the YAML file.");
                throw e;
            }
        } else {
            System.err.println("ERROR: Unable to load data collector configuration list file from " + filePath + ", returning empty configuration");
        }
        return dataCollectorConfigurationList;
    }

    private static InputStream getInputStream(String filePath) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(filePath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return inputStream;
    }
}

