/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.collectsupportdata;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFSearch;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class LDIFUtils {
    public static String LOCAL_DB_BACKEND = "ds-cfg-local-db-backend";
    public static String CHANGELOG_BACKEND = "ds-cfg-changelog-backend";
    public static String MONITOR_HISTORY_PLUGIN = "ds-cfg-monitor-history-plugin";
    public static String NOTIFICATION_MANAGER = "ds-cfg-notification-manager";
    public static String BACKEND = "ds-cfg-backend";
    public static String REPLICATION_SYNCHRONIZATION_PROVIDER = "ds-cfg-replication-synchronization-provider";
    public static String REPLICATION_SERVER = "ds-cfg-replication-server";
    public static String LOG_PUBLISHER = "ds-cfg-log-publisher";
    public static String HTTP_CONNECTION_HANDLERS = "ds-cfg-http-connection-handler";
    public static String MONITORING_DATABASE = "ds-cfg-monitoring-database";
    public static String POSTGRES_MONITORING_DATABASE = "ds-cfg-postgres-monitoring-database";
    public static String FILE_BASED_TRACE_LOG_PUBLISHER = "ds-cfg-file-based-trace-log-publisher";
    public static String POLICY_DECISION_SERVICE = "ds-cfg-policy-decision-service";
    public static String FILE_BASED_POLICY_DECISION_LOG_PUBLISHER = "ds-cfg-file-based-policy-decision-log-publisher";
    public static String DB_DIRECTORY = "ds-cfg-db-directory";
    public static String BACKEND_ID = "ds-cfg-backend-id";
    public static String DB_LOG_FILE_MAX_SIZE = "ds-cfg-db-log-file-max";
    public static String LOG_FILE = "ds-cfg-log-file";
    public static String BASE_DN = "ds-cfg-base-dn";
    public static String SUBSCRIPTION_BASE_DN = "ds-cfg-subscription-base-dn";
    public static String REPLICATION_DB_DIRECTORY = "ds-cfg-replication-db-directory";
    public static String CN = "cn";
    public static String LISTEN_PORT = "ds-cfg-listen-port";
    public static String ENABLED = "ds-cfg-enabled";
    public static String USE_SSL = "ds-cfg-use-ssl";
    public static String SERVER_HOST_NAME = "ds-cfg-server-host-name";
    public static String SERVER_PORT = "ds-cfg-server-port";
    public static String USER_NAME = "ds-cfg-user-name";
    public static String DATABASE_NAME = "ds-cfg-database-name";
    public static String EMBEDDED_POSTGRES_DATA_DIR = "ds-cfg-embedded-postgres-data-dir";
    public static String OBJECT_CLASS = "objectClass";
    public static String DEBUG_MESSAGE_TYPE = "ds-cfg-debug-message-type";
    public static String DECISION_RESPONSE_VIEW = "ds-cfg-decision-response-view";
    public static String INCLUDE_PDP_RESPONSE = "ds-cfg-include-pdp-response";

    public static final void unwrapLDIF(InputStream wrappedLdifIn, OutputStream unwrappedLdifOut) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(wrappedLdifIn));
        PrintStream printStream = new PrintStream(unwrappedLdifOut);
        boolean pendingNewline = false;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(" ")) {
                printStream.print(line.substring(1));
            } else {
                if (pendingNewline) {
                    printStream.println();
                }
                printStream.print(line);
            }
            pendingNewline = true;
        }
        if (pendingNewline) {
            printStream.println();
        }
        printStream.flush();
    }

    public static List<Entry> getEntriesMatchingObjectClass(String ldifFile, String objectClass, String ... args) throws LDAPException, LDIFException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        String[] copyArgs = Arrays.copyOf(args, args.length + 3);
        copyArgs[copyArgs.length - 3] = "--ldifFile";
        copyArgs[copyArgs.length - 2] = ldifFile;
        copyArgs[copyArgs.length - 1] = "(objectClass=" + objectClass + ")";
        ResultCode result = LDIFSearch.main((OutputStream)out, (OutputStream)err, (String[])copyArgs);
        if (result != ResultCode.SUCCESS) {
            throw new LDAPException(result, ((Object)err).toString());
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return LDIFReader.readEntries((InputStream)in);
    }
}

