/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.util.ServerUtils;
import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.ConfigurationExaminer;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AlarmExaminer
extends SupportDataExaminer {
    public static List<SupportDataExaminer> getExaminers(SupportDataArchive sda) {
        ArrayList<SupportDataExaminer> examiners = new ArrayList<SupportDataExaminer>();
        examiners.add(new GeneralAlarmExaminer());
        return examiners;
    }

    @Override
    public List<Category> getCategories() {
        return Arrays.asList(Category.CONFIG);
    }

    public static class GeneralAlarmExaminer
    extends ConfigurationExaminer {
        @Override
        public String getTitle() {
            return "General Alarm Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_ACTIVE_ALARM_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            try {
                String alarmFile = "server-root-files/config/alarms.ldif";
                InputStream stream = sda.getFileInputStream(alarmFile);
                if (stream == null) {
                    String errorMessage = UBIDExaminerMessages.INFO_FILE_NOT_FOUND.get(alarmFile).toString();
                    result.writeln(com.unboundid.directory.server.util.StaticUtils.punctuate((String)errorMessage));
                    result.setSeverity(Severity.SEVERE_ERROR);
                    return result;
                }
                List<Entry> alarmDetails = ServerUtils.getEntriesFromLDIF(stream, Filter.createEqualityFilter((String)"objectClass", (String)"ds-admin-alarm"));
                if (alarmDetails.size() > 0) {
                    result.writeln("Alarms and their details:");
                }
                for (Entry entry : alarmDetails) {
                    String condition = entry.getAttributeValue("ds-alarm-condition");
                    String severity = entry.getAttributeValue("ds-alarm-severity");
                    String details = entry.getAttributeValue("ds-alarm-details");
                    result.upSeverity(this.alarmSeverityConverter(severity));
                    result.writeln("\t\t\t" + condition);
                    result.writeln("Severity: " + severity);
                    result.writeln("Details: " + details);
                    result.writeln();
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }

        public Severity alarmSeverityConverter(String alarm) {
            if (alarm.equalsIgnoreCase("INDETERMINATE") || alarm.equalsIgnoreCase("NORMAL")) {
                return Severity.INFORMATION;
            }
            if (alarm.equalsIgnoreCase("WARNING")) {
                return Severity.SEVERE_WARNING;
            }
            if (alarm.equalsIgnoreCase("MINOR")) {
                return Severity.MILD_ERROR;
            }
            if (alarm.equalsIgnoreCase("MAJOR") || alarm.equalsIgnoreCase("CRITICAL")) {
                return Severity.SEVERE_ERROR;
            }
            return null;
        }
    }
}

