/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class ConfigurationExaminer
extends SupportDataExaminer {
    public static List<SupportDataExaminer> getExaminers(SupportDataArchive sda) {
        ArrayList<SupportDataExaminer> examiners = new ArrayList<SupportDataExaminer>();
        examiners.add(new IndexEntryLimitExaminer());
        examiners.add(new DiskBoundDatabaseCacheExaminer());
        examiners.add(new DSRootConfigExaminer());
        return examiners;
    }

    @Override
    public List<Category> getCategories() {
        return Arrays.asList(Category.CONFIG);
    }

    public static class DSRootConfigExaminer
    extends ConfigurationExaminer {
        static Boolean DEFAULT_CHECK_SCHEMA_STATUS = Boolean.TRUE;

        @Override
        public String getTitle() {
            return "Directory Root Configuration Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_CHECK_SCHEMA_SETTING_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
            try {
                List<Entry> rootConfig = sda.getConfigEntries(Filter.create((String)"(objectClass=ds-cfg-root-config)"));
                Boolean schemaStatus = Boolean.FALSE;
                String schemaStatusStr = "(unknown)";
                for (Entry e : rootConfig) {
                    schemaStatusStr = e.getAttributeValue("ds-cfg-check-schema");
                    if (schemaStatusStr == null) continue;
                    schemaStatus = Boolean.parseBoolean(schemaStatusStr);
                }
                if (schemaStatus != DEFAULT_CHECK_SCHEMA_STATUS) {
                    result.upSeverity(Severity.SEVERE_WARNING);
                    result.writeln("Check Schema status: " + schemaStatusStr);
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }

    public static class DiskBoundDatabaseCacheExaminer
    extends ConfigurationExaminer {
        static final long DB_CACHE_FULL_THRESHOLD_LIMIT = 99L;
        static final String DB_DISK_BOUND_MODE = "no-caching";

        @Override
        public String getTitle() {
            return "Disk-bound database cache examiner";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_DISK_BOUND_CACHE_DEPLOYMENT_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
            try {
                HashSet<String> diskBoundDeployments = new HashSet<String>();
                List<Entry> jeBackends = sda.getConfigEntries(Filter.create((String)"(objectClass=ds-cfg-je-backend)"));
                for (Entry e : jeBackends) {
                    String backendId = e.getAttributeValue("ds-cfg-backend-id");
                    String defaultCacheMode = e.getAttributeValue("ds-cfg-default-cache-mode");
                    if (defaultCacheMode == null || !defaultCacheMode.trim().toLowerCase().equals(DB_DISK_BOUND_MODE)) continue;
                    diskBoundDeployments.add(backendId);
                }
                List<Entry> monitorBackEnds = sda.getMonitorEntries(Filter.create((String)"(objectClass=ds-local-backend-db-env-monitor-entry)"));
                for (Entry e : monitorBackEnds) {
                    String backendId = e.getAttributeValue("backend-id");
                    if (backendId == null || diskBoundDeployments.contains(backendId)) continue;
                    String dbSizeOnDiskStr = e.getAttributeValue("db-on-disk-size");
                    String dbCacheSizeStr = e.getAttributeValue("max-db-cache-size");
                    String dbCachePercentFullStr = e.getAttributeValue("db-cache-percent-full");
                    long dbSizeOnDisk = 0L;
                    if (dbSizeOnDiskStr != null) {
                        dbSizeOnDisk = Long.parseLong(dbSizeOnDiskStr);
                    }
                    long dbCacheSize = 0L;
                    if (dbCacheSizeStr != null) {
                        dbCacheSize = Long.parseLong(dbCacheSizeStr);
                    }
                    long dbCachePercentFull = 0L;
                    if (dbCachePercentFullStr != null) {
                        dbCachePercentFull = Long.parseLong(dbCachePercentFullStr);
                    }
                    if (dbCachePercentFull < 99L && (dbSizeOnDisk <= 0L || dbCacheSize <= 0L || dbSizeOnDisk < dbCacheSize)) continue;
                    result.upSeverity(Severity.SEVERE_WARNING);
                    result.writeln("Backend: " + backendId);
                    result.writeln("Has a maximum cache size       : " + dbCacheSizeStr);
                    result.writeln("Has a database on disk size    : " + dbSizeOnDiskStr);
                    result.writeln("Has database cache percent full: " + dbCachePercentFullStr);
                    result.writeln("The backend " + backendId + " is not configured for disk-bound deployment.");
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }

    public static class IndexEntryLimitExaminer
    extends ConfigurationExaminer {
        static long DEFAULT_INDEX_ENTRY_LIMIT = 4000L;
        static long DEFAULT_EXPLODED_INDEX_ENTRY_THRESHOLD = 4000L;

        @Override
        public String getTitle() {
            return "Index Entry Limit Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_INDEX_ENTRY_LIMIT_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
            try {
                HashMap<String, Long> backendIndexEntryLimits = new HashMap<String, Long>();
                HashMap<String, Long> backendExplodedIndexEntryThresholds = new HashMap<String, Long>();
                List<Entry> jeBackends = sda.getConfigEntries(Filter.create((String)"(objectClass=ds-cfg-je-backend)"));
                for (Entry e : jeBackends) {
                    long indexEntryLimit = DEFAULT_INDEX_ENTRY_LIMIT;
                    long explodedIndexThreshold = DEFAULT_EXPLODED_INDEX_ENTRY_THRESHOLD;
                    String backendId = e.getAttributeValue("ds-cfg-backend-id");
                    String indexEntryLimitStr = e.getAttributeValue("ds-cfg-index-entry-limit");
                    String explodedIndexThresholdStr = e.getAttributeValue("ds-cfg-exploded-index-entry-threshold");
                    if (indexEntryLimitStr != null) {
                        indexEntryLimit = Long.parseLong(indexEntryLimitStr);
                    }
                    if (explodedIndexThresholdStr != null) {
                        explodedIndexThreshold = Long.parseLong(explodedIndexThresholdStr);
                    }
                    backendIndexEntryLimits.put(backendId, indexEntryLimit);
                    backendExplodedIndexEntryThresholds.put(backendId, explodedIndexThreshold);
                }
                List<Entry> localIndexes = sda.getConfigEntries(Filter.create((String)"(objectClass=ds-cfg-local-db-index)"));
                for (Entry e : localIndexes) {
                    long indexEntryLimit = DEFAULT_INDEX_ENTRY_LIMIT;
                    long explodedIndexThreshold = DEFAULT_EXPLODED_INDEX_ENTRY_THRESHOLD;
                    boolean inheritedIndexLimit = false;
                    boolean inheritedExplodedThreshold = false;
                    String indexBackendId = "Unknown";
                    String indexEntryLimitStr = e.getAttributeValue("ds-cfg-index-entry-limit");
                    String explodedIndexThresholdStr = e.getAttributeValue("ds-cfg-exploded-index-entry-threshold");
                    if (indexEntryLimitStr != null) {
                        indexEntryLimit = Long.parseLong(indexEntryLimitStr);
                    }
                    if (explodedIndexThresholdStr != null) {
                        explodedIndexThreshold = Long.parseLong(explodedIndexThresholdStr);
                    }
                    if (indexEntryLimitStr == null || explodedIndexThresholdStr == null) {
                        for (RDN rdn : e.getParsedDN().getRDNs()) {
                            if (!"ds-cfg-backend-id".equals(rdn.getAttributeNames()[0])) continue;
                            indexBackendId = rdn.getAttributeValues()[0];
                            if (indexEntryLimitStr == null) {
                                indexEntryLimit = (Long)backendIndexEntryLimits.get(indexBackendId);
                                inheritedIndexLimit = true;
                            }
                            if (explodedIndexThresholdStr != null) break;
                            explodedIndexThreshold = (Long)backendExplodedIndexEntryThresholds.get(indexBackendId);
                            inheritedExplodedThreshold = true;
                            break;
                        }
                    }
                    Object indexSeverity = explodedIndexThreshold <= 0L || explodedIndexThreshold >= indexEntryLimit ? (indexEntryLimit > 0L && indexEntryLimit <= 50000L ? null : (indexEntryLimit > 0L && indexEntryLimit <= 500000L ? Severity.MILD_WARNING : (indexEntryLimit > 0L && indexEntryLimit <= 2000000L ? Severity.SEVERE_WARNING : Severity.SEVERE_ERROR))) : (explodedIndexThreshold <= 50000L ? (indexEntryLimit > 0L && indexEntryLimit <= 1000000L ? null : (indexEntryLimit > 0L && indexEntryLimit <= 2000000L ? Severity.MILD_WARNING : (indexEntryLimit > 0L && indexEntryLimit <= 5000000L ? Severity.SEVERE_WARNING : Severity.SEVERE_ERROR))) : (explodedIndexThreshold <= 500000L ? (indexEntryLimit > 0L && indexEntryLimit <= 2000000L ? Severity.MILD_WARNING : (indexEntryLimit > 0L && indexEntryLimit <= 5000000L ? Severity.SEVERE_WARNING : Severity.SEVERE_ERROR)) : (explodedIndexThreshold <= 1000000L ? (indexEntryLimit > 0L && indexEntryLimit <= 5000000L ? Severity.SEVERE_WARNING : Severity.SEVERE_ERROR) : Severity.SEVERE_ERROR)));
                    if (indexSeverity == null) continue;
                    result.upSeverity((Severity)((Object)indexSeverity));
                    result.writeln("Index: " + e.getDN());
                    result.writeln("Has custom index entry limit: " + indexEntryLimit);
                    result.writeln("Has custom exploded index entry threshold: " + explodedIndexThreshold);
                    result.write("[" + (Object)indexSeverity + "]");
                    if (inheritedIndexLimit || inheritedExplodedThreshold) {
                        if (inheritedIndexLimit) {
                            result.write(" (Limit ");
                            if (inheritedExplodedThreshold) {
                                result.write("and threshold ");
                            }
                        } else if (inheritedExplodedThreshold) {
                            result.write(" (Threshold ");
                        }
                        result.writeln("inherited from " + indexBackendId + " backend)");
                        continue;
                    }
                    result.writeln();
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis:" + StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }
}

