/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JavaExaminer
extends SupportDataExaminer {
    public static List<SupportDataExaminer> getExaminers(SupportDataArchive sda) {
        ArrayList<SupportDataExaminer> examiners = new ArrayList<SupportDataExaminer>();
        examiners.add(new PauseExaminer());
        examiners.add(new XMSExaminer());
        return examiners;
    }

    public static class XMSExaminer
    extends JavaExaminer {
        @Override
        public String getTitle() {
            return "Server JVM Argument Analysis";
        }

        @Override
        public List<Category> getCategories() {
            return Arrays.asList(Category.CONFIG);
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_JVM_XMS_ARG_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            Properties properties = new Properties();
            try {
                InputStream javaProperties = sda.getFileInputStream("server-root-files/config/java.properties");
                if (javaProperties != null) {
                    BufferedReader javaProps = new BufferedReader(new InputStreamReader(javaProperties));
                    properties.load(javaProps);
                    Pattern p = Pattern.compile("^start\\-.*.java-args");
                    for (String e : properties.stringPropertyNames()) {
                        Matcher m = p.matcher(e);
                        if (!m.matches() || properties.getProperty(e).contains("-Xms")) continue;
                        result.setSeverity(Severity.SEVERE_WARNING);
                        result.writeln("Server JVM arguments do not contain -Xms arg");
                        return result;
                    }
                }
            }
            catch (Exception e) {
                this.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(e));
            }
            return result;
        }
    }

    public static class PauseExaminer
    extends JavaExaminer {
        @Override
        public String getTitle() {
            return "GC Pause Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_JVM_PAUSE_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            try {
                Entry entry = sda.getMonitorEntry("cn=JVM Memory Usage,cn=monitor");
                if (entry == null) {
                    result.setSeverity(Severity.MILD_ERROR);
                    result.writeln("JVM Memory Usage monitor is unavailable.");
                    return result;
                }
                String pauseStr = entry.getAttributeValue("max-detected-pause-time-millis");
                if (pauseStr == null) {
                    result.setSeverity(Severity.MILD_ERROR);
                    return result;
                }
                result.writeln("Max Pause Time detected: " + pauseStr + " ms.");
                long pauseTime = Long.parseLong(pauseStr);
                if (pauseTime <= 3000L) {
                    result.setSeverity(Severity.INFORMATION);
                } else if (pauseTime > 3000L && pauseTime <= 5000L) {
                    result.setSeverity(Severity.MILD_WARNING);
                } else if (pauseTime > 5000L) {
                    result.setSeverity(Severity.MILD_ERROR);
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }
}

