/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ReplicationExaminer
extends SupportDataExaminer {
    public static List<SupportDataExaminer> getExaminers(SupportDataArchive sda) {
        ArrayList<SupportDataExaminer> examiners = new ArrayList<SupportDataExaminer>();
        examiners.add(new BacklogExaminer());
        examiners.add(new SelfBacklogExaminer());
        return examiners;
    }

    @Override
    public List<Category> getCategories() {
        return Arrays.asList(Category.REPLICATION);
    }

    public static class SelfBacklogExaminer
    extends ReplicationExaminer {
        @Override
        public String getTitle() {
            return "Replication Self-Backlog Examiner";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_REPLICATION_SELF_BACKLOG_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) throws Exception {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
            try {
                Pattern selfBacklogExpression = Pattern.compile("replication-self-backlog=\"(\\d+)\"");
                List<Entry> repSummaryEntries = sda.getMonitorEntries(Filter.createEqualityFilter((String)"objectclass", (String)"ds-replication-server-summary-monitor-entry"));
                for (Entry entry : repSummaryEntries) {
                    String[] replicas = entry.getAttributeValues("replica");
                    if (replicas == null) {
                        this.log("Replicas not found in entry " + entry.getDN());
                        continue;
                    }
                    for (String replica : replicas) {
                        int selfBacklog;
                        Matcher m = selfBacklogExpression.matcher(replica);
                        if (!m.find() || (selfBacklog = Integer.parseInt(m.group(1))) <= 0) continue;
                        result.setSeverity(Severity.SEVERE_ERROR);
                        result.writeln("Replication Self-Backlog detected!");
                        result.writeln(" - " + entry.getDN());
                        result.writeln(" - " + replica);
                    }
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }

    public static class BacklogExaminer
    extends ReplicationExaminer {
        @Override
        public String getTitle() {
            return "Replication Backlog Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_REPLICATION_BACKLOG_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
            try {
                Pattern blValue = Pattern.compile("replication-backlog=\"(\\d+)\"");
                List<Entry> repSummaryEntries = sda.getMonitorEntries(Filter.create((String)"(objectClass=ds-replication-server-summary-monitor-entry)"));
                for (Entry entry : repSummaryEntries) {
                    String[] replicas = entry.getAttributeValues("replica");
                    if (replicas == null) {
                        this.log("Replicas not found in entry " + entry.getDN());
                        continue;
                    }
                    for (String replica : replicas) {
                        int backlog;
                        Matcher m = blValue.matcher(replica);
                        if (!m.find() || (backlog = Integer.parseInt(m.group(1))) <= 0) continue;
                        if (backlog > 999 && result.isLessSevereThan(Severity.MILD_ERROR)) {
                            result.setSeverity(Severity.MILD_ERROR);
                        } else if (backlog > 99 && result.isLessSevereThan(Severity.MILD_WARNING)) {
                            result.setSeverity(Severity.MILD_WARNING);
                        }
                        result.writeln("Replication Backlog detected!");
                        result.writeln(" - " + entry.getDN());
                        result.writeln(" - " + replica);
                    }
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }
}

