/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.types.OperatingSystem;
import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.BusyThreadsExaminer;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SolarisExaminer
extends SupportDataExaminer {
    public static List<SupportDataExaminer> getExaminers(SupportDataArchive sda) {
        ArrayList<SupportDataExaminer> examiners = new ArrayList<SupportDataExaminer>();
        return examiners;
    }

    @Override
    public List<OperatingSystem> getSupportedOperatingSystems() {
        return Arrays.asList(OperatingSystem.SOLARIS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusyThreadsExaminer.BusyThreadData getBusyThreadData(SupportDataArchive sda) {
        BusyThreadsExaminer.BusyThreadData data = new BusyThreadsExaminer.BusyThreadData();
        try {
            int numCpus = sda.getNumCpus();
            InputStream is = sda.getServerFile("prstat");
            try {
                Pattern splitter = Pattern.compile("(\\d+\\.\\d+)% java/(\\d+)");
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String line = reader.readLine();
                while (line != null) {
                    Matcher m = splitter.matcher(line.trim());
                    if (m.find() && m.groupCount() >= 2) {
                        String threadId = Integer.toHexString(Integer.valueOf(m.group(2)));
                        Float cpuUsage = Float.valueOf(Float.valueOf(m.group(1)).floatValue() * (float)numCpus);
                        data.updateThreadCpuUsage(threadId, cpuUsage);
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (Exception ex) {
                SupportDataArchive.log(Level.FINE, StaticUtils.stackTraceToSingleLineString(ex));
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex) {
                    SupportDataArchive.log(Level.FINE, StaticUtils.stackTraceToSingleLineString(ex));
                }
            }
        }
        catch (Exception ex) {
            SupportDataArchive.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(ex));
        }
        return data;
    }
}

