/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.types.OperatingSystem;
import com.pingidentity.csd.server.util.ServerUtils;
import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.ExamineSupportData;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class SupportDataArchive {
    protected ZipFile zip;
    protected String zipRoot;
    protected File dir;
    private String pid;
    List<Entry> monitorEntries;
    List<Entry> configEntries;
    private String system;
    private static PrintStream clog;
    private static final Logger log;
    public static final String ZIP_SEPARATOR = "/";
    static final Map<String, OperatingSystem> OS_MAP;

    public SupportDataArchive(File archive) throws IOException {
        String filename = archive.getName();
        if (archive.isDirectory()) {
            SupportDataArchive.log("Treating archive '" + filename + "' as a directory.");
            this.dir = archive;
        } else {
            SupportDataArchive.log("Treating archive '" + filename + "' as a zip file.");
            this.zip = new ZipFile(archive);
            SupportDataArchive.log("Data Source set to Zip File Archive: " + this.zip.getName());
            FileInputStream fis = new FileInputStream(archive);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry entry = zis.getNextEntry();
            if (entry.isDirectory()) {
                this.zipRoot = entry.getName();
                SupportDataArchive.log("Root Directory for Zip File Archive is: " + this.zipRoot);
            } else {
                this.zipRoot = "";
                SupportDataArchive.log("Root Directory for Zip File Archive could not be determined!");
            }
            zis.close();
        }
        this.initialize();
    }

    public SupportDataArchive(String filename) throws IOException {
        this(new File(filename));
    }

    public SupportDataArchive() {
    }

    public OperatingSystem getSystem() {
        return OS_MAP.get(this.system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        block23: {
            InputStream pidIS = this.getFileInputStream("server-root-files/logs/server.pid");
            if (pidIS != null) {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(pidIS));
                    String pidStr = br.readLine();
                    this.pid = pidStr.trim();
                }
                catch (Exception ex) {
                    this.pid = "nopid";
                    log.log(Level.FINE, StaticUtils.stackTraceToSingleLineString(ex));
                }
                finally {
                    try {
                        pidIS.close();
                    }
                    catch (Exception ex) {
                        SupportDataArchive.log("Failed to close pid InputStream: " + pidIS.toString());
                        log.log(Level.FINE, StaticUtils.stackTraceToSingleLineString(ex));
                    }
                }
            } else {
                this.pid = "nopid";
            }
            SupportDataArchive.log("PID was set to: " + this.pid);
            try {
                if (this.zip != null) {
                    Enumeration<? extends ZipEntry> e = this.zip.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry ze = (ZipEntry)e.nextElement();
                        String name = ze.getName();
                        if (name.contains(this.zipRoot + "system-")) {
                            for (String dirname : name.split(ZIP_SEPARATOR)) {
                                if (!dirname.startsWith("system-")) continue;
                                String os = dirname.substring(dirname.indexOf("-") + 1);
                                if (!OS_MAP.keySet().contains(os)) continue;
                                this.system = os;
                                break;
                            }
                        }
                        if (this.system == null) continue;
                        break block23;
                    }
                    break block23;
                }
                for (String os : OS_MAP.keySet()) {
                    if (!new File(this.dir, "system-" + os).exists()) continue;
                    this.system = os;
                    break;
                }
            }
            catch (Exception ex) {
                SupportDataArchive.log("Exception occurred while determining System from archive:" + StaticUtils.stackTraceToSingleLineString(ex));
            }
        }
        if (this.system != null) {
            SupportDataArchive.log("System was set to: " + this.system);
        }
        try {
            this.monitorEntries = ServerUtils.getEntriesFromLDIF(this.getMonitorLdif(), null);
            this.configEntries = ServerUtils.getEntriesFromLDIF(this.getFileInputStream("server-root-files/config/config.ldif"), null);
        }
        catch (Exception e) {
            SupportDataArchive.log("Exception occurred during archive initialization: " + e);
        }
    }

    public void close() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (Exception ex) {
                SupportDataArchive.log("Failed to close ZipFile: " + this.zip.getName());
                log.log(Level.FINE, StaticUtils.stackTraceToSingleLineString(ex));
            }
        }
    }

    public InputStream getSystemFile(String filename) {
        return this.getFileInputStream("system-" + this.system + ZIP_SEPARATOR + filename);
    }

    public InputStream getServerFile(String filename) {
        return this.getFileInputStream("server-" + this.pid + ZIP_SEPARATOR + filename);
    }

    public List<String> listFiles() {
        List<String> result;
        if (this.zip != null) {
            result = new ArrayList<String>(this.zip.size());
            Enumeration<? extends ZipEntry> entries = this.zip.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                name = name.replace(ZIP_SEPARATOR, File.separator);
                result.add(name);
            }
        } else {
            result = SupportDataArchive.collectFilenames(this.dir);
        }
        Collections.sort(result);
        return result;
    }

    private static List<String> collectFilenames(File dir) {
        ArrayList<String> files = new ArrayList<String>();
        LinkedList<File> lookAt = new LinkedList<File>();
        lookAt.add(dir);
        while (!lookAt.isEmpty()) {
            File[] children;
            File file = (File)lookAt.remove();
            Path relativePath = dir.toPath().relativize(file.toPath());
            files.add(dir.getName() + File.separator + relativePath.toString());
            if (!file.isDirectory() || (children = file.listFiles()) == null) continue;
            lookAt.addAll(Arrays.asList(children));
        }
        return files;
    }

    public InputStream getFileInputStream(String filename) {
        String childName = new File(filename).getName();
        InputStream is = null;
        try {
            if (this.zip != null) {
                ZipEntry entry;
                if (!filename.startsWith(this.zipRoot)) {
                    filename = this.zipRoot + filename;
                }
                if ((entry = this.zip.getEntry(filename)) != null) {
                    is = this.zip.getInputStream(entry);
                } else {
                    SupportDataArchive.log("File (" + filename + ") was not found in usual location, searching in zip archive");
                    entry = this.zip.getEntry(this.fileSearch(childName));
                    is = this.zip.getInputStream(entry);
                }
            } else {
                File file = new File(this.dir, filename);
                if (file.exists()) {
                    is = new FileInputStream(file);
                } else {
                    SupportDataArchive.log("File (" + filename + ") was not found in usual location, searching in directory archive");
                    file = new File(this.dir.getParent(), this.fileSearch(childName));
                    is = new FileInputStream(file);
                }
            }
        }
        catch (Exception ex) {
            SupportDataArchive.log("File (" + childName + ") could not be found");
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exe) {
                is = null;
                log.log(Level.FINE, StaticUtils.stackTraceToSingleLineString(exe));
            }
        }
        return is;
    }

    private String fileSearch(String filename) {
        List serverFiles = this.listFiles().stream().filter(file -> file.endsWith(filename)).collect(Collectors.toList());
        if (serverFiles.isEmpty()) {
            return null;
        }
        return (String)serverFiles.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> createMapFromInputStream(InputStream is, String pattern) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Pattern splitter = Pattern.compile(pattern);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                Matcher m = splitter.matcher(line.trim());
                if (m.find() && m.groupCount() >= 2) {
                    map.put(m.group(1), m.group(2));
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception ex) {
            log.log(Level.FINE, StaticUtils.stackTraceToSingleLineString(ex));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {
                log.log(Level.FINE, StaticUtils.stackTraceToSingleLineString(ex));
            }
        }
        return map;
    }

    public List<List<String>> getJstacksLines() {
        String stackHeader = "^\"([^\"]+)\".+";
        ArrayList<List<String>> threadStacks = new ArrayList<List<String>>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getServerFile("jstack")));
            String line = reader.readLine();
            ArrayList<String> currentThread = new ArrayList<String>();
            while (line != null) {
                if (line.matches(stackHeader)) {
                    currentThread = new ArrayList();
                    threadStacks.add(currentThread);
                }
                currentThread.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception ex) {
            log.log(Level.FINE, StaticUtils.stackTraceToSingleLineString(ex));
            threadStacks = null;
        }
        return threadStacks;
    }

    public int getNumCpus() {
        Entry sysInfo = this.getMonitorEntry("cn=System Information,cn=monitor");
        if (sysInfo == null) {
            log.log(Level.FINE, "unable to get System Information from monitor");
            return 1;
        }
        String numCPUs = sysInfo.getAttributeValue("availableCPUs");
        if (numCPUs == null) {
            log.log(Level.FINE, "System Information from monitor does not have value for availableCPUs");
            return 1;
        }
        int rv = 1;
        try {
            rv = Integer.parseInt(numCPUs);
        }
        catch (Exception ex) {
            log.log(Level.FINE, "Value for availableCPUs is not a valid Integer: " + numCPUs);
        }
        return rv;
    }

    public Entry getMonitorEntry(String dn) {
        for (Entry entry : this.monitorEntries) {
            if (!SupportDataArchive.dnsEqual(entry.getDN(), dn)) continue;
            return entry;
        }
        return null;
    }

    public Entry getConfigEntry(String dn) {
        for (Entry entry : this.configEntries) {
            if (!SupportDataArchive.dnsEqual(entry.getDN(), dn)) continue;
            return entry;
        }
        return null;
    }

    public List<Entry> getMonitorEntries(Filter filter) {
        return SupportDataArchive.getEntriesByFilter(this.monitorEntries, filter);
    }

    public List<Entry> getConfigEntries(Filter filter) {
        return SupportDataArchive.getEntriesByFilter(this.configEntries, filter);
    }

    private InputStream getMonitorLdif() {
        List<String> files = this.listFiles();
        String latestMonitor = null;
        String latestDate = null;
        for (String file : files) {
            String date;
            Pattern pattern;
            if (file.endsWith("ldap/monitor.ldif") || file.endsWith("ldap\\monitor.ldif")) {
                latestMonitor = file;
                break;
            }
            if (file.matches(".*monitor-history\\\\monitor\\.[0-9]+Z.*")) {
                pattern = Pattern.compile(".*monitor-history\\\\monitor\\.");
                date = pattern.matcher(file).replaceAll("");
                if (latestDate != null && latestDate.compareTo(date) >= 0) continue;
                latestDate = date;
                latestMonitor = file;
                continue;
            }
            if (!file.matches(".*monitor-history/monitor\\.[0-9]+Z.*")) continue;
            pattern = Pattern.compile(".*monitor-history/monitor\\.");
            date = pattern.matcher(file).replaceAll("");
            if (latestDate != null && latestDate.compareTo(date) >= 0) continue;
            latestDate = date;
            latestMonitor = file;
        }
        if (latestMonitor == null) {
            SupportDataArchive.log("Could not find monitor.ldif or any monitor history files");
            return null;
        }
        if (latestMonitor.endsWith("monitor.ldif")) {
            SupportDataArchive.log("Loading the current monitor information");
        } else {
            SupportDataArchive.log("Could not find monitor.ldif, loading previous monitor information from " + latestDate);
        }
        return this.getFileInputStream(latestMonitor);
    }

    public static List<Entry> getEntriesByFilter(List<Entry> entries, Filter filter) {
        ArrayList<Entry> filteredEntries = new ArrayList<Entry>();
        for (Entry entry : entries) {
            try {
                if (filter == null) {
                    filteredEntries.add(entry);
                    continue;
                }
                if (!filter.matchesEntry(entry)) continue;
                filteredEntries.add(entry);
            }
            catch (Exception ex) {
                log.log(Level.FINE, StaticUtils.stackTraceToSingleLineString(ex));
            }
        }
        return filteredEntries;
    }

    public static void setConsoleLogger(PrintStream logger) {
        clog = logger;
    }

    protected static void log(String message) {
        if (clog != null) {
            clog.println(message);
        }
        log.log(Level.INFO, message);
    }

    protected static void log(Level level, String message) {
        log.log(level, message);
    }

    private static boolean dnsEqual(String dn1, String dn2) {
        if (dn1 == null) {
            return dn2 == null;
        }
        if (dn2 == null) {
            return false;
        }
        try {
            new DN(dn1);
            new DN(dn2);
            return dn1.equals(dn2);
        }
        catch (Exception e) {
            return dn1.equalsIgnoreCase(dn2);
        }
    }

    static {
        log = Logger.getLogger(ExamineSupportData.class.getName());
        OS_MAP = new HashMap<String, OperatingSystem>();
        OS_MAP.put("solaris", OperatingSystem.SOLARIS);
        OS_MAP.put("linux", OperatingSystem.LINUX);
        OS_MAP.put("windows", OperatingSystem.WINDOWS);
        OS_MAP.put("mac-os", OperatingSystem.MACOS);
    }
}

