/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.build.tools.messages;

import com.unboundid.build.tools.messages.GenerateMessagesFile;
import com.unboundid.build.tools.messages.MessageDescriptorDeclaration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;

public class GenerateActionScriptMessageFile
extends GenerateMessagesFile {
    private File resolverStubFile;
    private File initializerStubFile;

    public GenerateActionScriptMessageFile() {
        super("as");
    }

    public File getResolverStubFile() {
        return this.resolverStubFile;
    }

    public void setResolverStubFile(File resolverStubFile) {
        this.resolverStubFile = resolverStubFile;
    }

    public File getInitializerStubFile() {
        return this.initializerStubFile;
    }

    public void setInitializerStubFile(File initializerStubFile) {
        this.initializerStubFile = initializerStubFile;
    }

    @Override
    protected void createProductPropertiesSourceFile(File dest) throws IOException {
    }

    @Override
    protected String getDescriptorString(MessageDescriptorDeclaration decl) {
        return decl.toActionScript();
    }

    @Override
    protected void postProcess() throws Exception {
        this.createResolver();
        this.createInitializer();
    }

    protected void createResolver() throws Exception {
        String stubLine;
        BufferedReader reader = new BufferedReader(new FileReader(this.resolverStubFile));
        File resolverDest = new File(this.destSourceFile.getParent(), this.fileNameWithoutExtension(this.destSourceFile) + "Resolver.as");
        PrintWriter writer = new PrintWriter(resolverDest);
        while (null != (stubLine = reader.readLine())) {
            writer.println(this.replaceVars(stubLine));
        }
        writer.close();
        reader.close();
    }

    protected void createInitializer() throws Exception {
        String line;
        if (this.initializerStubFile == null) {
            throw new RuntimeException("No value for initializerStubFile");
        }
        String initializerFileName = this.initializerStubFile.getName();
        initializerFileName = initializerFileName.replaceAll(".stub", "");
        File initializerFile = new File(this.destSourceFile.getParent(), initializerFileName);
        File source = initializerFile.exists() ? initializerFile : this.initializerStubFile;
        BufferedReader reader = new BufferedReader(new FileReader(source));
        File newInitializerFile = new File(this.destSourceFile.getParent(), initializerFileName + ".new");
        PrintWriter writer = new PrintWriter(newInitializerFile);
        while (null != (line = reader.readLine())) {
            if (line.contains("${RESOLVER_INIT}")) {
                String newLine = this.replaceVars(line);
                if (newLine.trim().startsWith("//")) {
                    writer.println("    " + newLine.trim().replace("//", ""));
                } else {
                    writer.println(newLine);
                }
                writer.println("    // ${RESOLVER_INIT}");
                continue;
            }
            writer.println(line);
        }
        reader.close();
        writer.close();
        if (initializerFile.exists() && !initializerFile.delete()) {
            throw new RuntimeException("Could not delete existing initializer file " + initializerFile.getPath() + " in order to" + " replace it with a new version");
        }
        if (!newInitializerFile.renameTo(initializerFile)) {
            throw new RuntimeException("Could not rename " + newInitializerFile.getPath() + " to " + initializerFile.getPath());
        }
    }

    @Override
    protected String replaceVars(String line) {
        line = super.replaceVars(line);
        line = line.replace("${PROPERTIES_BASE}", this.fileNameWithoutExtension(this.source));
        line = line.replace("${RESOLVER}", this.fileNameWithoutExtension(this.destSourceFile) + "Resolver");
        line = line.replace("${RESOLVER_INIT}", this.fileNameWithoutExtension(this.destSourceFile) + ".RESOLVER.init();");
        line = line.replace("${TOKEN_REPLACER}", this.tokenReplacerArg);
        return line;
    }

    public static void main(String[] args) {
        File root = new File("/Users/ksuter/dev/src/uid/products/console/trunk");
        File source = new File(root, "console-messages/src/main/resources/messages/ubid_console.properties");
        File stub = new File(root, "flex-client/application/src/build/resources/Messages.as.stub");
        File dest = new File("/tmp/com/unboundid/XXX.java");
        File product = new File("resource/products/ds/product.info");
        File resolverStub = new File(root, "flex-client/application/src/build/resources/Resolver.as.stub");
        File initStub = new File(root, "flex-client/application/src/build/resources/Initializer.as.stub");
        GenerateActionScriptMessageFile gmf = new GenerateActionScriptMessageFile();
        gmf.setStubFile(stub);
        gmf.setOverwrite(true);
        gmf.setDestSourceCodeFile(dest);
        gmf.setSourceProps(source);
        gmf.setProductFile(product);
        gmf.setResolverStubFile(resolverStub);
        gmf.setInitializerStubFile(initStub);
        gmf.execute();
    }
}

