/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.build.tools.messages;

import com.unboundid.build.tools.messages.FormatSpecifier;
import com.unboundid.build.tools.messages.GenerateJavaMessageFile;
import com.unboundid.build.tools.messages.GenerateMessagesFile;
import com.unboundid.build.tools.messages.MessagePropertyKey;
import com.unboundid.messages.MessageDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.UnknownFormatConversionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MessageDescriptorDeclaration {
    public static final Pattern SPECIFIER_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private MessagePropertyKey key;
    private String formatString;
    private List<FormatSpecifier> specifiers;
    private List<Class> classTypes;
    private String[] constructorArgs;
    private String category;
    private String severity;
    private String ordinal;
    private String classLoader;
    private String tokenReplacer;

    public MessageDescriptorDeclaration(MessagePropertyKey key, String formatString, String category, String severity, String ordinal, String classLoader, String tokenReplacer) {
        this.key = key;
        this.formatString = formatString;
        this.specifiers = this.parse(formatString);
        this.classTypes = new ArrayList<Class>();
        for (FormatSpecifier f : this.specifiers) {
            Class c = f.getSimpleConversionClass();
            if (c == null) continue;
            this.classTypes.add(c);
        }
        this.category = category;
        this.severity = severity;
        this.ordinal = ordinal;
        this.classLoader = classLoader;
        this.tokenReplacer = tokenReplacer;
    }

    private String getDescriptorJavaClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        if (this.useGenericMessageTypeClass()) {
            sb.append(MessageDescriptorDeclaration.getShortClassName(MessageDescriptor.class));
            sb.append(".");
            sb.append("Arg");
            sb.append("N");
        } else {
            sb.append(MessageDescriptorDeclaration.getShortClassName(MessageDescriptor.class));
            sb.append(".");
            sb.append("Arg");
            sb.append(this.classTypes.size());
            sb.append(this.getClassTypeVariables());
        }
        return sb.toString();
    }

    private String getClassTypeVariables() {
        StringBuilder sb = new StringBuilder();
        if (this.classTypes.size() > 0) {
            sb.append("<");
            for (int i = 0; i < this.classTypes.size(); ++i) {
                Class c = this.classTypes.get(i);
                if (c == null) continue;
                if ("java.lang".equals(c.getPackage().getName())) {
                    sb.append(MessageDescriptorDeclaration.getShortClassName(c));
                } else {
                    sb.append(c.getName());
                }
                if (i >= this.classTypes.size() - 1) continue;
                sb.append(",");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    private String getComment() {
        String[] sa;
        StringBuilder sb = new StringBuilder();
        sb.append(GenerateMessagesFile.indent(1)).append("/**").append(GenerateJavaMessageFile.EOL);
        String ws = this.formatString;
        for (String s : sa = ws.split(GenerateJavaMessageFile.EOL)) {
            sb.append(GenerateJavaMessageFile.indent(1)).append(" * ").append(s).append(GenerateJavaMessageFile.EOL);
        }
        sb.append(GenerateJavaMessageFile.indent(1)).append(" */").append(GenerateJavaMessageFile.EOL);
        return sb.toString();
    }

    public String toJava() {
        StringBuilder sb = new StringBuilder();
        if (this.useGenericMessageTypeClass()) {
            sb.append(MessageDescriptorDeclaration.getShortClassName(MessageDescriptor.class));
            sb.append(".");
            sb.append("Arg");
            sb.append("N");
        } else {
            sb.append(MessageDescriptorDeclaration.getShortClassName(MessageDescriptor.class));
            sb.append(".");
            sb.append("Arg");
            sb.append(this.classTypes.size());
            sb.append(this.getClassTypeVariables());
        }
        String classDecl = sb.toString();
        return this.getComment() + GenerateJavaMessageFile.indent(1) + "public static final " + classDecl + " " + this.key.getMessageDescriptorName() + " =" + GenerateJavaMessageFile.EOL + GenerateJavaMessageFile.indent(5) + "new " + classDecl + "(BASE," + MessageDescriptorDeclaration.quote(this.key.toString()) + "," + this.category + "," + this.severity + "," + this.ordinal + "," + this.classLoader + "," + this.tokenReplacer + ");";
    }

    public String toActionScript() {
        StringBuilder sb = new StringBuilder();
        if (this.useGenericMessageTypeClass()) {
            sb.append(MessageDescriptorDeclaration.getShortClassName(MessageDescriptor.class));
            sb.append("N");
            sb.append("Arg");
        } else {
            sb.append(MessageDescriptorDeclaration.getShortClassName(MessageDescriptor.class));
            sb.append(this.classTypes.size());
            sb.append("Arg");
        }
        String classDecl = sb.toString();
        return this.getComment() + GenerateJavaMessageFile.indent(1) + "public static const " + this.key.getMessageDescriptorName() + ":" + classDecl + " =" + GenerateJavaMessageFile.EOL + GenerateJavaMessageFile.indent(5) + "new " + classDecl + "(RESOLVER," + MessageDescriptorDeclaration.quote(this.key.toString()) + ",Category." + this.category + ",Severity." + this.severity + "," + this.ordinal + ");";
    }

    boolean useGenericMessageTypeClass() {
        if (this.specifiers.size() > 11) {
            return true;
        }
        if (this.specifiers != null) {
            for (FormatSpecifier s : this.specifiers) {
                if (!s.specifiesArgumentIndex()) continue;
                return true;
            }
        }
        return false;
    }

    private static String getShortClassName(Class c) {
        String fqName = c.getName();
        int i = fqName.lastIndexOf(46);
        String name = i > 0 ? fqName.substring(i + 1) : fqName;
        return name;
    }

    private List<FormatSpecifier> parse(String s) {
        ArrayList<FormatSpecifier> sl = new ArrayList<FormatSpecifier>();
        Matcher m = SPECIFIER_PATTERN.matcher(s);
        int i = 0;
        while (i < s.length()) {
            if (m.find(i)) {
                if (m.start() != i) {
                    this.checkText(s.substring(i, m.start()));
                }
                String[] sa = new String[6];
                for (int j = 0; j < m.groupCount(); ++j) {
                    sa[j] = m.group(j + 1);
                }
                sl.add(new FormatSpecifier(sa));
                i = m.end();
                continue;
            }
            this.checkText(s.substring(i));
            break;
        }
        return sl;
    }

    private void checkText(String s) {
        int idx = s.indexOf(37);
        if (idx != -1) {
            char c = idx > s.length() - 2 ? (char)'%' : (char)s.charAt(idx + 1);
            throw new UnknownFormatConversionException(String.valueOf(c));
        }
    }

    protected static String quote(String s) {
        return "\"" + s + "\"";
    }
}

