/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.build.tools.messages;

import com.unboundid.messages.Category;
import com.unboundid.messages.Severity;
import java.util.EnumSet;

public class MessagePropertyKey
implements Comparable<MessagePropertyKey> {
    private Category category;
    private Severity severity;
    private String description;
    private Integer ordinal;

    public static MessagePropertyKey parseString(String keyString, boolean includesCategory, boolean includesSeverity, boolean includesOrdinal) {
        String description;
        Category category = null;
        Severity severity = null;
        Integer ordinal = null;
        String k = keyString;
        for (Category c : EnumSet.allOf(Category.class)) {
            String cName = c.name();
            if (!k.startsWith(cName)) continue;
            category = c;
            if ('_' != k.charAt(cName.length())) {
                throw new IllegalArgumentException("Error processing " + keyString + ".  Category must be " + "separated from the rest of the " + "key with an '_' character");
            }
            k = k.substring(cName.length() + 1);
            break;
        }
        if (category == null && includesCategory) {
            throw new IllegalArgumentException("Category not included in key " + keyString);
        }
        for (Severity s : EnumSet.allOf(Severity.class)) {
            String sName = s.propertyKeyFormName();
            if (!k.startsWith(sName)) continue;
            severity = s;
            if ('_' != k.charAt(sName.length())) {
                throw new IllegalArgumentException("Error processing " + keyString + ".  Severity must be " + "separated from the rest of the " + "key with an '_' character");
            }
            k = k.substring(sName.length() + 1);
            break;
        }
        if (severity == null && includesSeverity) {
            throw new IllegalArgumentException("Severity not included in key " + keyString);
        }
        if (includesOrdinal) {
            int li = k.lastIndexOf("_");
            if (li == -1) {
                throw new IllegalArgumentException("Incorrectly formatted key " + keyString);
            }
            description = k.substring(0, li).toUpperCase();
            try {
                String ordString = k.substring(li + 1);
                ordinal = Integer.parseInt(ordString);
            }
            catch (Exception nfe) {
                throw new IllegalArgumentException("Error parsing ordinal for key " + keyString);
            }
        } else {
            description = k;
        }
        return new MessagePropertyKey(category, severity, description, ordinal);
    }

    public MessagePropertyKey(Category category, Severity severity, String description, Integer ordinal) {
        this.category = category;
        this.severity = severity;
        this.description = description;
        this.ordinal = ordinal;
    }

    public Category getCategory() {
        return this.category;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getOrdinal() {
        return this.ordinal;
    }

    public String getMessageDescriptorName() {
        return this.severity.messageDesciptorName() + "_" + this.description;
    }

    public String toString() {
        return this.getPropertyKeyName(true, true, true);
    }

    public String getPropertyKeyName(boolean includeCategory, boolean includeSeverity, boolean includeOrdinal) {
        StringBuilder sb = new StringBuilder();
        if (this.category != null && includeCategory) {
            sb.append(this.category.name());
            sb.append("_");
        }
        if (this.severity != null && includeSeverity) {
            sb.append(this.severity.propertyKeyFormName());
            sb.append("_");
        }
        sb.append(this.description);
        if (this.ordinal != null && includeOrdinal) {
            sb.append("_");
            sb.append(this.ordinal);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(MessagePropertyKey k) {
        if (this.ordinal == k.ordinal) {
            return this.description.compareTo(k.description);
        }
        return this.ordinal.compareTo(k.ordinal);
    }
}

