/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.messages;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public enum Category {
    CORE(0),
    EXTENSIONS(0x100000),
    PROTOCOL(0x200000),
    CONFIG(0x300000),
    LOG(0x400000),
    UTIL(0x500000),
    SCHEMA(0x600000),
    PLUGIN(0x700000),
    JEB(0x800000),
    BACKEND(0x900000),
    TOOLS(0xA00000),
    TASK(0xB00000),
    ACCESS_CONTROL(0xC00000),
    ADMIN(0xD00000),
    REPLICATION(0xE00000),
    VERSION(0xF00000),
    QUICKSETUP(0x1000000),
    ADMIN_TOOL(0x1100000),
    DSCONFIG(0x1200000),
    RUNTIME_INFORMATION(0x1300000),
    UBID_CORE(0x70000000),
    UBID_EXTENSIONS(0x70100000),
    UBID_PROTOCOL(0x70200000),
    UBID_CONFIG(0x70300000),
    UBID_LOG(0x70400000),
    UBID_UTIL(0x70500000),
    UBID_SCHEMA(0x70600000),
    UBID_PLUGIN(0x70700000),
    UBID_JEB(0x70800000),
    UBID_BACKEND(0x70900000),
    UBID_TOOLS(0x70A00000),
    UBID_EXAMINER(1889599488),
    UBID_TASK(0x70B00000),
    UBID_ACCESS_CONTROL(0x70C00000),
    UBID_ADMIN(0x70D00000),
    UBID_SYNC(0x70E00000),
    UBID_VERSION(0x70F00000),
    UBID_QUICKSETUP(0x71000000),
    UBID_ADMIN_TOOL(0x71100000),
    UBID_DSCONFIG(1897922560),
    UBID_PROXY(1898971136),
    UBID_REPLICATION(118751232),
    UBID_UPDATE(118816768),
    UBID_CONSOLE(118882304),
    UBID_CONSOLE_TOOLS(0x7170000),
    UBID_COMMON(119013376),
    UBID_METRIC(119078912),
    UBID_ID_SERVER(119144448),
    UBID_MONITORING(119209984),
    UBID_AUTHORIZATION(119275520),
    THIRD_PARTY(Integer.MIN_VALUE),
    COMPONENTS(-2146435072),
    USER_DEFINED(-1048576);

    private static final Map<Integer, Category> MASK_VALUE_MAP;
    private static final Map<String, Set<Category>> CATEGORIES_BY_DISPLAY_NAME;
    private final int mask;
    private final String displayName;

    public static Category parseMessageId(int msgId) {
        return Category.parseMask(msgId & 0xFFF00000);
    }

    public static Category parseMask(int mask) {
        return MASK_VALUE_MAP.get(mask);
    }

    public static Set<Category> getCategoriesWithDisplayName(String displayName) throws IllegalArgumentException, NullPointerException {
        if (displayName == null) {
            throw new NullPointerException();
        }
        Set<Category> categories = CATEGORIES_BY_DISPLAY_NAME.get(displayName);
        if (categories == null) {
            throw new IllegalArgumentException("No categories have a displayName of " + displayName);
        }
        return categories;
    }

    public int getMask() {
        return this.mask;
    }

    private Category(int intValue) {
        this.mask = intValue;
        this.displayName = this.name().replaceFirst("^UBID_", "");
    }

    public String toString() {
        return this.displayName;
    }

    static {
        MASK_VALUE_MAP = new HashMap<Integer, Category>();
        LinkedHashSet<String> displayNames = new LinkedHashSet<String>();
        for (Category c : EnumSet.allOf(Category.class)) {
            MASK_VALUE_MAP.put(c.mask, c);
            displayNames.add(c.displayName);
        }
        LinkedHashMap categoriesByDisplayName = new LinkedHashMap();
        for (String displayName : displayNames) {
            LinkedHashSet<Category> categories = new LinkedHashSet<Category>();
            for (Category c : EnumSet.allOf(Category.class)) {
                if (!c.displayName.equals(displayName)) continue;
                categories.add(c);
            }
            categoriesByDisplayName.put(displayName, Collections.unmodifiableSet(categories));
        }
        CATEGORIES_BY_DISPLAY_NAME = Collections.unmodifiableMap(categoriesByDisplayName);
    }
}

