/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.messages;

import com.unboundid.messages.TokenReplacer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CommonTokenReplacer
implements TokenReplacer,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final CommonTokenReplacer INSTANCE;
    private boolean initialized = false;
    private Map<String, String> tokenMap = new HashMap<String, String>();

    public void initialize(InputStream tokens) {
        Properties p = new Properties();
        try {
            p.load(tokens);
            for (Object key : p.keySet()) {
                Object v = p.get(key);
                if (v == null) continue;
                this.tokenMap.put(key.toString(), v.toString());
            }
            this.initialized = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public String replaceTokens(String s) {
        if (!s.contains("${")) {
            return s;
        }
        for (String key : this.tokenMap.keySet()) {
            s = s.replace("${" + key + "}", this.tokenMap.get(key));
        }
        return s;
    }

    static {
        File productProperties;
        INSTANCE = new CommonTokenReplacer();
        String serverRootPath = System.getProperty("com.unboundid.directory.server.ServerRoot");
        if (serverRootPath == null) {
            serverRootPath = System.getenv("INSTANCE_ROOT");
        }
        if (serverRootPath != null && (productProperties = new File(serverRootPath, "config/update/product.properties")).exists()) {
            try {
                FileInputStream fis = new FileInputStream(productProperties);
                INSTANCE.initialize(fis);
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

