/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.messages;

import com.unboundid.messages.Category;
import com.unboundid.messages.MessageBuilder;
import com.unboundid.messages.MessageDescriptor;
import com.unboundid.messages.Severity;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Formattable;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Message
implements CharSequence,
Formattable,
Comparable<Message>,
Externalizable {
    public static final Message EMPTY = Message.raw("", new Object[0]);
    private static boolean isAIXPost5 = Message.isAIXPost5();
    private static Pattern DESCRIPTOR_REFERENCE_PATTERN = Pattern.compile("^((\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\.([A-Z][A-Z0-9_]*)$");
    private MessageDescriptor descriptor;
    private Object[] args;
    private transient String toStringValue;
    private transient Locale toStringValueLocale;

    public static Message from(String textOrDescriptor, Object ... messageArguments) {
        if (textOrDescriptor == null) {
            return null;
        }
        Matcher matcher = DESCRIPTOR_REFERENCE_PATTERN.matcher(textOrDescriptor);
        if (matcher.matches()) {
            return Message.from(matcher.group(1), matcher.group(3), messageArguments);
        }
        return Message.raw(textOrDescriptor, messageArguments);
    }

    public static Message parse(String tokenString) throws ParseException {
        if (tokenString == null) {
            return null;
        }
        MessageBuilder sb = new MessageBuilder();
        String s = tokenString;
        while (s.contains("${")) {
            int closingBracketIndex;
            int openBracketIndex = s.indexOf("${");
            if (openBracketIndex > 1) {
                sb.append(s.substring(0, openBracketIndex));
            }
            if ((closingBracketIndex = (s = s.substring(openBracketIndex + 2)).indexOf("}")) > 0) {
                String messageDescriptorString = s.substring(0, closingBracketIndex);
                sb.append(Message.from(messageDescriptorString, new Object[0]));
                s = s.substring(closingBracketIndex + 1);
                continue;
            }
            throw new ParseException("No closing bracket for open bracket", openBracketIndex);
        }
        sb.append(s);
        return sb.toMessage();
    }

    public static Message raw(CharSequence formatString, Object ... args) {
        Message message = null;
        if (formatString != null) {
            message = Message.messageContainsUnintentionalFormatting(formatString, args) ? new MessageDescriptor.Raw("%s").get(formatString) : new MessageDescriptor.Raw(formatString).get(args);
        }
        return message;
    }

    public static Message raw(Category category, Severity severity, CharSequence formatString, Object ... args) {
        Message message = null;
        if (formatString != null) {
            if (Message.messageContainsUnintentionalFormatting(formatString, args)) {
                MessageDescriptor.Raw md = new MessageDescriptor.Raw((CharSequence)"%s", category, severity);
                message = md.get(formatString);
            } else {
                MessageDescriptor.Raw md = new MessageDescriptor.Raw(formatString, category, severity);
                message = md.get(args);
            }
        }
        return message;
    }

    public static Message fromObject(Object object, Object ... arguments) {
        Message message = null;
        if (object != null) {
            String cs = object.toString();
            message = Message.raw(cs, arguments);
        }
        return message;
    }

    public static String toString(Message message) {
        return message != null ? message.toString() : null;
    }

    static Message raw(MessageDescriptor md, CharSequence formatString, Object ... args) {
        Message message = null;
        if (formatString != null) {
            if (Message.messageContainsUnintentionalFormatting(formatString, args)) {
                MessageDescriptor.Raw rawMd = new MessageDescriptor.Raw(md, "%s");
                message = rawMd.get(formatString);
            } else {
                MessageDescriptor.Raw rawMd = new MessageDescriptor.Raw(md, formatString);
                message = rawMd.get(args);
            }
        }
        return message;
    }

    private static Message from(String declarationClassName, String descriptorName, Object ... messageArguments) {
        Message message = null;
        if (declarationClassName == null) {
            return null;
        }
        String className = !declarationClassName.startsWith("com.unboundid.messages.") ? "com.unboundid.messages." + declarationClassName : declarationClassName;
        try {
            Class<?> declarationClass = Class.forName(className);
            Field field = declarationClass.getField(descriptorName);
            MessageDescriptor descriptor = (MessageDescriptor)field.get(null);
            if (declarationClass != null) {
                Method getMethod = null;
                for (Method m : descriptor.getClass().getMethods()) {
                    if (!m.getName().equals("get")) continue;
                    getMethod = m;
                    break;
                }
                if (getMethod != null) {
                    message = MessageDescriptor.ArgN.class.equals(descriptor.getClass()) ? (Message)getMethod.invoke((Object)descriptor, new Object[]{messageArguments}) : (Message)getMethod.invoke((Object)descriptor, messageArguments);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (message == null) {
            message = Message.raw(String.valueOf(declarationClassName) + "." + String.valueOf(descriptorName), new Object[0]);
        }
        return message;
    }

    public Object[] getArguments() {
        return this.args;
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        String s;
        block12: {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (this.toStringValue != null && locale.equals(this.toStringValueLocale)) {
                return this.toStringValue;
            }
            String fmt = this.descriptor.getFormatString(locale);
            if (this.descriptor.requiresFormatter()) {
                try {
                    if (isAIXPost5) {
                        boolean changeType = false;
                        for (Object o : this.args) {
                            if (!(o instanceof Formattable)) continue;
                            changeType = true;
                            break;
                        }
                        if (changeType) {
                            Object[] newArgs = new Object[this.args.length];
                            for (int i = 0; i < this.args.length; ++i) {
                                newArgs[i] = this.args[i] instanceof Formattable ? this.args[i].toString() : this.args[i];
                            }
                            s = new Formatter(locale).format(locale, fmt, newArgs).toString();
                        } else {
                            s = new Formatter(locale).format(locale, fmt, this.args).toString();
                        }
                        break block12;
                    }
                    s = new Formatter(locale).format(locale, fmt, this.args).toString();
                }
                catch (IllegalFormatException e) {
                    s = fmt;
                }
            } else {
                s = fmt;
            }
        }
        if (s == null) {
            s = "";
        }
        this.toStringValue = s;
        this.toStringValueLocale = locale;
        return s;
    }

    public MessageDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int length() {
        return this.length(Locale.getDefault());
    }

    public byte[] getBytes() {
        return this.toString().getBytes();
    }

    @Override
    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.charAt(Locale.getDefault(), index);
    }

    @Override
    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        return this.subSequence(Locale.getDefault(), start, end);
    }

    public int length(Locale locale) {
        return this.toString(locale).length();
    }

    public char charAt(Locale locale, int index) throws IndexOutOfBoundsException {
        return this.toString(locale).charAt(index);
    }

    public CharSequence subSequence(Locale locale, int start, int end) throws IndexOutOfBoundsException {
        return this.toString(locale).subSequence(start, end);
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) throws IllegalFormatException {
        Locale l = formatter.locale();
        formatter.format(l, this.descriptor.getFormatString(l), this.args);
    }

    public Message() {
    }

    Message(MessageDescriptor descriptor, Object ... args) {
        this.descriptor = descriptor;
        this.args = args;
    }

    @Override
    public int compareTo(Message o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean isError() {
        boolean isError = false;
        MessageDescriptor desc = this.getDescriptor();
        if (desc != null) {
            Severity sev = desc.getSeverity();
            isError = Severity.MILD_ERROR.equals((Object)sev) || Severity.SEVERE_ERROR.equals((Object)sev) || Severity.FATAL_ERROR.equals((Object)sev);
        }
        return isError;
    }

    public boolean isWarning() {
        boolean isWarning = false;
        MessageDescriptor desc = this.getDescriptor();
        if (desc != null) {
            Severity sev = desc.getSeverity();
            isWarning = Severity.MILD_WARNING.equals((Object)sev) || Severity.SEVERE_WARNING.equals((Object)sev);
        }
        return isWarning;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return this.toString().equals(message.toString());
    }

    public int hashCode() {
        int result = 31 * this.toString().hashCode();
        return result;
    }

    private static boolean isAIXPost5() {
        boolean isJDK15 = false;
        try {
            String javaRelease = System.getProperty("java.version");
            isJDK15 = javaRelease.startsWith("1.5");
        }
        catch (Throwable t) {
            System.err.println("Cannot get the java version: " + t);
        }
        boolean isAIX = "aix".equalsIgnoreCase(System.getProperty("os.name"));
        return !isJDK15 && isAIX;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.descriptor);
        out.writeObject(this.args);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.descriptor = (MessageDescriptor)in.readObject();
        this.args = (Object[])in.readObject();
    }

    private static boolean messageContainsUnintentionalFormatting(CharSequence formatString, Object ... args) {
        String str = formatString.toString();
        if (args.length == 0 && !MessageDescriptor.containsArgumentLiterals(str)) {
            return str.contains("%");
        }
        return false;
    }
}

