/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.messages;

import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import com.unboundid.messages.TokenReplacer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public abstract class MessageDescriptor
implements Externalizable {
    public static final int NULL_ID = -1;
    public static final int DESCRIPTOR_MAX_ARG_HANDLER = 11;
    public static final String DESCRIPTOR_CLASS_BASE_NAME = "Arg";
    public static Externalizer EXTERNALIZER = new Externalizer();
    protected String rbBase;
    protected String key;
    protected Category category;
    protected Integer mask;
    protected Severity severity;
    protected Integer ordinal;
    protected ClassLoader classLoader;
    protected TokenReplacer tokenReplacer;
    private final Map<Locale, String> formatStrMap = new ConcurrentHashMap<Locale, String>();

    public final Category getCategory() {
        return this.category;
    }

    public final Severity getSeverity() {
        return this.severity;
    }

    public final int getOrdinal() {
        if (this.ordinal == null) {
            return 0;
        }
        return this.ordinal;
    }

    public final int getId() {
        if (this.ordinal == null) {
            return -1;
        }
        return this.ordinal | this.category.getMask() | this.severity.getMask();
    }

    public final int getMask() {
        if (this.mask != null) {
            return this.mask;
        }
        return this.category.getMask();
    }

    public final String getKey() {
        return this.key;
    }

    public final String getBase() {
        return this.rbBase;
    }

    public final TokenReplacer getTokenReplacer() {
        return this.tokenReplacer;
    }

    abstract boolean requiresFormatter();

    public final String getFormatString() {
        return this.getFormatString(Locale.getDefault());
    }

    String getFormatString(Locale locale) {
        String fmtStr;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((fmtStr = this.formatStrMap.get(locale)) == null) {
            ResourceBundle bundle = this.getBundle(locale);
            try {
                fmtStr = bundle.getString(this.getKey());
            }
            catch (Exception ignore) {
                fmtStr = this.getKey();
            }
            if (this.tokenReplacer != null) {
                if (this.tokenReplacer.isInitialized()) {
                    fmtStr = this.tokenReplacer.replaceTokens(fmtStr);
                    this.formatStrMap.put(locale, fmtStr);
                }
            } else {
                this.formatStrMap.put(locale, fmtStr);
            }
        }
        return fmtStr;
    }

    String getRawFormatString(Locale locale) {
        return this.getBundle(locale).getString(this.key);
    }

    protected static boolean containsArgumentLiterals(String s) {
        return s.contains("%%") || s.contains("%n");
    }

    private ResourceBundle getBundle(Locale locale) {
        ClassLoader loader;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((loader = this.classLoader) == null && (loader = Thread.currentThread().getContextClassLoader()) == null && (loader = this.getClass().getClassLoader()) == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(this.rbBase, locale, loader);
    }

    public MessageDescriptor() {
    }

    private MessageDescriptor(String rbBase, String key, Category category, Severity severity, Integer ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
        if (category == null) {
            throw new NullPointerException("Null Category value for message descriptor with key " + key);
        }
        if (severity == null) {
            throw new NullPointerException("Null Severity value for message descriptor with key " + key);
        }
        this.rbBase = rbBase;
        this.key = key;
        this.category = category;
        this.severity = severity;
        this.ordinal = ordinal;
        this.classLoader = classLoader;
        this.mask = null;
        this.tokenReplacer = tokenReplacer;
    }

    private MessageDescriptor(String rbBase, String key, int mask, Severity severity, Integer ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
        if (severity == null) {
            throw new NullPointerException("Null Severity value for message descriptor with key " + key);
        }
        this.rbBase = rbBase;
        this.key = key;
        this.category = Category.USER_DEFINED;
        this.severity = severity;
        this.ordinal = ordinal;
        this.classLoader = classLoader;
        this.mask = mask;
        this.tokenReplacer = tokenReplacer;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        EXTERNALIZER.writeExternal(this, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        EXTERNALIZER.readExternal(this, in);
    }

    public static final class Raw
    extends MessageDescriptor {
        protected String formatString;
        private transient Boolean requiresFormatter;

        public Raw() {
        }

        Raw(CharSequence formatString) {
            this(formatString, Category.USER_DEFINED, Severity.INFORMATION);
        }

        Raw(MessageDescriptor template, CharSequence formatString) {
            super(null, null, template.getCategory(), template.getSeverity(), (Integer)template.getOrdinal(), null, null);
            this.formatString = formatString != null ? formatString.toString() : "";
        }

        Raw(CharSequence formatString, Category category, Severity severity) {
            super(null, null, category, severity, null, null, null);
            this.formatString = formatString != null ? formatString.toString() : "";
        }

        Raw(CharSequence formatString, int mask, Severity severity) {
            super(null, null, mask, severity, null, null, null);
            this.formatString = formatString != null ? formatString.toString() : "";
        }

        Raw(CharSequence formatString, int mask, Severity severity, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(null, null, mask, severity, null, classLoader, tokenReplacer);
            this.formatString = formatString != null ? formatString.toString() : "";
        }

        public Message get(Object ... args) {
            return new Message(this, args);
        }

        @Override
        String getFormatString(Locale locale) {
            return this.formatString;
        }

        @Override
        boolean requiresFormatter() {
            if (this.requiresFormatter == null) {
                this.requiresFormatter = this.formatString.matches(".*%.*");
            }
            return this.requiresFormatter;
        }

        public int hashCode() {
            return 961 * String.valueOf(this.getBase()).hashCode() + this.getFormatString().hashCode() + this.getId();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Raw)) {
                return false;
            }
            Raw that = (Raw)obj;
            return String.valueOf(this.getBase()).equals(String.valueOf(that.getBase())) && this.getCategory().equals((Object)that.getCategory()) && this.getId() == that.getId() && this.getFormatString().equals(that.getFormatString());
        }
    }

    public static final class ArgN
    extends MessageDescriptor {
        public ArgN(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public ArgN(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public ArgN() {
        }

        public Message get(Object ... args) {
            return new Message(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>
    extends MessageDescriptor {
        public Arg11(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg11(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg11() {
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, T10 a10, T11 a11) {
            return new Message(this, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>
    extends MessageDescriptor {
        public Arg10(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg10(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg10() {
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9, T10 a10) {
            return new Message(this, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9>
    extends MessageDescriptor {
        public Arg9(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg9(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg9() {
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
            return new Message(this, a1, a2, a3, a4, a5, a6, a7, a8, a9);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg8<T1, T2, T3, T4, T5, T6, T7, T8>
    extends MessageDescriptor {
        public Arg8(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg8(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg8() {
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
            return new Message(this, a1, a2, a3, a4, a5, a6, a7, a8);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg7<T1, T2, T3, T4, T5, T6, T7>
    extends MessageDescriptor {
        public Arg7(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg7(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg7() {
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
            return new Message(this, a1, a2, a3, a4, a5, a6, a7);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg6<T1, T2, T3, T4, T5, T6>
    extends MessageDescriptor {
        public Arg6(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg6(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg6() {
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
            return new Message(this, a1, a2, a3, a4, a5, a6);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg5<T1, T2, T3, T4, T5>
    extends MessageDescriptor {
        public Arg5(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg5(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg5() {
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
            return new Message(this, a1, a2, a3, a4, a5);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg4<T1, T2, T3, T4>
    extends MessageDescriptor {
        public Arg4(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg4(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg4() {
        }

        public Message get(T1 a1, T2 a2, T3 a3, T4 a4) {
            return new Message(this, a1, a2, a3, a4);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg3<T1, T2, T3>
    extends MessageDescriptor {
        public Arg3(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg3(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg3() {
        }

        public Message get(T1 a1, T2 a2, T3 a3) {
            return new Message(this, a1, a2, a3);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg2<T1, T2>
    extends MessageDescriptor {
        public Arg2(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg2(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg2() {
        }

        public Message get(T1 a1, T2 a2) {
            return new Message(this, a1, a2);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg1<T1>
    extends MessageDescriptor {
        public Arg1(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg1(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
        }

        public Arg1() {
        }

        public Message get(T1 a1) {
            return new Message(this, a1);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg0
    extends MessageDescriptor {
        private transient Message message;
        private transient Boolean requiresFormat;

        public Arg0() {
        }

        public Arg0(String rbBase, String key, Category category, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, category, severity, (Integer)ordinal, classLoader, tokenReplacer);
            this.message = new Message(this, new Object[0]);
            this.requiresFormat = Arg0.containsArgumentLiterals(this.getFormatString());
        }

        public Arg0(String rbBase, String key, int mask, Severity severity, int ordinal, ClassLoader classLoader, TokenReplacer tokenReplacer) {
            super(rbBase, key, mask, severity, (Integer)ordinal, classLoader, tokenReplacer);
            this.message = new Message(this, new Object[0]);
            this.requiresFormat = Arg0.containsArgumentLiterals(this.getFormatString());
        }

        public Message get() {
            if (this.message == null) {
                this.message = new Message(this, new Object[0]);
            }
            return this.message;
        }

        @Override
        boolean requiresFormatter() {
            if (this.requiresFormat == null) {
                this.requiresFormat = Arg0.containsArgumentLiterals(this.getFormatString());
            }
            return this.requiresFormat;
        }
    }

    public static class Externalizer {
        public void writeExternal(MessageDescriptor md, ObjectOutput out) throws IOException {
            out.writeObject(md.rbBase);
            out.writeObject(md.key);
            out.writeObject((Object)md.category);
            out.writeObject((Object)md.severity);
            out.writeObject(md.ordinal);
            out.writeObject(md.classLoader);
            out.writeObject(md.mask);
            out.writeObject(md.tokenReplacer);
            if (md instanceof Raw) {
                out.writeObject(((Raw)md).formatString);
            }
        }

        public void readExternal(MessageDescriptor md, ObjectInput in) throws IOException, ClassNotFoundException {
            md.rbBase = (String)in.readObject();
            md.key = (String)in.readObject();
            md.category = (Category)((Object)in.readObject());
            md.severity = (Severity)((Object)in.readObject());
            md.ordinal = (Integer)in.readObject();
            md.classLoader = (ClassLoader)in.readObject();
            md.mask = (Integer)in.readObject();
            md.tokenReplacer = (TokenReplacer)in.readObject();
            if (md instanceof Raw) {
                ((Raw)md).formatString = (String)in.readObject();
            }
        }
    }
}

