/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.messages;

import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.MessageBuilder;
import com.unboundid.messages.Severity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MessageUtils {
    public static Message join(Collection<Message> messages) {
        Message message;
        if (messages != null && !messages.isEmpty()) {
            MessageBuilder builder = new MessageBuilder();
            for (Message m : messages) {
                builder.appendSentence(m);
            }
            message = builder.toMessage();
        } else {
            message = Message.EMPTY;
        }
        return message;
    }

    public static Message join(Message ... messages) {
        return messages != null ? MessageUtils.join(Arrays.asList(messages)) : Message.EMPTY;
    }

    public static Message capitalize(Message message) {
        if (message != null && message.length() > 0) {
            String fmtStr = message.getDescriptor().getFormatString();
            Object[] args = message.getArguments();
            if (fmtStr != null && fmtStr.charAt(0) != '%') {
                fmtStr = MessageUtils.capitalize(fmtStr);
            } else if (args != null && args.length > 0 && args[0] instanceof String && ((String)args[0]).length() > 0) {
                args[0] = MessageUtils.capitalize((String)args[0]);
            }
            return Message.raw(message.getDescriptor(), fmtStr, args);
        }
        return message;
    }

    public static Message punctuate(Message message) {
        if (message != null && !MessageUtils.hasEndPunctuation(message.toString())) {
            return new MessageBuilder(message).append(".").toMessage();
        }
        return message;
    }

    public static boolean containsError(Collection<Message> messages) {
        if (messages != null && !messages.isEmpty()) {
            for (Message m : messages) {
                if (!m.isError()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsWarning(Collection<Message> messages) {
        if (messages != null && !messages.isEmpty()) {
            for (Message m : messages) {
                if (!m.isWarning()) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Message> getErrors(Collection<Message> messages) {
        ArrayList<Message> errors = new ArrayList<Message>();
        if (messages != null && !messages.isEmpty()) {
            for (Message m : messages) {
                if (!m.isError()) continue;
                errors.add(m);
            }
        }
        return errors;
    }

    public static List<Message> getWarnings(Collection<Message> messages) {
        ArrayList<Message> warnings = new ArrayList<Message>();
        if (messages != null && !messages.isEmpty()) {
            for (Message m : messages) {
                if (!m.isWarning()) continue;
                warnings.add(m);
            }
        }
        return warnings;
    }

    private static String capitalize(String string) {
        if (string != null && string.length() > 0) {
            StringBuilder sb = new StringBuilder().append(Character.toUpperCase(string.charAt(0)));
            if (string.length() > 1) {
                sb.append(string.substring(1));
            }
            return sb.toString();
        }
        return string;
    }

    private MessageUtils() {
    }

    public static boolean hasEndPunctuation(String test) {
        if (test != null && test.length() > 0) {
            char last = test.charAt(test.length() - 1);
            if (last == '.' || last == '?' || last == '!') {
                return true;
            }
            if ((last == '\"' || last == '\'' || last == ')') && test.length() > 1) {
                return MessageUtils.hasEndPunctuation(test.substring(0, test.length() - 1));
            }
        }
        return false;
    }

    public static List<Message> raw(List<String> raw) {
        return MessageUtils.raw(raw, Category.USER_DEFINED, Severity.INFORMATION);
    }

    public static List<Message> raw(List<String> raw, Category category, Severity severity) {
        if (raw == null) {
            return null;
        }
        ArrayList<Message> messages = new ArrayList<Message>(raw.size());
        for (CharSequence charSequence : raw) {
            messages.add(Message.raw(category, severity, charSequence, new Object[0]));
        }
        return messages;
    }
}

