/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.mon.util;

import com.pingidentity.csd.server.util.FutureCondition;
import com.unboundid.util.WakeableSleeper;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;

public class Utils {
    private static final String VERSION_RE = "[0-9\\.]+";

    public static boolean newer(String v1, String v2) {
        if (System.getProperty("ignoreMetricVersion") != null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (!v1.matches(VERSION_RE) || !v2.matches(VERSION_RE)) {
            return false;
        }
        String[] v1p = v1.split("\\.");
        String[] v2p = v2.split("\\.");
        int v1len = v1p.length;
        int v2len = v2p.length;
        for (int i = 0; i < v1len && i < v2len; ++i) {
            if (Integer.parseInt(v1p[i]) > Integer.parseInt(v2p[i])) {
                return true;
            }
            if (Integer.parseInt(v1p[i]) >= Integer.parseInt(v2p[i])) continue;
            return false;
        }
        return v1len > v2len;
    }

    public static String base64Encode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String encoded = DatatypeConverter.printBase64Binary((byte[])bytes);
        return encoded;
    }

    public static TrustManager getTrustAllCertsTrustManager() {
        try {
            X509TrustManager naiveTrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certs, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certs, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            return naiveTrustManager;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean execFutureCondition(FutureCondition condition) throws Exception {
        long end;
        boolean passed;
        WakeableSleeper sleeper = new WakeableSleeper();
        int attempts = 0;
        long start = System.currentTimeMillis();
        do {
            if (!(passed = condition.testCondition()) && !sleeper.sleep((long)condition.getTimeBetweenTestsMS())) {
                return false;
            }
            end = System.currentTimeMillis();
        } while (!passed && attempts++ <= condition.getMaxAttempts() && (long)condition.getMaxTimeMS() >= end - start);
        return passed;
    }
}

