/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.conf;

import com.pingidentity.csd.server.conf.CSDConfiguration;
import com.pingidentity.csd.server.conf.ConfigurationUtil;
import com.pingidentity.csd.server.conf.DataArchiverConfiguration;
import com.pingidentity.csd.server.conf.PropertyConfiguration;
import com.pingidentity.csd.server.dataarchiver.FileDataArchiver;
import com.pingidentity.csd.server.datacollector.DataCollector;
import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.tools.Configuration;
import com.pingidentity.csd.server.tools.argument.ArgumentConfiguration;
import com.pingidentity.csd.server.tools.argument.BooleanOptionArgument;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public class YamlConfigurationUtil
implements ConfigurationUtil {
    private static final String _RESOLVABLE_VARIABLE_TYPE = "type";
    private static final String _RESOLVABLE_VARIABLE_REFERENCE = "reference";
    private static final String _RESOLVABLE_VARIABLE_PROPERTY = "property";
    private static final String _RESOLVABLE_VARIABLE_ARGUMENT = "argument";
    private static final String _RESOLVABLE_VARIABLE_REGEX = "\\$\\{(?<type>property|argument):(?<reference>.+?)}";
    private static final Pattern _RESOLVABLE_VARIABLE_PATTERN = Pattern.compile("\\$\\{(?<type>property|argument):(?<reference>.+?)}");
    private Map<String, Argument> idToArgumentMap = new HashMap<String, Argument>();
    private Map<String, DataCollector> idToDataCollectorMap = new HashMap<String, DataCollector>();
    private Map<String, FileDataArchiver> idToDataArchiverMap = new HashMap<String, FileDataArchiver>();
    private Map<String, PropertyConfiguration> idToPropertyConfigMap = new HashMap<String, PropertyConfiguration>();
    private Collection<Argument> commandLineArguments = new ArrayList<Argument>();
    private String serverRoot;
    private boolean fipsModeEnabled = false;
    CSDConfiguration conf = null;

    @Override
    public ConfigurationUtil load(String pathToFile) throws IOException, ArgumentException {
        CSDConfiguration tempConf;
        Representer representer = new Representer(new DumperOptions());
        representer.getPropertyUtils().setSkipMissingProperties(true);
        Yaml yaml = new Yaml(representer);
        FileInputStream inputStream = new FileInputStream(new File(pathToFile));
        this.conf = tempConf = (CSDConfiguration)yaml.loadAs((InputStream)inputStream, CSDConfiguration.class);
        this.registerPropertyConfigurations();
        return this;
    }

    @Override
    public List<ArgumentConfiguration> getArgumentConfigurations() {
        return this.conf.getArguments();
    }

    @Override
    public List<DataCollectorConfiguration> getDataCollectorConfigurations() {
        return this.conf.getCollectors();
    }

    @Override
    public List<DataArchiverConfiguration> getDataArchiverConfigurations() {
        return this.conf.getArchivers();
    }

    @Override
    public Argument getArgument(String argumentId) {
        return this.idToArgumentMap.get(argumentId);
    }

    @Override
    public Collection<Argument> getArguments() {
        return this.idToArgumentMap.values();
    }

    @Override
    public Collection<Argument> getCommandlineArguments() {
        return this.commandLineArguments;
    }

    @Override
    public void setCommandlineArguments(Collection<Argument> arguments) {
        this.commandLineArguments.addAll(arguments);
    }

    @Override
    public Map<String, Argument> getIdToArgumentMap() {
        return this.idToArgumentMap;
    }

    @Override
    public DataCollector getDataCollector(String dataCollectorId) {
        return this.idToDataCollectorMap.get(dataCollectorId);
    }

    @Override
    public FileDataArchiver getDataArchiver(String dataArchiverId) {
        return this.idToDataArchiverMap.get(dataArchiverId);
    }

    @Override
    public Collection<DataCollector> getDataCollectors() {
        return this.idToDataCollectorMap.values();
    }

    @Override
    public Collection<FileDataArchiver> getDataArchivers() {
        return this.idToDataArchiverMap.values();
    }

    @Override
    public void registerArgument(String argumentId, Argument argument) {
        this.idToArgumentMap.put(argumentId, argument);
    }

    @Override
    public void registerDataCollector(String dataCollectorId, DataCollector dataCollector) {
        this.idToDataCollectorMap.put(dataCollectorId, dataCollector);
    }

    @Override
    public void registerDataArchiver(String dataArchiverId, FileDataArchiver dataArchiver) {
        this.idToDataArchiverMap.put(dataArchiverId, dataArchiver);
    }

    @Override
    public void resolve(Configuration config) {
        Map<String, Object> configMap = config.getConfiguration();
        try {
            this.resolve(configMap);
        }
        catch (IOException e) {
            System.err.println("ERROR: Exception resolving config!");
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void resolve(ArgumentConfiguration config) {
        Map<String, Object> configMap = config.getConfiguration();
        try {
            this.resolve(configMap);
        }
        catch (IOException e) {
            System.err.println("ERROR: Exception resolving config!");
            e.printStackTrace(System.err);
        }
    }

    public void registerPropertyConfigurations() {
        if (this.conf.getProperties() != null) {
            for (PropertyConfiguration propertyConfiguration : this.conf.getProperties()) {
                this.idToPropertyConfigMap.put(propertyConfiguration.getId(), propertyConfiguration);
            }
        }
    }

    @Override
    public PropertyConfiguration getPropertyConfiguration(String propertyConfigId) {
        return this.idToPropertyConfigMap.get(propertyConfigId);
    }

    @Override
    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    @Override
    public String getServerRoot() {
        return this.serverRoot;
    }

    @Override
    public boolean getFipsModeEnabled() {
        return this.fipsModeEnabled;
    }

    @Override
    public void setFipsModeEnabled(boolean enabled) {
        this.fipsModeEnabled = enabled;
    }

    private void resolve(Map<String, Object> configMap) throws IOException {
        block8: for (String configParam : configMap.keySet()) {
            Matcher matcher;
            Object configValue = configMap.get(configParam);
            if (!(configValue instanceof String) || !(matcher = _RESOLVABLE_VARIABLE_PATTERN.matcher((String)configValue)).matches()) continue;
            String type = matcher.group(_RESOLVABLE_VARIABLE_TYPE);
            String id = matcher.group(_RESOLVABLE_VARIABLE_REFERENCE);
            switch (type) {
                case "property": {
                    throw new IOException("Unable to resolve ${" + type + ":" + id + "}. Resolution of properties not yet implemented");
                }
                case "argument": {
                    Argument argument = this.idToArgumentMap.get(id);
                    if (argument instanceof StringArgument) {
                        configMap.put(configParam, ((StringArgument)argument).getValue());
                        continue block8;
                    }
                    if (argument instanceof BooleanOptionArgument) {
                        configMap.put(configParam, ((BooleanOptionArgument)argument).getValue());
                        continue block8;
                    }
                    if (argument instanceof IntegerArgument) {
                        configMap.put(configParam, ((IntegerArgument)argument).getValue());
                        continue block8;
                    }
                    if (argument instanceof DNArgument) {
                        configMap.put(configParam, ((DNArgument)argument).getValue());
                        continue block8;
                    }
                    if (argument instanceof FileArgument) {
                        configMap.put(configParam, ((FileArgument)argument).getValue());
                        continue block8;
                    }
                    throw new IOException("Unable to resolve ${" + type + ":" + id + "}. Resolved to an unsupported Argument type");
                }
            }
            throw new IOException("Unable to resolve ${" + type + ":" + id + "}. Unrecogized type '" + type + "'");
        }
    }
}

