/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.dataarchiver;

import com.pingidentity.csd.server.dataarchiver.FileDataArchiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class RootDataArchiver {
    private Collection<FileDataArchiver> dataArchivers;
    private Set<String> paths = new HashSet<String>();

    public RootDataArchiver() {
        this.dataArchivers = new ArrayList<FileDataArchiver>();
    }

    public void add(FileDataArchiver dataArchiver) {
        this.dataArchivers.add(dataArchiver);
    }

    public void addAll(Collection<FileDataArchiver> dataArchivers) {
        this.dataArchivers.addAll(dataArchivers);
    }

    public void archive() {
        try {
            for (FileDataArchiver dataArchiver : this.dataArchivers) {
                String uniqueEntryName = dataArchiver.getAbsolutePath();
                int i = 1;
                while (this.pathExists(uniqueEntryName)) {
                    uniqueEntryName = dataArchiver.getAbsolutePath() + "-" + ++i;
                }
                this.paths.add(uniqueEntryName);
                this.archiveFile(uniqueEntryName, dataArchiver);
            }
            this.finish();
        }
        catch (Exception e) {
            System.err.println("Exception caught while archiving data:" + e.getMessage());
            e.printStackTrace(System.err);
            this.finish();
            this.deleteArchive();
        }
    }

    private boolean pathExists(String absolutePath) {
        return this.paths.contains(absolutePath);
    }

    abstract void archiveFile(String var1, FileDataArchiver var2) throws Exception;

    abstract void deleteArchive();

    abstract void finish();
}

