/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.dataarchiver;

import com.pingidentity.csd.server.dataarchiver.FileDataArchiver;
import com.pingidentity.csd.server.dataarchiver.RootDataArchiver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipRootArchiver
extends RootDataArchiver {
    private String absoluteZipPath;
    private ZipOutputStream zipOutputStream;

    public ZipRootArchiver(String absoluteZipPath) throws IOException {
        this.absoluteZipPath = absoluteZipPath;
        this.zipOutputStream = new ZipOutputStream(Files.newOutputStream(Paths.get(absoluteZipPath, new String[0]).normalize(), StandardOpenOption.CREATE_NEW));
    }

    @Override
    void archiveFile(String absolutePath, FileDataArchiver dataArchiver) throws Exception {
        this.zipOutputStream.putNextEntry(new ZipEntry(Paths.get(absolutePath, new String[0]).normalize().toString()));
        dataArchiver.archive(this.zipOutputStream);
    }

    @Override
    void deleteArchive() {
        Path p = Paths.get(this.absoluteZipPath, new String[0]).normalize();
        try {
            Files.delete(p);
        }
        catch (IOException e) {
            System.err.println("Exception caught while attempting to delete archive:" + e.getMessage());
            e.printStackTrace(System.err);
        }
        if (Files.exists(p, new LinkOption[0])) {
            System.err.println("Failed to completely remove " + p.toString());
        }
    }

    @Override
    void finish() {
        if (this.zipOutputStream != null) {
            try {
                this.zipOutputStream.flush();
                this.zipOutputStream.close();
            }
            catch (IOException ioe) {
                System.err.println("Exception caught while attempting to close archive output stream:" + ioe.getMessage());
                ioe.printStackTrace(System.err);
            }
        }
    }
}

