/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.config;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.config.MessageDataCollectorConfiguration;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class LDAPCommandDataCollectorConfiguration
extends MessageDataCollectorConfiguration {
    private final String UNIX_COMMAND_KEY = "unix_command";
    private final String WINDOWS_COMMAND_KEY = "windows_command";
    private final String ARG_KEY = "args";
    private final String ROOT_KEY = "root";
    private final List REQUIRED_KEYS = Collections.unmodifiableList(Arrays.asList("unix_command", "windows_command", "args", "root"));

    public LDAPCommandDataCollectorConfiguration(DataCollectorConfiguration dataCollectorConfiguration) {
        super(dataCollectorConfiguration);
    }

    public File getUnixCommand() throws IllegalArgumentException {
        String serverRoot = this.getStringParam("root");
        String commandFile = this.getStringParam("unix_command");
        return new File(serverRoot, commandFile);
    }

    public File getWindowsCommand() throws IllegalArgumentException {
        String serverRoot = this.getStringParam("root");
        String commandFile = this.getStringParam("windows_command");
        return new File(serverRoot, commandFile);
    }

    public String getArgs() {
        return this.getStringParam("args");
    }

    @Override
    public boolean isValidConfiguration() {
        return this.getConfiguration().keySet().containsAll(this.REQUIRED_KEYS);
    }

    public List getRequiredKeys() {
        return this.REQUIRED_KEYS;
    }
}

