/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.server.datacollector.DataCollector;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.unboundid.csd.messages.QuickSetupMessages;
import com.unboundid.messages.Message;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class DataCollectorTask
extends DataCollector {
    protected Message message;
    private final Thread workerThread;

    @Override
    public Message getMessage() {
        return this.message;
    }

    private void setMessage(Message message) {
        this.message = message;
    }

    @Override
    public synchronized void start() {
        assert (this.startTime == -1L);
        this.startTime = System.currentTimeMillis();
        this.workerThread.start();
    }

    public DataCollectorTask(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Message message) {
        this(collectSupportData, name, zipParent, message, DataCollectorFileType.DEFAULT);
    }

    public DataCollectorTask(CollectSupportData collectSupportData, final String name, CollectSupportData.ZipParentPath zipParent, Message message, DataCollectorFileType fileType) {
        super(collectSupportData, name, zipParent, fileType);
        this.collectSupportData = collectSupportData;
        this.message = message;
        this.workerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DataCollectorTask.this.writeData();
                }
                catch (Throwable t) {
                    DataCollectorTask.this.setMessage(QuickSetupMessages.INFO_PROGRESS_ERROR.get());
                    DataCollectorTask.this.log("Error writing data for " + name, t);
                    DataCollectorTask.this.writeln(t);
                }
                DataCollectorTask.this.log("Finished " + name);
                DataCollectorTask.this.stopTime = System.currentTimeMillis();
            }
        }, "DataCollector " + name + " Worker");
        this.workerThread.setDaemon(true);
    }

    protected void writeln(Throwable t) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        t.printStackTrace(printWriter);
        try {
            this.writeln(((Object)result).toString());
        }
        catch (Exception ioe) {
            this.collectSupportData.log("Error writing stack trace to file", ioe);
        }
    }

    protected void writeln() throws Exception {
        this.write(CollectSupportData.EOL);
    }

    protected void writeln(String data) throws Exception {
        this.write(data);
        this.write(CollectSupportData.EOL);
    }

    protected synchronized void write(String data) throws Exception {
        if (data != null) {
            this.commandOutput.write(CollectSupportData.getBytes(data));
        }
    }

    protected abstract void writeData() throws Exception;
}

