/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.server.datacollector.config.GCContextDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.types.OperatingSystem;
import com.unboundid.messages.Message;

public class GCContextCollector
extends DataCollectorTask {
    private final String SEARCH_LOGS_BAT = "/bat/search-logs.bat";
    private final String SEARCH_LOGS_SH = "/bin/search-logs";
    private CollectSupportData collectSupportData;
    private String logLocation;

    public GCContextCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Message message, String logLocation) {
        super(collectSupportData, name, zipParent, message);
        this.collectSupportData = collectSupportData;
        this.logLocation = logLocation;
    }

    public GCContextCollector(CollectSupportData collectSupportData, GCContextDataCollectorConfiguration gcContextDataCollectorConfiguration) {
        super(collectSupportData, gcContextDataCollectorConfiguration.getId(), gcContextDataCollectorConfiguration.getZipParentPathAsEnum(), gcContextDataCollectorConfiguration.getMessage());
        this.logLocation = gcContextDataCollectorConfiguration.getLogLocation();
    }

    @Override
    protected void writeData() throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        String command = this.collectSupportData.getOs() == OperatingSystem.WINDOWS ? this.collectSupportData.getServerRoot() + "/bat/search-logs.bat" : this.collectSupportData.getServerRoot() + "/bin/search-logs";
        processBuilder.command(command, "--logdir", this.logLocation, "--useRegex", "--excludePattern", "concurrent", "--ignoreCase", "--noFileName", "--beforeContext", "2", "real=[1-9]");
        try {
            this.createAndStartProcess(processBuilder, false, 1000000);
        }
        catch (InterruptedException ie) {
            this.collectSupportData.log("Interrupted config diff data collector: " + this.getName(), ie);
        }
        catch (Exception e) {
            this.collectSupportData.log("Error collecting output for " + this.getName() + e.getMessage());
        }
    }
}

