/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.pa;

import com.pingidentity.csd.mon.util.Utils;
import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.XMLOutput;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.exception.ExceptionUtils;

public class PAClusterDataCollector
extends DataCollectorTask {
    private String paBaseDir;

    public PAClusterDataCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration.getId(), configuration.getZipParentPathAsEnum(), null, DataCollectorFileType.XML);
        this.paBaseDir = configuration.getStringParam("root");
    }

    @Override
    protected void writeData() throws Exception {
        this.writeln("<clustertestresults>");
        this.collectData();
        this.collectDataUsingBootstrapProperties();
        this.writeln("</clustertestresults>");
    }

    private void collectData() throws Exception {
        Properties runDotProps = new Properties();
        File runDotPropertiesFile = new File(this.paBaseDir + File.separator + "conf" + File.separator + "run.properties");
        try {
            runDotProps.load(new FileReader(runDotPropertiesFile));
        }
        catch (IOException e) {
            this.writeln("<error>\r\n<message>Error loading PingAccess run.properties file</message>\r\n<exception>");
            this.writeln(XMLOutput.escapeXML(e.getMessage()));
            this.writeln("</exception>\r\n</error>");
            this.log("Error loading PingAccess run.properties file. Can't continue", e);
            return;
        }
        String paInterprocCommunication = runDotProps.getProperty("pa.cluster.interprocess.communication");
        if (!"tcp".equals(paInterprocCommunication)) {
            this.writeln("<error>\r\n<message>PingAccess is not configured to use tcp clustering. pa.cluster.interprocess.communication is set to '" + paInterprocCommunication + "'</message>\r\n<exception></exception>\r\n</error>\r\n");
            this.log("PingAccess is not configured to use tcp clustering. pa.cluster.interprocess.communication is set to '" + paInterprocCommunication + "'");
            return;
        }
        String initialDiscoveryHosts = runDotProps.getProperty("pa.cluster.tcp.discovery.initial.hosts");
        if (initialDiscoveryHosts == null || initialDiscoveryHosts.isEmpty()) {
            this.writeln("<error>\r\n<message>PingAccess is using tcp clustering but pa.cluster.tcp.discovery.initial.hosts is not set.</message>\r\n<exception></exception>\r\n</error>\r\n");
            this.log("PingAccess is using tcp clustering but pa.cluster.tcp.discovery.initial.hosts is not set.");
            return;
        }
        String paClusterFailureDetectionPort = runDotProps.getProperty("pa.cluster.failure.detection.bind.port");
        int paClusterFailureDetectionPortNo = -1;
        try {
            paClusterFailureDetectionPortNo = Integer.parseInt(paClusterFailureDetectionPort);
        }
        catch (Exception ex) {
            this.writeln("<error>\r\n<message>PingAccess is in clustered mode but pa.cluster.failure.detection.bind.port is not set.</message>\r\n<exception></exception>\r\n</error>\r\n");
            this.log("PingAccess is in clustered mode but pa.cluster.failure.detection.bind.port is not set.");
        }
        String[] splitInitialDiscoveryHosts = initialDiscoveryHosts.split(",");
        this.testInitialDiscoveryHosts(splitInitialDiscoveryHosts);
    }

    private void collectDataUsingBootstrapProperties() throws Exception {
        this.writeln("<bootstrapdata>");
        Properties bootstrapProps = new Properties();
        String bootstrapPropsPathString = this.paBaseDir + File.separator + "conf" + File.separator + "bootstrap.properties";
        File bootstrapPropsFile = new File(bootstrapPropsPathString);
        if (bootstrapPropsFile.exists()) {
            try {
                bootstrapProps.load(new FileReader(bootstrapPropsFile));
            }
            catch (IOException e) {
                this.writeln("<error>\r\n<message>Error loading PingAccess " + bootstrapPropsPathString + " file</message>\r\n<exception>\r\n" + XMLOutput.escapeXML(ExceptionUtils.getStackTrace((Throwable)e)) + "</exception>\r\n</error>\r\n");
                this.writeln("</bootstrapdata>\r\n");
                this.log("Error loading PingAccess bootstrap.properties. Can't collect bootstrap data.", e);
                return;
            }
        } else {
            this.writeln("<error>\r\n<message>PingAccess bootstrap.properties file does not exist at " + bootstrapPropsPathString + "</message>\r\n</error>\r\n");
            this.writeln("</bootstrapdata>\r\n");
            this.log("PingAccess bootstrap.properties file does not exist at " + bootstrapPropsPathString + ". Can't collect bootstrap data.");
            return;
        }
        String engineConfigHost = bootstrapProps.getProperty("engine.admin.configuration.host") + ":" + bootstrapProps.getProperty("engine.admin.configuration.port");
        boolean plainHttpProxyEnabled = "true".equals(bootstrapProps.getProperty("pa.http.client.proxy.enabled", "false"));
        String plainHttpProxyHost = "";
        int plainProxyPortNo = -1;
        boolean plainHttpProxyAuthEnabled = false;
        String plainHttpProxyUser = "";
        String plainHttpProxyPass = "";
        if (plainHttpProxyEnabled) {
            plainHttpProxyHost = bootstrapProps.getProperty("pa.http.client.proxy.host");
            String plainHttpProxyPort = bootstrapProps.getProperty("pa.http.client.proxy.port", "");
            if (!plainHttpProxyPort.trim().isEmpty()) {
                try {
                    plainProxyPortNo = Integer.parseInt(plainHttpProxyPort);
                }
                catch (Exception ex) {
                    this.log("Invalid pa.http.client.proxy.port setting '" + plainHttpProxyPort + "'in bootstrap.properties. An http proxy will not be used for collecting bootstrap data.", ex);
                    plainHttpProxyEnabled = false;
                }
            } else {
                this.log("pa.http.client.proxy.port is not set in bootstrap.properties. An http proxy will not be used for collecting bootstrap data.");
                plainHttpProxyEnabled = false;
            }
            plainHttpProxyAuthEnabled = "true".equals(bootstrapProps.getProperty("pa.http.client.proxy.requireAuthentication", "false"));
            if (plainHttpProxyAuthEnabled) {
                plainHttpProxyUser = bootstrapProps.getProperty("pa.http.client.proxy.username");
                plainHttpProxyPass = bootstrapProps.getProperty("pa.http.client.proxy.password");
            }
        }
        boolean sslProxyEnabled = "true".equals(bootstrapProps.getProperty("pa.https.client.proxy.enabled", "false"));
        String sslHttpProxyHost = "";
        int sslProxyPortNo = -1;
        boolean sslHttpProxyAuthEnabled = false;
        String sslHttpProxyUser = "";
        String sslHttpProxyPass = "";
        if (sslProxyEnabled) {
            sslHttpProxyHost = bootstrapProps.getProperty("pa.https.client.proxy.port");
            String sslHttpProxyPort = bootstrapProps.getProperty("pa.https.client.proxy.port", "");
            if (!sslHttpProxyPort.trim().isEmpty()) {
                try {
                    sslProxyPortNo = Integer.parseInt(sslHttpProxyPort);
                }
                catch (Exception ex) {
                    this.log("Invalid pa.https.client.proxy.port setting '" + sslHttpProxyPort + "'in bootstrap.properties. An https proxy will not be used for collecting bootstrap data.", ex);
                    sslProxyEnabled = false;
                }
            } else {
                this.log("pa.https.client.proxy.port is not set in bootstrap.properties. An http proxy will not be used for collecting bootstrap data.");
                sslProxyEnabled = false;
            }
            sslHttpProxyAuthEnabled = "true".equals(bootstrapProps.getProperty("pa.https.client.proxy.requireAuthentication", "false"));
            if (plainHttpProxyAuthEnabled) {
                sslHttpProxyUser = bootstrapProps.getProperty("pa.https.client.proxy.username");
                sslHttpProxyPass = bootstrapProps.getProperty("pa.https.client.proxy.password");
            }
        }
        this.writeln("<engineadminconfigurationhost>");
        HttpUrlConnectionResult res = this.testHttpConnection("https://" + engineConfigHost + "/", false, null, -1, false, null, null);
        this.writeln(res.toXML());
        if (plainHttpProxyEnabled) {
            res = this.testHttpConnection("https://" + engineConfigHost + "/", true, plainHttpProxyHost, plainProxyPortNo, plainHttpProxyAuthEnabled, plainHttpProxyUser, plainHttpProxyPass);
            this.writeln(res.toXML());
        }
        if (sslProxyEnabled) {
            res = this.testHttpConnection("https://" + engineConfigHost + "/", true, sslHttpProxyHost, sslProxyPortNo, sslHttpProxyAuthEnabled, sslHttpProxyUser, sslHttpProxyPass);
            this.writeln(res.toXML());
        }
        this.writeln("</engineadminconfigurationhost>\r\n");
        String replicaHostPorts = bootstrapProps.getProperty("engine.replicas.configuration.hostports");
        if (replicaHostPorts != null && !replicaHostPorts.isEmpty() && !"null".equals(replicaHostPorts)) {
            String[] splitReplicaHostPorts;
            this.writeln("<replicahostports>");
            for (String splitReplicaHostPort : splitReplicaHostPorts = replicaHostPorts.split(",")) {
                String replicaHostPortTrimmed;
                if (splitReplicaHostPort == null || (replicaHostPortTrimmed = splitReplicaHostPort.trim()).isEmpty()) continue;
                HttpUrlConnectionResult res2 = this.testHttpConnection("https://" + replicaHostPortTrimmed + "/", false, null, -1, false, null, null);
                this.writeln(res2.toXML());
                if (plainHttpProxyEnabled) {
                    res2 = this.testHttpConnection("https://" + replicaHostPortTrimmed + "/", true, plainHttpProxyHost, plainProxyPortNo, plainHttpProxyAuthEnabled, plainHttpProxyUser, plainHttpProxyPass);
                    this.writeln(res2.toXML());
                }
                if (!sslProxyEnabled) continue;
                res2 = this.testHttpConnection("https://" + replicaHostPortTrimmed + "/", true, sslHttpProxyHost, sslProxyPortNo, sslHttpProxyAuthEnabled, sslHttpProxyUser, sslHttpProxyPass);
                this.writeln(res2.toXML());
            }
            this.writeln("</replicahostports>\r\n");
        }
        this.writeln("</bootstrapdata>\r\n");
    }

    public void testInitialDiscoveryHosts(String[] initialDiscoveryHosts) throws Exception {
        this.writeln("<initialdiscoveryhosts>");
        for (int i = 0; i < initialDiscoveryHosts.length; ++i) {
            this.writeln("<hostresults>");
            this.writeln("<entryinrundotproperties>" + XMLOutput.escapeXML(initialDiscoveryHosts[i]) + "</entryinrundotproperties>");
            String hostPart = null;
            int clusterPortNo = -1;
            try {
                int openingParanPos = initialDiscoveryHosts[i].indexOf(91);
                hostPart = initialDiscoveryHosts[i].substring(0, openingParanPos).trim();
                int closingParanPos = initialDiscoveryHosts[i].indexOf(93);
                String portPart = initialDiscoveryHosts[i].substring(openingParanPos + 1, closingParanPos);
                clusterPortNo = Integer.parseInt(portPart.trim());
            }
            catch (Exception ex) {
                this.writeln("<error>Invalid initial discovery host port definition</error>");
                this.writeln("</hostresults>\r\n");
                this.log("Invalid initial discovery host '" + initialDiscoveryHosts[i] + "'", ex);
                continue;
            }
            if (hostPart == null || clusterPortNo == -1) {
                this.writeln("<error>Invalid initial discovery host port definition</error>");
                this.writeln("</hostresults>");
                this.log("Invalid initial discovery host '" + initialDiscoveryHosts[i] + "'. Skipping.");
                continue;
            }
            this.log("Starting to process initial discovery host entry : '" + initialDiscoveryHosts[i] + "'");
            HostnameResult hostInfoResult = this.collectHostInfo(hostPart);
            this.writeln(hostInfoResult.toXML());
            this.log("Host info : '" + hostInfoResult + "'");
            if (hostInfoResult.valid) {
                SocketConnectionResult clusterPortResult = this.testConnectionToHostPort(hostPart, clusterPortNo);
                this.writeln(clusterPortResult.toXML());
                this.log("Connection test on cluster port: '" + clusterPortResult + "'");
            }
            this.writeln("</hostresults>");
        }
        this.writeln("</initialdiscoveryhosts>");
    }

    private HostnameResult collectHostInfo(String hostPart) {
        HostnameResult rv = new HostnameResult();
        rv.originalHostnameOrIP = hostPart;
        try {
            InetAddress[] inetAddresses = InetAddress.getAllByName(hostPart);
            for (int inetAddressIndex = 0; inetAddressIndex < inetAddresses.length; ++inetAddressIndex) {
                if (hostPart.equals(inetAddresses[inetAddressIndex].getHostAddress())) {
                    rv.reverseDnsName = inetAddresses[inetAddressIndex].getCanonicalHostName();
                    rv.type = HostnameResult.HostnameEntryType.IPAddress;
                    continue;
                }
                rv.ipAddresses.add(inetAddresses[inetAddressIndex].getHostAddress());
                rv.type = HostnameResult.HostnameEntryType.Hostname;
            }
            rv.valid = true;
        }
        catch (UnknownHostException e) {
            rv.exception = e;
            rv.valid = false;
        }
        return rv;
    }

    private SocketConnectionResult testConnectionToHostPort(String hostPart, int clusterPortNo) {
        SocketConnectionResult rv = new SocketConnectionResult();
        rv.host = hostPart;
        rv.port = clusterPortNo;
        try {
            Socket sock = SocketFactory.getDefault().createSocket();
            sock.setSoTimeout(5000);
            long millisBeforeConnect = System.currentTimeMillis();
            sock.connect(new InetSocketAddress(hostPart, clusterPortNo), 5000);
            long millisAfterConnect = System.currentTimeMillis();
            rv.connectionTimeMillis = millisAfterConnect - millisBeforeConnect;
            rv.succeeded = true;
            sock.close();
        }
        catch (SocketTimeoutException ste) {
            rv.exception = ste;
            rv.timedout = true;
        }
        catch (IOException ioe) {
            rv.exception = ioe;
            rv.ioerror = true;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpUrlConnectionResult testHttpConnection(String url, boolean useProxy, String proxyHost, int proxyPort, boolean proxyAuthEnabled, final String proxyUser, final String proxyPass) {
        HttpUrlConnectionResult rv = new HttpUrlConnectionResult();
        rv.url = url;
        URLConnection urlConn = null;
        try {
            HttpsURLConnection httpsConn;
            if (useProxy) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                Authenticator proxyAuth = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
                    }
                };
                Authenticator.setDefault(proxyAuth);
                urlConn = new URL(url).openConnection(proxy);
            } else {
                urlConn = new URL(url).openConnection();
            }
            rv.host = urlConn.getURL().getHost();
            rv.port = urlConn.getURL().getPort();
            HttpURLConnection httpConn = (HttpURLConnection)urlConn;
            httpConn.setConnectTimeout(5000);
            httpConn.setReadTimeout(5000);
            httpConn.setUseCaches(false);
            httpConn.setAllowUserInteraction(false);
            httpConn.setInstanceFollowRedirects(false);
            if (urlConn instanceof HttpsURLConnection) {
                httpsConn = (HttpsURLConnection)urlConn;
                httpsConn.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{this.getTrustAllCertsTrustManager()}, null);
                httpsConn.setSSLSocketFactory(sslContext.getSocketFactory());
                rv.isSsl = true;
            }
            try {
                httpConn.connect();
            }
            catch (SocketTimeoutException innerEx) {
                rv.exception = innerEx;
                rv.status = HttpUrlConnectionResult.StatusValues.FAIL_SOCKET_CONN_TIMEOUT;
            }
            catch (IOException innerEx) {
                rv.exception = innerEx;
                rv.status = HttpUrlConnectionResult.StatusValues.FAIL_SOCKET_CONN;
            }
            rv.httpStatus = httpConn.getResponseCode();
            rv.httpStatusMessage = httpConn.getResponseMessage();
            if (rv.httpStatus > 299 && rv.httpStatus < 400) {
                rv.locationHeader = httpConn.getHeaderField("Location");
            }
            if (urlConn instanceof HttpsURLConnection) {
                httpsConn = (HttpsURLConnection)urlConn;
                rv.peerCerts = httpsConn.getServerCertificates();
                rv.cipherSuite = httpsConn.getCipherSuite();
            }
        }
        catch (Exception ex) {
            rv.exception = ex;
        }
        finally {
            urlConn = null;
        }
        return rv;
    }

    private TrustManager getTrustAllCertsTrustManager() {
        try {
            X509TrustManager naiveTrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certs, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certs, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            return naiveTrustManager;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static class HttpUrlConnectionResult {
        public boolean isSsl;
        public StatusValues status = StatusValues.UNKNOWN;
        public String url;
        public String host;
        public int port;
        public boolean isUsingProxy;
        public String proxyHost;
        public int proxyPort;
        public String proxyUser;
        public String proxyPass;
        public Exception exception;
        public Certificate[] peerCerts;
        public String cipherSuite;
        public int httpStatus;
        public String httpStatusMessage;
        public String locationHeader;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Http Connection Results:");
            sb.append(System.lineSeparator());
            sb.append("  Url:" + this.url);
            sb.append(System.lineSeparator());
            if (this.isUsingProxy) {
                sb.append("  Using Proxy:" + this.proxyHost + ":" + this.proxyPort + " [" + this.proxyUser + ":****]");
                sb.append(System.lineSeparator());
            }
            if (this.exception != null) {
                sb.append("  Error:");
                sb.append(System.lineSeparator());
                sb.append(ExceptionUtils.getStackTrace((Throwable)this.exception));
                sb.append(System.lineSeparator());
            }
            if (this.httpStatus > 0) {
                sb.append("  Response Status:" + this.httpStatus + "/" + this.httpStatusMessage);
                sb.append(System.lineSeparator());
                if (this.httpStatus > 299 && this.httpStatus < 400) {
                    sb.append("  Redirected To:" + this.locationHeader);
                    sb.append(System.lineSeparator());
                }
                if (this.isSsl) {
                    sb.append("  Cipher Suite:" + this.cipherSuite);
                    sb.append(System.lineSeparator());
                    sb.append("  Peer Certificates:");
                    sb.append(System.lineSeparator());
                    for (int i = 0; i < this.peerCerts.length; ++i) {
                        sb.append(System.lineSeparator());
                        sb.append("  Certificate [" + i + "] : ");
                        sb.append(System.lineSeparator());
                        if (this.peerCerts[i] instanceof X509Certificate) {
                            X509Certificate x509Cert = (X509Certificate)this.peerCerts[i];
                            sb.append("    Subject: " + x509Cert.getSubjectX500Principal());
                            sb.append(System.lineSeparator());
                            sb.append("    Serial: " + x509Cert.getSerialNumber().toString());
                            sb.append(System.lineSeparator());
                            sb.append("    Issuer: " + x509Cert.getIssuerX500Principal());
                            sb.append(System.lineSeparator());
                            sb.append("    Signature Algorithm: " + x509Cert.getSigAlgName());
                            sb.append(System.lineSeparator());
                            sb.append("    Valid From: " + x509Cert.getNotBefore());
                            sb.append(System.lineSeparator());
                            sb.append("    Valid Until: " + x509Cert.getNotAfter());
                        } else {
                            sb.append(this.peerCerts[i].toString());
                        }
                        sb.append(System.lineSeparator());
                    }
                }
            }
            return sb.toString();
        }

        public String toXML() {
            StringBuilder sb = new StringBuilder();
            sb.append("<httpconnectionresult>\r\n");
            sb.append("  <cipherSuite>" + XMLOutput.escapeXML(this.cipherSuite) + "</cipherSuite>\r\n");
            if (this.exception != null) {
                sb.append("<exception>");
                sb.append(XMLOutput.escapeXML(ExceptionUtils.getStackTrace((Throwable)this.exception)));
                sb.append("</exception>");
            }
            sb.append("  <host>" + XMLOutput.escapeXML(this.host) + "</host>\r\n");
            sb.append("  <httpStatus>" + this.httpStatus + "</httpStatus>\r\n");
            sb.append("  <httpStatusMessage>" + XMLOutput.escapeXML(this.httpStatusMessage) + "</httpStatusMessage>\r\n");
            sb.append("  <isSsl>" + this.isSsl + "</isSsl>\r\n");
            sb.append("  <isUsingProxy>" + this.isUsingProxy + "</isUsingProxy>\r\n");
            sb.append("  <locationHeader>" + XMLOutput.escapeXML(this.locationHeader) + "</locationHeader>\r\n");
            if (this.peerCerts != null) {
                sb.append("<peerCertificates>\r\n");
                for (int certCounter = 0; certCounter < this.peerCerts.length; ++certCounter) {
                    sb.append("<certificate>\r\n");
                    if (this.peerCerts[certCounter] instanceof X509Certificate) {
                        X509Certificate x509Cert = (X509Certificate)this.peerCerts[certCounter];
                        sb.append("<subject>" + XMLOutput.escapeXML("" + x509Cert.getSubjectX500Principal()) + "</subject>\r\n");
                        sb.append("<serial>" + XMLOutput.escapeXML("" + x509Cert.getSerialNumber()) + "</serial>\r\n");
                        sb.append("<issuer>" + XMLOutput.escapeXML("" + x509Cert.getIssuerX500Principal()) + "</issuer>\r\n");
                        sb.append("<sigalg>" + XMLOutput.escapeXML("" + x509Cert.getSigAlgName()) + "</sigalg>\r\n");
                        sb.append("<encoded>");
                        try {
                            sb.append(XMLOutput.escapeXML(Utils.base64Encode(x509Cert.getEncoded())));
                        }
                        catch (CertificateEncodingException e) {
                            System.out.println("Error encoding peer certificate subject='" + x509Cert.getSubjectX500Principal() + "' serial='" + x509Cert.getSerialNumber() + "': " + e);
                            e.printStackTrace(System.out);
                        }
                        sb.append("</encoded>\r\n");
                    } else {
                        sb.append("<string>");
                        sb.append(XMLOutput.escapeXML(this.peerCerts[certCounter].toString()));
                        sb.append("</string>\r\n");
                    }
                    sb.append("</certificate>\r\n");
                }
                sb.append("</peerCertificates>\r\n");
            }
            sb.append("  <port>" + this.port + "</port>\r\n");
            sb.append("  <proxyHost>" + XMLOutput.escapeXML(this.proxyHost) + "</proxyHost>\r\n");
            sb.append("  <proxyPass>" + (this.proxyPass == null ? "" : "****") + "</proxyPass>\r\n");
            sb.append("  <proxyPort>" + this.proxyPort + "</proxyPort>\r\n");
            sb.append("  <proxyUser>" + XMLOutput.escapeXML(this.proxyUser) + "</proxyUser>\r\n");
            sb.append("  <status>" + (Object)((Object)this.status) + "</status>\r\n");
            sb.append("  <url>" + XMLOutput.escapeXML(this.url) + "</url>\r\n");
            sb.append("</httpconnectionresult>\r\n");
            return sb.toString();
        }

        public static enum StatusValues {
            UNKNOWN,
            FAIL_SOCKET_CONN,
            FAIL_SOCKET_CONN_TIMEOUT,
            FAIL_HOST_RESOLUTION,
            FAIL_SSL_HANDSHAKE,
            SUCCESS;

        }
    }

    public static class SocketConnectionResult {
        public String host;
        public int port;
        public long connectionTimeMillis;
        public Exception exception;
        public boolean succeeded;
        public boolean timedout;
        public boolean ioerror;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Connection to " + this.host + ":" + this.port + " ");
            if (this.succeeded) {
                sb.append("succeeded. Connected in " + this.connectionTimeMillis + " milliseconds");
            } else if (this.timedout) {
                sb.append("timed out with error '");
                sb.append(this.exception.getMessage());
            } else if (this.ioerror) {
                sb.append("failed with error '");
                sb.append(this.exception.getMessage());
            }
            return sb.toString();
        }

        public String toXML() {
            StringBuilder sb = new StringBuilder();
            sb.append("<socketconnection>\r\n");
            sb.append("<host>" + this.host + "</host>\r\n");
            sb.append("<port>" + this.port + "</port>\r\n");
            sb.append("<connectionTimeMillis>" + this.connectionTimeMillis + "</connectionTimeMillis>\r\n");
            sb.append("<succeeded>" + this.succeeded + "</succeeded>\r\n");
            sb.append("<timedout>" + this.timedout + "</timedout>\r\n");
            sb.append("<ioerror>" + this.ioerror + "</ioerror>\r\n");
            if (this.exception != null) {
                sb.append("<exception>" + XMLOutput.escapeXML(this.exception.getMessage()) + "</exception>\r\n");
            }
            sb.append("</socketconnection>\r\n");
            return sb.toString();
        }
    }

    public static class HostnameResult {
        public String originalHostnameOrIP;
        public HostnameEntryType type;
        public List<String> ipAddresses = new ArrayList<String>();
        public String reverseDnsName;
        public Exception exception;
        public boolean valid;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (!this.valid) {
                sb.append(this.originalHostnameOrIP + " is invalid");
                sb.append(this.exception.getMessage());
            } else if (this.type == HostnameEntryType.Hostname) {
                sb.append("IP Addresses:");
                sb.append(System.lineSeparator());
                for (int i = 0; i < this.ipAddresses.size(); ++i) {
                    sb.append("  " + this.ipAddresses.get(i));
                    sb.append(System.lineSeparator());
                }
            } else {
                sb.append("Reverse Dns Name:" + this.reverseDnsName);
            }
            return sb.toString();
        }

        public String toXML() {
            StringBuilder sb = new StringBuilder();
            sb.append("<hostname>\r\n");
            sb.append("<valid>" + this.valid + "</valid>\r\n");
            sb.append("<type>" + (Object)((Object)this.type) + "</type>\r\n");
            if (this.exception != null) {
                sb.append("<exception>" + XMLOutput.escapeXML(this.exception.getMessage()) + "</exception>\r\n");
            }
            if (this.type == HostnameEntryType.Hostname) {
                sb.append("<ipaddresses>\r\n");
                for (int i = 0; i < this.ipAddresses.size(); ++i) {
                    sb.append("<ip>" + this.ipAddresses.get(i) + "</ip>\r\n");
                }
                sb.append("</ipaddresses>\r\n");
            } else {
                sb.append("<reversednsname>" + XMLOutput.escapeXML(this.reverseDnsName) + "</reversednsname>\r\n");
            }
            sb.append("</hostname>\r\n");
            return sb.toString();
        }

        public static enum HostnameEntryType {
            Hostname,
            IPAddress;

        }
    }
}

