/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.pa;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import java.io.File;
import java.io.FileInputStream;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class PAVersionCollector
extends DataCollectorTask {
    private String paBaseDir;

    public PAVersionCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration.getId(), configuration.getZipParentPathAsEnum(), null, DataCollectorFileType.XML);
        this.paBaseDir = configuration.getStringParam("root");
    }

    @Override
    protected void writeData() throws Exception {
        this.writeln("<paVersionData>");
        File dir = new File(this.paBaseDir + File.separator + "lib");
        File[] files = dir.listFiles((d, name) -> name.matches("pingaccess\\-admin\\-\\d+\\.\\d+\\.\\d+\\.\\d+(\\-SNAPSHOT)?\\.jar"));
        if (files.length > 0) {
            FileInputStream inputStream = new FileInputStream(files[0]);
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            Manifest jarManifest = jarInputStream.getManifest();
            Attributes attrs = jarManifest.getMainAttributes();
            String paVersion = attrs.getValue("Implementation-Version");
            String buildJdk = attrs.getValue("Build-Jdk");
            this.writeln("<PAVersion>" + paVersion + "</PAVersion>");
            this.writeln("<BuildJDK>" + buildJdk + "</BuildJDK>");
        }
        this.writeln("</paVersionData>");
    }
}

