/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.pf;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import java.io.File;
import java.io.FileInputStream;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class PFVersionCollector
extends DataCollectorTask {
    private String pfBaseDir;

    public PFVersionCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration.getId(), configuration.getZipParentPathAsEnum(), null, DataCollectorFileType.XML);
        this.pfBaseDir = configuration.getStringParam("root");
    }

    @Override
    protected void writeData() throws Exception {
        this.writeln("<pfVersionData>");
        String pathToStartupJar = this.pfBaseDir + File.separator + "bin" + File.separator + "pf-startup.jar";
        FileInputStream inputStream = new FileInputStream(new File(pathToStartupJar));
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        Manifest jarManifest = jarInputStream.getManifest();
        Attributes attrs = jarManifest.getMainAttributes();
        String pfVersion = attrs.getValue("Implementation-Version");
        String buildType = attrs.getValue("Build");
        String buildJdk = attrs.getValue("Build-Jdk");
        this.writeln("<PFVersion>" + pfVersion + "</PFVersion>");
        this.writeln("<BuildType>" + buildType + "</BuildType>");
        this.writeln("<BuildJDK>" + buildJdk + "</BuildJDK>");
        this.writeln("</pfVersionData>");
    }
}

