/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.tools;

import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.Command;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class ProcessBuilderUtil {
    public static ProcessBuilder buildProcess(CollectSupportData collectSupportData, String ... command) {
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.directory(new File(collectSupportData.getServerRoot()));
        pb.redirectErrorStream(true);
        pb.command(command);
        pb.environment().put("COLUMNS", "160");
        return pb;
    }

    public static ProcessBuilder buildProcess(CollectSupportData collectSupportData, Command tool, String ... args) {
        return ProcessBuilderUtil.buildProcess(collectSupportData, null, tool, args);
    }

    public static ProcessBuilder buildProcess(CollectSupportData collectSupportData, String path, Command tool, String ... args) {
        ArrayList<String> command = new ArrayList<String>();
        if (path != null) {
            command.add(path + tool.getName());
        } else {
            command.add(tool.getName());
        }
        if (args != null) {
            command.addAll(Arrays.asList(args));
        }
        return ProcessBuilderUtil.buildProcess(collectSupportData, command.toArray(new String[command.size()]));
    }
}

