/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.util;

import com.unboundid.csd.messages.UBIDToolMessages;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.EndAdministrativeSessionExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionExtendedRequest;

public final class AdminSessionUtils {
    public static void startSession(LDAPConnection connection, String clientName) throws LDAPException {
        try {
            ExtendedResult result = connection.processExtendedOperation((ExtendedRequest)new StartAdministrativeSessionExtendedRequest(clientName, true, new Control[0]));
            if (result.getResultCode() != ResultCode.SUCCESS) {
                String msg = result.getDiagnosticMessage();
                if (msg == null || msg.length() == 0) {
                    msg = result.getResultCode().toString();
                }
                throw new LDAPException(result.getResultCode(), UBIDToolMessages.ERR_CANNOT_START_ADMIN_SESSION.get((Object)msg).toString());
            }
        }
        catch (LDAPException le) {
            throw new LDAPException(le.getResultCode(), UBIDToolMessages.ERR_CANNOT_START_ADMIN_SESSION.get((Object)le.getExceptionMessage()).toString(), (Throwable)le);
        }
    }

    public static void endSession(LDAPConnection connection) throws LDAPException {
        connection.processExtendedOperation((ExtendedRequest)new EndAdministrativeSessionExtendedRequest(new Control[0]));
    }
}

