/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.util;

import com.pingidentity.csd.loggers.debug.DebugTracerLevel;
import com.pingidentity.csd.server.util.LineOrientedOutputStream;
import com.pingidentity.csd.server.util.LineTransformer;
import com.unboundid.util.ObjectPair;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DesensitizingOutputStream
extends LineOrientedOutputStream {
    public static List<String> ADDITIONAL_OBSCURE_PROPS = Collections.unmodifiableList(Arrays.asList("recipient-address", "sender-address", "message-body", "kerberos-service-principal", "keytab", "realm", "server-fqdn", "kdc-address", "deployment-package"));
    public static List<String> SECRET_LDAP_ATTRS = Collections.unmodifiableList(Arrays.asList("userPassword", "authPassword", "ds-auth-delivered-otp", "ds-auth-password-reset-token", "ds-auth-single-use-token", "ds-cfg-client-secret", "ds-pwp-retired-password", "ds-pwp-auth-failure", "ds-sync-hist", "pwdhistory", "modifiersName", "creatorsName", "userCertificate", "userCertificate;binary", "ds-cfg-symmetric-key", "ds-auth-totp-shared-secret", "ds-auth-delivered-otp"));
    public static List<String> DN_AND_FILTER_KEYS = Collections.unmodifiableList(Arrays.asList("dn", "authDN", "filter", "base", "newRDN", "newSuperior"));
    public static final String DEFAULT_REPLACEMENT = "---REDACTED---";
    private final OutputStream out;
    private final List<ObjectPair<Pattern, String>> replacements;
    private final Charset utf8;
    private final LineTransformer[] transformers;

    public DesensitizingOutputStream(OutputStream out, List<ObjectPair<Pattern, String>> replacements, LineTransformer ... transformers) {
        this.out = out;
        this.replacements = replacements;
        this.utf8 = Charset.forName("UTF-8");
        this.transformers = transformers;
    }

    public void flushAll() throws IOException {
        this.processBuffer();
    }

    @Override
    protected void processLine(byte[] lineBytes) throws IOException {
        byte[] toWrite = lineBytes;
        try {
            String lineStr = new String(lineBytes, this.utf8);
            byte[] bytesBack = lineStr.getBytes(this.utf8);
            if (Arrays.equals(lineBytes, bytesBack)) {
                for (ObjectPair<Pattern, String> replacement : this.replacements) {
                    Matcher matcher = ((Pattern)replacement.getFirst()).matcher(lineStr);
                    lineStr = matcher.replaceAll((String)replacement.getSecond());
                }
                for (LineTransformer transformer : this.transformers) {
                    lineStr = transformer.transform(lineStr);
                }
                toWrite = lineStr.getBytes(this.utf8);
            }
        }
        catch (Exception e) {
            DesensitizingOutputStream.tracerDebugCaught(DebugTracerLevel.WARNING, e);
        }
        this.out.write(toWrite);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.out.close();
    }

    public static List<ObjectPair<Pattern, String>> buildReplacements(String replacement, boolean obscuredProperties, boolean secretLDAPAttrs, boolean hashedPasswords, boolean dnAndFilterEquals) {
        if (replacement == null) {
            replacement = DEFAULT_REPLACEMENT;
        }
        ArrayList<ObjectPair<Pattern, String>> replacements = new ArrayList<ObjectPair<Pattern, String>>();
        String quotedMatcherReplacement = Matcher.quoteReplacement(replacement);
        if (obscuredProperties) {
            Iterator<String> obscuredProps = new LinkedHashSet<String>();
            obscuredProps.addAll(ADDITIONAL_OBSCURE_PROPS);
            if (dnAndFilterEquals) {
                obscuredProps.add("global-aci");
            }
            Iterator iterator = obscuredProps.iterator();
            while (iterator.hasNext()) {
                String obscuredName = (String)iterator.next();
                DesensitizingOutputStream.addLDAPAttrReplacements("ds-cfg-" + obscuredName, quotedMatcherReplacement, replacements);
                String quotedName = Pattern.quote(obscuredName);
                String patternText = "\\\"(" + quotedName + " *:)([^\\\"]*)\\\"";
                Pattern pattern = Pattern.compile(patternText, 2);
                replacements.add((ObjectPair<Pattern, String>)new ObjectPair((Object)pattern, (Object)("\"$1" + quotedMatcherReplacement + "\"")));
                patternText = "\\'(" + quotedName + " *:)([^\\']*)\\'";
                pattern = Pattern.compile(patternText, 2);
                replacements.add((ObjectPair<Pattern, String>)new ObjectPair((Object)pattern, (Object)("'$1" + quotedMatcherReplacement + "'")));
                patternText = "((^|[^\\w\\-\\'\\\"])" + quotedName + ":)(?!((true)|(false)))\\S*";
                pattern = Pattern.compile(patternText, 2);
                replacements.add((ObjectPair<Pattern, String>)new ObjectPair((Object)pattern, (Object)("$1" + quotedMatcherReplacement)));
            }
        }
        if (secretLDAPAttrs) {
            for (String secretLDAPAttr : SECRET_LDAP_ATTRS) {
                DesensitizingOutputStream.addLDAPAttrReplacements(secretLDAPAttr, quotedMatcherReplacement, replacements);
            }
        }
        if (hashedPasswords) {
            replacements.add((ObjectPair<Pattern, String>)new ObjectPair((Object)Pattern.compile("\\{[A-Za-z0-9-]+\\}[A-Za-z0-9\\+\\/\\=]+"), (Object)quotedMatcherReplacement));
        }
        if (dnAndFilterEquals) {
            for (String key : DN_AND_FILTER_KEYS) {
                String patternText = "((^|[^\\w\\-])" + key + "=)[^\\\"\\'\\s]+";
                Pattern pattern = Pattern.compile(patternText, 2);
                replacements.add((ObjectPair<Pattern, String>)new ObjectPair((Object)pattern, (Object)("$1" + quotedMatcherReplacement)));
                patternText = "((^|[^\\w\\-])" + key + "=)\\\"[^\\\"]*\\\"";
                pattern = Pattern.compile(patternText, 2);
                replacements.add((ObjectPair<Pattern, String>)new ObjectPair((Object)pattern, (Object)("$1\"" + quotedMatcherReplacement + "\"")));
                patternText = "((^|[^\\w\\-])" + key + "=)\\'[^\\\"]*\\'";
                pattern = Pattern.compile(patternText, 2);
                replacements.add((ObjectPair<Pattern, String>)new ObjectPair((Object)pattern, (Object)("$1'" + quotedMatcherReplacement + "'")));
            }
            Pattern pattern = Pattern.compile("\\(version +3.0; +acl.*\\)");
            replacements.add((ObjectPair<Pattern, String>)new ObjectPair((Object)pattern, (Object)quotedMatcherReplacement));
        }
        return replacements;
    }

    private static void addLDAPAttrReplacements(String ldapAttr, String quotedMatcherReplacement, List<ObjectPair<Pattern, String>> replacements) {
        String quotedLDAPAttr = Pattern.quote(ldapAttr);
        String patternText = "(^" + quotedLDAPAttr + " *::? *)(.*)";
        Pattern pattern = Pattern.compile(patternText, 2);
        replacements.add((ObjectPair<Pattern, String>)new ObjectPair((Object)pattern, (Object)("$1" + quotedMatcherReplacement)));
    }

    static void tracerDebugCaught(DebugTracerLevel debugTracerLevel, Exception exception) {
        System.err.println("Level: " + (Object)((Object)debugTracerLevel) + " Exception: " + exception.getMessage() + " Stacktrace:");
        exception.printStackTrace();
    }
}

