/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.collectsupportdata;

import com.pingidentity.csd.tools.collectsupportdata.ArchiveFileFilter;
import com.pingidentity.csd.tools.collectsupportdata.FileAction;
import com.pingidentity.csd.tools.collectsupportdata.SecurityLevel;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ArchiveFileFilterBuilder {
    private final List<SingleFileFilter> filters = new ArrayList<SingleFileFilter>();

    public void includeBuilders(ArchiveFileFilterBuilder ... builders) {
        for (ArchiveFileFilterBuilder builder : builders) {
            this.filters.addAll(builder.filters);
        }
    }

    public void includeExactFiles(SecurityLevel securityLevel, FileAction fileAction, File directory, String ... fileNames) {
        HashSet<String> fileNameSet = new HashSet<String>(Arrays.asList(fileNames));
        if (directory.exists()) {
            this.addDirectory(directory);
            for (File file : directory.listFiles()) {
                if (!fileNameSet.contains(file.getName())) continue;
                this.filters.add(new SingleFileFilter(file, fileAction, securityLevel));
            }
        }
    }

    public void includeAllFiles(SecurityLevel securityLevel, FileAction fileAction, File directory) {
        if (directory.exists()) {
            this.addDirectory(directory);
            for (File file : directory.listFiles()) {
                this.filters.add(new SingleFileFilter(file, fileAction, securityLevel));
            }
        }
    }

    public void includeAllFilesAndDirectories(SecurityLevel securityLevel, FileAction fileAction, File directory) {
        this.includeAllFilesAndDirectoriesExceptExcludedPatterns(securityLevel, fileAction, directory, new ArrayList<String>());
    }

    public void includeAllFilesAndDirectoriesExceptExcludedPatterns(SecurityLevel securityLevel, FileAction fileAction, File directory, List<String> exclusionPatterns) {
        if (directory.exists()) {
            this.addDirectory(directory);
            for (File file : directory.listFiles()) {
                boolean excluded = false;
                for (String pattern : exclusionPatterns) {
                    if (!file.getName().contains(pattern)) continue;
                    excluded = true;
                }
                if (excluded) continue;
                this.filters.add(new SingleFileFilter(file, fileAction, securityLevel));
                if (!file.isDirectory()) continue;
                this.includeAllFilesAndDirectoriesExceptExcludedPatterns(securityLevel, fileAction, file, exclusionPatterns);
            }
        }
    }

    public void includeRegexFiles(SecurityLevel securityLevel, FileAction fileAction, File directory, boolean recursive, String ... fileNameRegexes) {
        if (directory.exists()) {
            this.addDirectory(directory);
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    if (!recursive) continue;
                    this.includeRegexFiles(securityLevel, fileAction, file, recursive, fileNameRegexes);
                    continue;
                }
                if (!this.matches(file.getName(), fileNameRegexes)) continue;
                this.filters.add(new SingleFileFilter(file, fileAction, securityLevel));
            }
        }
    }

    public void includeTimestampedFiles(SecurityLevel securityLevel, FileAction fileAction, File directory, final String fileNameRegex, int maxToInclude) {
        if (directory.exists()) {
            this.addDirectory(directory);
            List<String> fileNames = Arrays.asList(directory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return ArchiveFileFilterBuilder.this.matches(name, new String[]{fileNameRegex});
                }
            }));
            Collections.sort(fileNames);
            Collections.reverse(fileNames);
            for (int i = 0; i < Math.min(fileNames.size(), maxToInclude); ++i) {
                File file = new File(directory, fileNames.get(i));
                this.filters.add(new SingleFileFilter(file, fileAction, securityLevel));
            }
        }
    }

    private boolean matches(String fileName, String ... fileNameRegexes) {
        for (String regex : fileNameRegexes) {
            if (!fileName.matches(regex)) continue;
            return true;
        }
        return false;
    }

    private void addDirectory(File dir) {
        this.filters.add(new SingleFileFilter(dir, FileAction.INCLUDE_ALL, SecurityLevel.MAXIMUM));
    }

    public ArchiveFileFilter build(SecurityLevel securityLevel) {
        return new CompoundFileFilter(this.filters, securityLevel);
    }

    public List<SingleFileFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public static class SingleFileFilter {
        private final File file;
        private final FileAction action;
        private final SecurityLevel minimumSecurityLevel;

        private SingleFileFilter(File file, FileAction action, SecurityLevel minimumSecurityLevel) {
            this.action = action;
            this.file = file;
            this.minimumSecurityLevel = minimumSecurityLevel;
        }

        private FileAction action(File file, SecurityLevel allowedSecurityLevel) {
            if (this.file.equals(file)) {
                if (this.minimumSecurityLevel.compareTo(allowedSecurityLevel) < 0) {
                    return null;
                }
                return this.action;
            }
            return null;
        }

        public String toString() {
            return "\nFilter{minimumSecurityLevel=" + (Object)((Object)this.minimumSecurityLevel) + ", action=" + (Object)((Object)this.action) + ", file=" + this.file + '}';
        }

        public FileAction getAction() {
            return this.action;
        }

        public File getFile() {
            return this.file;
        }

        public SecurityLevel getMinimumSecurityLevel() {
            return this.minimumSecurityLevel;
        }
    }

    private static class CompoundFileFilter
    implements ArchiveFileFilter {
        private final List<SingleFileFilter> filters;
        private final SecurityLevel securityLevel;

        private CompoundFileFilter(List<SingleFileFilter> filters, SecurityLevel securityLevel) {
            this.filters = new ArrayList<SingleFileFilter>(filters);
            this.securityLevel = securityLevel;
        }

        @Override
        public FileAction action(File file) {
            FileAction action = FileAction.EXCLUDE;
            for (SingleFileFilter filter : this.filters) {
                FileAction filterAction = filter.action(file, this.securityLevel);
                if (filterAction == FileAction.EXCLUDE) {
                    return FileAction.EXCLUDE;
                }
                if (action == FileAction.INCLUDE_ALL || filterAction == null) continue;
                action = filterAction;
            }
            return action;
        }

        @Override
        public boolean accept(File file) {
            FileAction action = this.action(file);
            return action != null && action != FileAction.EXCLUDE;
        }

        public String toString() {
            return "CompoundFileFilter{securityLevel=" + (Object)((Object)this.securityLevel) + ", filters=" + this.filters + '}';
        }
    }
}

