/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.collectsupportdata;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public final class FilterStackTrace
extends CommandLineTool {
    private static final String[] DEFAULT_IGNORE_STRINGS = new String[]{"InputStream.read(", "Object.wait(", "Queue.poll(", "SelectorImpl.select(", "ServerSocket.accept(", "ServerSocketChannelImpl.accept(", "Thread.sleep(", "ThreadPoolExecutor.getTask(", "WakeableSleeper.sleep("};
    private BooleanArgument suppressDefaultIgnores;
    private FileArgument inputFilePath;
    private FileArgument outputFilePath;
    private StringArgument ignoreString;

    public static void main(String ... args) {
        ResultCode rc = FilterStackTrace.main(System.out, System.err, args);
        if (rc != ResultCode.SUCCESS) {
            System.exit(rc.intValue());
        }
    }

    public static ResultCode main(OutputStream out, OutputStream err, String ... args) {
        FilterStackTrace tool = new FilterStackTrace(out, err);
        return tool.runTool(args);
    }

    public FilterStackTrace(OutputStream out, OutputStream err) {
        super(out, err);
    }

    public String getToolName() {
        return "filter-stack-trace";
    }

    public String getToolDescription() {
        return "Reads a file containing Java stack trace information and filters out any traces containing a specified set of strings.  A number of common 'uninteresting' traces will be filtered out by default, but additional substrings can be specified if desired.";
    }

    public boolean supportsInteractiveMode() {
        return true;
    }

    public boolean defaultsToInteractiveMode() {
        return true;
    }

    public boolean supportsPropertiesFile() {
        return true;
    }

    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.inputFilePath = new FileArgument(Character.valueOf('f'), "inputFile", true, 1, "{path}", "The path to the input file containing the thread stack traces to parse.", true, true, true, false);
        parser.addArgument((Argument)this.inputFilePath);
        this.outputFilePath = new FileArgument(Character.valueOf('o'), "outputFile", false, 1, "{path}", "the path to use for the output file containing the filtered stack traces.  If this is not provided, then standard output will be used.", false, true, true, false);
        parser.addArgument((Argument)this.outputFilePath);
        this.ignoreString = new StringArgument(Character.valueOf('i'), "ignoreString", false, 0, "{string}", "A substring which will cause a thread stack to be ignored.  This is optional unless the '--suppressDefaultIgnores' argument is provided.");
        parser.addArgument((Argument)this.ignoreString);
        this.suppressDefaultIgnores = new BooleanArgument(Character.valueOf('s'), "suppressDefaultIgnores", "Indicates whether to suppress the default set of ignore strings so that only those explicitly listed in the '--ignoreString' argument will be used.");
        parser.addArgument((Argument)this.suppressDefaultIgnores);
    }

    public void doExtendedArgumentValidation() throws ArgumentException {
        if (this.suppressDefaultIgnores.isPresent() && !this.ignoreString.isPresent()) {
            throw new ArgumentException("If the --suppressDefaultIgnores argument is provided, then the --ignoreString argument must also be given to specify substrings to be ignored.");
        }
    }

    /*
     * Exception decompiling
     */
    public ResultCode doToolProcessing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 33[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void print(LinkedList<String> lines, PrintStream writer) {
        switch (lines.size()) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                String secondLine = lines.get(1);
                if (secondLine.indexOf("java.lang.Thread.State:") >= 0) {
                    return;
                }
                if (secondLine.startsWith(" ") || secondLine.startsWith("\t")) break;
                return;
            }
        }
        for (String s : lines) {
            writer.println(s);
        }
        writer.println();
    }

    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(1);
        String[] args = new String[]{"-f", "/tmp/jstack.out", "-o", "/tmp/jstack.filtered", "-i", "Object.wait("};
        examples.put(args, "Read the stack trace information contained in file /tmp/jstack.out and write it to /tmp/jstack.filtered, excluding information about any thread whose stack contains the substring 'Object.wait(' or any of the default exclude strings.");
        return examples;
    }
}

