/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.common.license.PingLicensePrinter;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import com.unboundid.util.StaticUtils;
import java.util.Date;

public class LicenseExaminer
extends SupportDataExaminer {
    @Override
    public String getTitle() {
        return "License";
    }

    @Override
    public Message getExplanation() {
        return UBIDExaminerMessages.INFO_LICENSE_EXPLANATION.get();
    }

    @Override
    public SupportDataExaminer.Result examine(SupportDataArchive sda) throws Exception {
        SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
        Entry monitor = sda.getMonitorEntry("cn=License,cn=monitor");
        if (monitor != null) {
            Entry globalConfig;
            String licenseRequirement;
            result.setSeverity(Severity.INFORMATION);
            String status = monitor.getAttributeValue("status");
            result.writeln("Status: " + status);
            if (!"missing".equals(status)) {
                Date issueDate = null;
                Date expirationDate = null;
                String s = monitor.getAttributeValue("issue-date");
                if (!"none".equals(s)) {
                    try {
                        issueDate = StaticUtils.decodeGeneralizedTime((String)s);
                    }
                    catch (Exception e) {
                        this.log("Error parsing issue date \"" + s + "\" for monitor \"" + monitor + "\".");
                    }
                }
                if (!"none".equals(s = monitor.getAttributeValue("expiration-date"))) {
                    try {
                        expirationDate = StaticUtils.decodeGeneralizedTime((String)s);
                    }
                    catch (Exception e) {
                        this.log("Error parsing expiration date \"" + s + "\".");
                    }
                }
                result.writeln(new PingLicensePrinter(monitor.getAttributeValue("organization"), monitor.getAttributeValue("product"), monitor.getAttributeValue("version"), issueDate, expirationDate).toMessage().toString());
                String org = monitor.getAttributeValue("organization");
                if ("Ping Identity Corporation".equals(org) || "68".equals(org)) {
                    result.writeln("INTERNAL LICENSE");
                    result.setSeverity(Severity.NOTICE);
                }
            }
            if ("I".equals(licenseRequirement = (globalConfig = sda.getConfigEntry("cn=config")).getAttributeValue("ds-cfg-internal-1"))) {
                result.writeln("Licence requirement flag set to INTERNAL.  This should only the case for internal testing");
                result.setSeverity(Severity.NOTICE);
            } else if ("G".equals(licenseRequirement)) {
                if ("missing".equals(status) || "not required".equals(status)) {
                    result.writeln("This server does not require a license as it was updated from a previous version that did not required one.  A license will be required for the next major version update.");
                    result.setSeverity(Severity.NOTICE);
                }
            } else if (licenseRequirement != null) {
                result.writeln("Unexpected value " + licenseRequirement + " for ds-cfg-internal-1 which is intended for internal use only");
                result.setSeverity(Severity.MILD_ERROR);
            }
            String invalidReasons = monitor.getAttributeValue("invalid-reasons");
            if (invalidReasons != null && !invalidReasons.isEmpty()) {
                result.writeln("Invalid Reasons: " + invalidReasons);
                result.setSeverity(Severity.MILD_ERROR);
            }
        } else {
            result.setSeverity(Severity.SEVERE_WARNING);
            result.writeln("License monitor not available");
        }
        return result;
    }
}

