/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.types.OperatingSystem;
import com.pingidentity.csd.tools.examinesupportdata.BusyThreadsExaminer;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.directory.server.util.StaticUtils;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LinuxExaminer
extends SupportDataExaminer {
    public static List<SupportDataExaminer> getExaminers(SupportDataArchive sda) {
        ArrayList<SupportDataExaminer> examiners = new ArrayList<SupportDataExaminer>();
        examiners.add(new LargePagesExaminer());
        examiners.add(new SwapinessExaminer());
        examiners.add(new SystemSwappingExaminer());
        examiners.add(new VMdirtyExaminer());
        examiners.add(new IOschedulerExaminer());
        examiners.add(new LowEntropyExaminer());
        examiners.add(new ReserveSharedMemoryExaminer());
        return examiners;
    }

    @Override
    public List<OperatingSystem> getSupportedOperatingSystems() {
        return Arrays.asList(OperatingSystem.LINUX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusyThreadsExaminer.BusyThreadData getBusyThreadData(SupportDataArchive sda) {
        BusyThreadsExaminer.BusyThreadData data = new BusyThreadsExaminer.BusyThreadData();
        try {
            InputStream is = sda.getServerFile("top");
            try {
                Pattern splitter = Pattern.compile("^\\s*(\\d+).+\\s+(\\d+\\.\\d+)\\s+\\d+\\.\\d+\\s+[0-9:.]+\\s+java\\s*$");
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String line = reader.readLine();
                while (line != null) {
                    Matcher m = splitter.matcher(line.trim());
                    if (m.find() && m.groupCount() >= 2) {
                        String threadId = Integer.toHexString(Integer.valueOf(m.group(1)));
                        Float cpuUsage = Float.valueOf(m.group(2));
                        data.updateThreadCpuUsage(threadId, cpuUsage);
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (Exception ex) {
                SupportDataArchive.log(Level.FINE, com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex) {
                    SupportDataArchive.log(Level.FINE, com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
                }
            }
        }
        catch (Exception ex) {
            SupportDataArchive.log("Exception occurred while doing analysis:" + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
        }
        return data;
    }

    public static class ReserveSharedMemoryExaminer
    extends LinuxExaminer {
        @Override
        public String getTitle() {
            return "Reserve Shared Memory Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_RESERVE_SHARED_MEMORY_EXPLANATION.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            try {
                BufferedReader br = null;
                try {
                    InputStream is = sda.getFileInputStream("server-root-files/logs/server.out");
                    if (is != null) {
                        br = new BufferedReader(new InputStreamReader(is));
                        Pattern splitter = Pattern.compile(".+(reserve shared.+)");
                        this.log("Looking in server-root-files/log/server.out for errors");
                        String line = br.readLine();
                        while (line != null) {
                            Matcher m = splitter.matcher(line.trim());
                            if (m.matches()) {
                                result.setSeverity(Severity.SEVERE_WARNING);
                                result.writeln(line);
                            }
                            line = br.readLine();
                        }
                    } else {
                        this.log("Unable to locate file at 'server-root-files/logs/server.out' for examiner");
                    }
                }
                catch (Exception ex) {
                    this.log("Exception occurred while parsing server-root-files/log/server.out: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }

    public static class LowEntropyExaminer
    extends LinuxExaminer {
        @Override
        public String getTitle() {
            return "Low Entropy Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_LOW_ENTROPY_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            try {
                Map<String, String> sysctlMap = SupportDataArchive.createMapFromInputStream(sda.getSystemFile("sysctl"), "(\\S+)\\s*=\\s*(\\S+)");
                String entropyLevel = sysctlMap.get("kernel.random.entropy_avail");
                if (entropyLevel == null) {
                    result.writeln("kernel.random.entropy_avail value not found in sysctl output");
                    return result;
                }
                int entropyValue = Integer.parseInt(entropyLevel);
                this.log("kernel.random.entropy_avail: " + entropyValue);
                if (entropyValue < 500) {
                    result.setSeverity(Severity.SEVERE_WARNING);
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }

    public static class IOschedulerExaminer
    extends LinuxExaminer {
        static final String[] VM_NAMES = new String[]{"vmware", "virtualbox", "kvm"};

        @Override
        public String getTitle() {
            return "IO Scheduler Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_IO_SCHEDULER_EXPLANATION.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            try {
                Pattern splitter;
                String line;
                InputStream is;
                BufferedReader br = null;
                boolean virtualEnv = false;
                boolean schedulerFound = false;
                boolean ssdFound = false;
                ArrayList<String> ssdList = null;
                try {
                    is = sda.getSystemFile("product-name");
                    br = new BufferedReader(new InputStreamReader(is));
                    String productName = null;
                    line = br.readLine();
                    while (line != null) {
                        if (Arrays.asList(VM_NAMES).contains(line.trim().toLowerCase())) {
                            virtualEnv = true;
                            productName = line.trim();
                        }
                        line = br.readLine();
                    }
                    if (productName != null) {
                        this.log("Product name is: " + productName);
                    }
                }
                catch (Exception ex) {
                    this.log("Exception occurred while parsing product-name: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
                }
                try {
                    is = sda.getSystemFile("disk-drive-type");
                    br = new BufferedReader(new InputStreamReader(is));
                    splitter = Pattern.compile("(sd[^\\s]*)(.*)");
                    ssdList = new ArrayList<String>();
                    line = br.readLine();
                    while (line != null) {
                        String lineTrimmed = line.trim();
                        Matcher m = splitter.matcher(lineTrimmed);
                        if (m.matches()) {
                            String driveName = m.group(1);
                            boolean isSSD = m.group(2).trim().equals("0");
                            if (isSSD) {
                                ssdFound = true;
                                ssdList.add(driveName);
                            }
                        }
                        line = br.readLine();
                    }
                }
                catch (Exception ex) {
                    this.log("Exception occurred while parsing disk-drive-type: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
                }
                try {
                    is = sda.getSystemFile("dmesg");
                    br = new BufferedReader(new InputStreamReader(is));
                    splitter = Pattern.compile(".*(io scheduler.+default.+)");
                    line = br.readLine();
                    while (line != null) {
                        Matcher m = splitter.matcher(line.trim());
                        if (m.matches()) {
                            schedulerFound = true;
                            String scheduler = m.group(1);
                            this.log(scheduler);
                            if (!scheduler.contains("noop")) {
                                if (ssdFound) {
                                    if (ssdList != null && !ssdList.isEmpty()) {
                                        this.log("The following were detected to be SSDs:  " + ((Object)ssdList).toString());
                                    }
                                    result.setSeverity(Severity.SEVERE_WARNING);
                                    result.writeln("If you're running this server on a solid state drive, then you should consider using noop as your IO scheduler");
                                } else if (virtualEnv) {
                                    result.setSeverity(Severity.SEVERE_WARNING);
                                    result.writeln("You're likely running in a virtual environment and should consider using noop as your IO scheduler");
                                }
                            } else if (!scheduler.contains("deadline") && !virtualEnv) {
                                result.setSeverity(Severity.SEVERE_WARNING);
                                result.writeln("You're likely running in a non-virtual environment and should consider using deadline as your IO scheduler");
                            }
                        }
                        line = br.readLine();
                    }
                    if (!schedulerFound) {
                        result.setSeverity(Severity.INFORMATION);
                        this.log("\ndmesg data was collected but no schedulers found");
                    }
                }
                catch (Exception ex) {
                    this.log("Exception occurred while parsing dmesg: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }

    public static class VMdirtyExaminer
    extends LinuxExaminer {
        @Override
        public String getTitle() {
            return "VM_Dirty Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_VMDIRTY_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            try {
                String[] vmDirtyTypes;
                Map<String, String> sysctlMap = SupportDataArchive.createMapFromInputStream(sda.getSystemFile("sysctl"), "(\\S+)\\s*=\\s*(\\S+)");
                Map<String, String> meminfoMap = SupportDataArchive.createMapFromInputStream(sda.getSystemFile("meminfo"), "(\\S+)\\s*:\\s*(\\S+)");
                double totalRAM = Long.parseLong(meminfoMap.get("MemTotal"));
                this.log("Total RAM in GB: " + totalRAM / 1024000.0);
                for (String vm : vmDirtyTypes = new String[]{"vm.dirty_ratio", "vm.dirty_background_ratio", "vm.dirty_bytes", "vm.dirty_background_bytes"}) {
                    this.log(vm + " : " + sysctlMap.get(vm));
                }
                int dirtyRatio = Integer.parseInt(sysctlMap.get(vmDirtyTypes[0]));
                int dirtyBackgroundRatio = Integer.parseInt(sysctlMap.get(vmDirtyTypes[1]));
                if (dirtyRatio >= 20 && dirtyBackgroundRatio >= 10 && totalRAM > 9.6E7) {
                    result.setSeverity(Severity.SEVERE_ERROR);
                    result.writeln("Please contact support regarding proper vm.dirty parameters for your system");
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis:" + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }

    public static class SystemSwappingExaminer
    extends LinuxExaminer {
        @Override
        public String getTitle() {
            return "System Swapping Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_SYSTEM_SWAPPING_EXPLANATION.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            try {
                BufferedReader br;
                InputStream is = null;
                try {
                    is = sda.getSystemFile("vmstat");
                    br = new BufferedReader(new InputStreamReader(is));
                    Pattern splitter = Pattern.compile("(\\d+\\s*){6}+(\\d+)\\s+(\\d+)\\s+(\\d+\\s*){9}+");
                    String line = br.readLine();
                    while (line != null) {
                        Matcher m = splitter.matcher(line.trim());
                        if (m.find()) {
                            long si = Long.parseLong(m.group(2));
                            long so = Long.parseLong(m.group(3));
                            if (si > 0L || so > 0L) {
                                result.setSeverity(Severity.MILD_ERROR);
                                result.writeln("System Swapping detected in vmstat!");
                                break;
                            }
                        }
                        line = br.readLine();
                    }
                }
                catch (Exception ex) {
                    this.log("Exception occurred while parsing vmstat: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception ex) {}
                }
                try {
                    is = sda.getSystemFile("sar");
                    br = new BufferedReader(new InputStreamReader(is));
                    String line = br.readLine();
                    while (line != null) {
                        if (line.contains("%swpused")) {
                            List<String> headings = Arrays.asList(line.split("\\s+"));
                            line = br.readLine();
                            List<String> values = Arrays.asList(line.split("\\s+"));
                            int index = headings.indexOf("%swpused");
                            float swpused = Float.parseFloat(values.get(index));
                            this.log("swapused detected: " + swpused);
                            if ((double)swpused > 0.0) {
                                result.setSeverity(Severity.MILD_ERROR);
                                result.writeln("System Swapping detected in sar!");
                                break;
                            }
                        }
                        line = br.readLine();
                    }
                }
                catch (Exception ex) {
                    this.log("Exception occurred while parsing sar: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }

    public static class SwapinessExaminer
    extends LinuxExaminer {
        @Override
        public String getTitle() {
            return "Swapiness Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_SWAPINESS_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            try {
                Map<String, String> sysctlMap = SupportDataArchive.createMapFromInputStream(sda.getSystemFile("sysctl"), "(\\S+)\\s*=\\s*(\\S+)");
                String swapinessStr = sysctlMap.get("vm.swappiness");
                if (swapinessStr == null) {
                    result.setSeverity(Severity.MILD_ERROR);
                    result.writeln("vm.swapiness not found in sysctl");
                    return result;
                }
                long swapiness = Long.parseLong(swapinessStr);
                if (swapiness > 0L) {
                    result.setSeverity(Severity.SEVERE_ERROR);
                    result.writeln("vm.swapiness is greater than 0!");
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }

    public static class LargePagesExaminer
    extends LinuxExaminer {
        @Override
        public String getTitle() {
            return "Large Pages Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_LARGE_PAGES_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result();
            try {
                boolean checkHugePageConfigConflict = true;
                boolean checkHugePageCountConflict = true;
                boolean checkHugePageShMaxConflict = true;
                HashSet<String> propsMissingLargePageFlag = new HashSet<String>();
                long totalHugePages = 0L;
                long hugePageSize = 0L;
                long nrHugePages = 0L;
                BigInteger kernelShMax = BigInteger.ZERO;
                Properties javaProps = new Properties();
                String javaPropsFile = "server-root-files/config/java.properties";
                InputStream stream = sda.getFileInputStream(javaPropsFile);
                if (stream == null) {
                    String errorMessage = UBIDExaminerMessages.INFO_FILE_NOT_FOUND.get((Object)javaPropsFile).toString();
                    result.writeln(StaticUtils.punctuate((String)errorMessage));
                    result.setSeverity(Severity.SEVERE_ERROR);
                    return result;
                }
                javaProps.load(stream);
                for (String prop : javaProps.stringPropertyNames()) {
                    if (!prop.contains("start-") && !prop.contains("import-ldif") || javaProps.getProperty(prop).contains("+UseLargePages")) continue;
                    propsMissingLargePageFlag.add(prop);
                }
                Map<String, String> meminfoMap = SupportDataArchive.createMapFromInputStream(sda.getSystemFile("meminfo"), "(\\S+)\\s*:\\s*(\\S+)");
                String thpStr = meminfoMap.get("HugePages_Total");
                String hpsStr = meminfoMap.get("Hugepagesize");
                if (thpStr == null) {
                    this.log("HugePages_Total not found in meminfo");
                    checkHugePageCountConflict = false;
                    checkHugePageConfigConflict = false;
                } else {
                    totalHugePages = Long.parseLong(thpStr);
                }
                if (hpsStr == null) {
                    this.log("Hugepagesize not found in meminfo");
                    checkHugePageShMaxConflict = false;
                } else {
                    hugePageSize = Long.parseLong(hpsStr);
                }
                Map<String, String> sysctlMap = SupportDataArchive.createMapFromInputStream(sda.getSystemFile("sysctl"), "(\\S+)\\s*=\\s*(\\S+)");
                String nhpStr = sysctlMap.get("vm.nr_hugepages");
                String ksmStr = sysctlMap.get("kernel.shmmax");
                if (nhpStr == null) {
                    this.log("vm.nr_hugepages not found in sysctl");
                    checkHugePageCountConflict = false;
                    checkHugePageShMaxConflict = false;
                } else {
                    nrHugePages = Long.parseLong(nhpStr);
                }
                if (ksmStr == null) {
                    this.log("kernel.shmmax not found in sysctl");
                    checkHugePageShMaxConflict = false;
                } else {
                    kernelShMax = new BigInteger(ksmStr);
                }
                if (checkHugePageCountConflict && totalHugePages != nrHugePages) {
                    result.setSeverity(Severity.MILD_ERROR);
                    result.writeln("meminfo and sysctl are reporting conflicting HugePage totals!");
                }
                if (checkHugePageShMaxConflict && kernelShMax.compareTo(BigInteger.valueOf(hugePageSize * nrHugePages)) < 0) {
                    result.setSeverity(Severity.SEVERE_ERROR);
                    result.writeln("The amount of memory needed by HugePages is greater than the max amount of shared memory configured on this system!");
                }
                if (checkHugePageConfigConflict && totalHugePages > 0L && !propsMissingLargePageFlag.isEmpty()) {
                    result.setSeverity(Severity.SEVERE_ERROR);
                    result.writeln("HugePages are configured on the OS but the '+UseLargePages' flag is not set for these commands: " + propsMissingLargePageFlag);
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + com.pingidentity.csd.server.util.StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }
}

