/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.visualizereplicationstate;

import com.pingidentity.csd.tools.visualizereplicationstate.Replica;
import com.pingidentity.csd.tools.visualizereplicationstate.ReplicaBacklog;
import com.pingidentity.csd.tools.visualizereplicationstate.ReplicaPartialBacklog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class AllBacklogs {
    private final DecimalFormat fractionalMinute = new DecimalFormat("0.00");
    private final DecimalFormat wholeMinute = new DecimalFormat("0");
    private final Map<String, ReplicaBacklog> backlogsByReplicaHost = new TreeMap<String, ReplicaBacklog>();
    private final Map<String, Replica> replicasByReplicaHost = new TreeMap<String, Replica>();

    public AllBacklogs(File file) throws Exception {
        try (FileReader fileReader = new FileReader(file);){
            String line;
            BufferedReader reader = new BufferedReader(fileReader);
            while ((line = reader.readLine()) != null) {
                this.add(line);
            }
        }
    }

    private void add(String line) {
        this.addReplica(line);
        this.addReplicaPartialBacklog(line);
    }

    private void addReplica(String line) {
        Replica replica = Replica.fromString(line);
        if (replica == null) {
            return;
        }
        Replica replicaBacklog = this.replicasByReplicaHost.get(replica.getLdapServer());
        if (replicaBacklog != null) {
            throw new RuntimeException("Duplicate replica: " + replica);
        }
        this.replicasByReplicaHost.put(replica.getLdapServer(), replica);
    }

    private void addReplicaPartialBacklog(String line) {
        ReplicaPartialBacklog partialBacklog = ReplicaPartialBacklog.fromString(line);
        if (partialBacklog == null) {
            return;
        }
        ReplicaBacklog replicaBacklog = this.backlogsByReplicaHost.get(partialBacklog.getLdapServer());
        if (replicaBacklog == null) {
            replicaBacklog = new ReplicaBacklog(partialBacklog.getLdapServer());
            this.backlogsByReplicaHost.put(partialBacklog.getLdapServer(), replicaBacklog);
        }
        replicaBacklog.add(partialBacklog);
    }

    public void writeTableHtml(PrintWriter writer, TableType tableType) {
        TreeSet<String> replicaHosts = new TreeSet<String>();
        replicaHosts.addAll(this.replicasByReplicaHost.keySet());
        for (ReplicaBacklog replicaBacklog : this.backlogsByReplicaHost.values()) {
            replicaHosts.add(replicaBacklog.ldapServer);
            for (ReplicaPartialBacklog replicaPartialBacklog : replicaBacklog.partialBacklogByReplicaId.values()) {
                replicaHosts.add(replicaPartialBacklog.getOriginLdapServer());
            }
        }
        this.writeHeaderRow(writer, replicaHosts);
        writer.println("<tbody class=\"styled-rows\">");
        int rowSpan = replicaHosts.size() + 1;
        writer.println("<tr><th rowspan=\"" + rowSpan + "\" class=\"vrt-header\">Source</th></tr>");
        for (String replicaHost : this.replicasByReplicaHost.keySet()) {
            this.writeRow(writer, replicaHost, replicaHosts, tableType);
        }
        writer.println("</tbody>");
    }

    private void writeHeaderRow(PrintWriter writer, Set<String> replicaHosts) {
        int numReplicas = replicaHosts.size();
        writer.println("<thead>");
        writer.println("<tr><th rowspan=\"2\" colspan=\"2\">Replica</th>");
        writer.println("<th colspan=\"" + numReplicas + "\">Destination</th></tr>");
        writer.println("<tr>");
        for (String host : replicaHosts) {
            if (this.replicasByReplicaHost.get(host) == null) {
                writer.println("<th bgcolor=\"LightGray\" class='vrt-header'><s>" + host + "</s></th>");
                continue;
            }
            writer.println("<th class='vrt-header'>" + host + "</th>");
        }
        writer.println("</tr></thead>");
    }

    private void writeRow(PrintWriter writer, String replica, Set<String> replicaHosts, TableType tableType) {
        writer.println("<tr>");
        writer.println("<td>" + replica + "</td>");
        ReplicaBacklog replicaBacklog = this.backlogsByReplicaHost.get(replica);
        for (String replicaHost : replicaHosts) {
            ReplicaPartialBacklog partialBacklog;
            String tableValue = "";
            String bgcolor = null;
            String fgcolor = null;
            if (replicaBacklog != null && (partialBacklog = replicaBacklog.partialBacklogByReplicaId.get(replicaHost)) != null) {
                Long entryValue;
                switch (tableType) {
                    case BACKLOG_MINUTES: {
                        entryValue = partialBacklog.getPerOriginDurationMillis();
                        double backlogMinutes = (double)entryValue.longValue() / 60000.0;
                        if (backlogMinutes > 5.0) {
                            tableValue = this.wholeMinute.format(backlogMinutes);
                            break;
                        }
                        tableValue = this.fractionalMinute.format(backlogMinutes);
                        break;
                    }
                    case MISSING_CHANGES: {
                        entryValue = partialBacklog.getPerOriginBacklog();
                        tableValue = entryValue.toString();
                        break;
                    }
                    default: {
                        entryValue = null;
                    }
                }
                String[] colors = AllBacklogs.lookupTableColors(entryValue, tableType);
                bgcolor = colors[0];
                fgcolor = colors[1];
            }
            writer.print("<td");
            if (bgcolor != null) {
                writer.print(" bgcolor=\"" + bgcolor + "\"");
            }
            if (fgcolor != null) {
                writer.print(" style=\"color:" + fgcolor + "\"");
            }
            writer.print(">");
            writer.print(tableValue);
            writer.print("</td>");
        }
        writer.println("</tr>");
    }

    public String toString() {
        return "backlogsByReplicaId=" + this.backlogsByReplicaHost;
    }

    private static String[] lookupTableColors(Long entryValue, TableType tableType) {
        Long comparisonValue = tableType.equals((Object)TableType.MISSING_CHANGES) ? Long.valueOf(entryValue * 250L) : entryValue;
        String bgcolor = null;
        String fgcolor = null;
        if (comparisonValue != null && comparisonValue >= 500L) {
            if (comparisonValue < 1000L) {
                bgcolor = "#00FF00";
            } else if (comparisonValue < 2000L) {
                bgcolor = "#32CD32";
            } else if (comparisonValue < 4000L) {
                bgcolor = "#ADFF2F";
            } else if (comparisonValue < 8000L) {
                bgcolor = "#FFFF00";
            } else if (comparisonValue < 16000L) {
                bgcolor = "#FFD700";
            } else if (comparisonValue < 32000L) {
                bgcolor = "#FFA500";
            } else if (comparisonValue < 64000L) {
                bgcolor = "#FF8C00";
            } else if (comparisonValue < 128000L) {
                bgcolor = "#FF4500";
            } else if (comparisonValue < 256000L) {
                bgcolor = "#FF0000";
                fgcolor = "#FFFFFF";
            } else if (comparisonValue < 512000L) {
                bgcolor = "#E60000";
                fgcolor = "#FFFFFF";
            } else if (comparisonValue < 1024000L) {
                bgcolor = "#CC0000";
                fgcolor = "#FFFFFF";
            } else if (comparisonValue < 2048000L) {
                bgcolor = "#B20000";
                fgcolor = "#FFFFFF";
            } else if (comparisonValue < 4096000L) {
                bgcolor = "#990000";
                fgcolor = "#FFFFFF";
            } else {
                bgcolor = "#000000";
                fgcolor = "#FFFFFF";
            }
        }
        return new String[]{bgcolor, fgcolor};
    }

    public static enum TableType {
        BACKLOG_MINUTES,
        MISSING_CHANGES;

    }
}

