/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.visualizereplicationstate;

import com.pingidentity.csd.tools.visualizereplicationstate.AllBacklogs;
import com.pingidentity.csd.tools.visualizereplicationstate.VisualizeReplicationState;
import com.unboundid.directory.server.util.LDIFFile;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

public class FileBuilder {
    private final File outputFile;

    public FileBuilder(File file, Collection<String> baseDNs, Collection<LDIFFile> monitorFiles, LDIFFile currentMonitorFile) throws Exception {
        this.outputFile = file;
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.outputFile, true));){
            this.writeHtmlStart(writer, monitorFiles, currentMonitorFile);
            this.writeHtmlTabs(writer, baseDNs);
        }
    }

    private void writeHtmlTabs(PrintWriter writer, Collection<String> baseDNs) {
        writer.println("<div class=\"tab\">");
        boolean firstTab = true;
        for (String value : baseDNs) {
            writer.print("<button class=\"tablinks");
            if (firstTab) {
                writer.print(" active");
                firstTab = false;
            }
            writer.println("\" onclick=\"openTab(event, '" + value + "')\">" + value + "</button>");
        }
        writer.println("</div>");
        writer.println("<div class=\"tab\">");
        writer.print("<button class=\"tableLinks active\" onclick=\"switchTable(event, 'backlog-minutes')\">Backlog Minutes</button>");
        writer.print("<button class=\"tableLinks\" onclick=\"switchTable(event, 'missing-changes')\">Num Backlog Changes</button>");
        writer.println("</div>");
    }

    private void writeHtmlStart(PrintWriter writer, Collection<LDIFFile> monitorFiles, LDIFFile currentMonitorFile) throws IOException {
        writer.println("<html><head>");
        writer.println("<style>");
        InputStream tableStylesStream = this.getClass().getClassLoader().getResourceAsStream("visualize-replication-state" + File.separator + "styles.css");
        VisualizeReplicationState.streamDataToFile(tableStylesStream, writer);
        writer.println("</style>");
        writer.println("<script>");
        InputStream tableScriptStream = this.getClass().getClassLoader().getResourceAsStream("visualize-replication-state" + File.separator + "scripts.js");
        VisualizeReplicationState.streamDataToFile(tableScriptStream, writer);
        writer.println("</script></head><body>");
        writer.println("<div class=\"navbar\">");
        for (LDIFFile monitorFile : monitorFiles) {
            String fileName = FileBuilder.convertFilenameToTime(monitorFile);
            String path = fileName + ".html";
            if (monitorFile.equals(currentMonitorFile)) {
                writer.println("<a class=\"dropbtn active\" href=\"" + path + "\">" + fileName + "</a>");
                continue;
            }
            writer.println("<a class=\"dropbtn\" href=\"" + path + "\">" + fileName + "</a>");
        }
        writer.println("</div>");
        writer.println("<div class=\"header\"><h1><b>Replication State</b> at time " + FileBuilder.convertFilenameToTime(currentMonitorFile) + "</h1>");
        writer.println("<br><h3>Select a Backend BaseDN and data type to view the replication state</h3></div>");
    }

    public void writeAllBacklogTable(AllBacklogs allBacklogs, String baseDN, boolean defaultDisplay) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.outputFile, true));){
            if (defaultDisplay) {
                writer.println("<div id=\"" + baseDN + "\" class=\"tabcontent\" style=\"display:block\">");
            } else {
                writer.println("<div id=\"" + baseDN + "\" class=\"tabcontent\">");
            }
            writer.print("<table class=\"styled-table\" id=\"" + baseDN + "-backlog-minutes\">");
            allBacklogs.writeTableHtml(writer, AllBacklogs.TableType.BACKLOG_MINUTES);
            writer.println("</table>");
            writer.print("<table class=\"styled-table\" style=\"display: none\" id=\"" + baseDN + "-missing-changes\">");
            allBacklogs.writeTableHtml(writer, AllBacklogs.TableType.MISSING_CHANGES);
            writer.println("</table></div>");
        }
    }

    public void writeHtmlEnd() throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.outputFile, true));){
            writer.println("</body></html>");
        }
    }

    static String convertFilenameToTime(LDIFFile ldifFile) {
        String fileName = ldifFile.getFile().getName();
        try {
            SearchResultEntry entry = ldifFile.getEntry("cn=monitor", new String[]{"currentTime"});
            String fileDate = entry.getAttributeValue("currentTime");
            SimpleDateFormat monitorFileDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat outputDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date monitorDate = monitorFileDateFormat.parse(fileDate);
            return outputDateFormat.format(monitorDate);
        }
        catch (Exception e) {
            return fileName;
        }
    }
}

