/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.visualizereplicationstate;

import com.pingidentity.csd.tools.visualizereplicationstate.AllBacklogs;
import com.unboundid.directory.server.util.LDIFFile;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.io.File;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

public class ReplicationMonitorEntries {
    private final SortedMap<String, AllBacklogs> allBacklogsByBaseDN = new TreeMap<String, AllBacklogs>();

    public ReplicationMonitorEntries(LDIFFile monitorFile) throws Exception {
        String monitorBaseDN = "cn=monitor";
        String filterString = "(objectClass=ds-replication-server-summary-monitor-entry)";
        SearchResult summaryMonitorEntries = monitorFile.search(monitorBaseDN, SearchScope.ONE, filterString, new String[0]);
        for (SearchResultEntry entry : summaryMonitorEntries.getSearchEntries()) {
            String backendBaseDN = entry.getAttribute("base-dn").getValue();
            File tempFile = File.createTempFile("Replication Summary", backendBaseDN);
            LDIFFile monitorEntryFile = new LDIFFile(tempFile);
            monitorEntryFile.add((Entry)entry);
            AllBacklogs allBacklog = new AllBacklogs(tempFile);
            this.allBacklogsByBaseDN.put(backendBaseDN, allBacklog);
        }
    }

    public Collection<String> getBaseDNs() {
        return this.allBacklogsByBaseDN.keySet();
    }

    public Collection<AllBacklogs> getAllBacklogs() {
        return this.allBacklogsByBaseDN.values();
    }

    public AllBacklogs getAllBacklogs(String baseDN) {
        return (AllBacklogs)this.allBacklogsByBaseDN.get(baseDN);
    }

    public boolean isEmpty() {
        return this.allBacklogsByBaseDN.isEmpty();
    }
}

