/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.visualizereplicationstate;

import com.pingidentity.csd.server.util.ServerUtils;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.visualizereplicationstate.FileBuilder;
import com.pingidentity.csd.tools.visualizereplicationstate.ReplicationMonitorEntries;
import com.unboundid.csd.messages.UBIDTool2Messages;
import com.unboundid.directory.server.util.LDIFFile;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.FileArgument;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class VisualizeReplicationState
extends CommandLineTool {
    private FileArgument monitorFileArg;
    private FileArgument csdFileArg;
    private FileArgument outputFolderArg;
    private final HashMap<LDIFFile, ReplicationMonitorEntries> monitorFilesToMonitorEntries = new LinkedHashMap<LDIFFile, ReplicationMonitorEntries>();
    private String toolOutputFolder;
    private final DateFormat dateFormat = new SimpleDateFormat("-yyyy:MM:dd:HH:mm:ssZ");
    public static final String SCRIPT_NAME = "visualize-replication-state";

    public VisualizeReplicationState(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    public static void main(String[] args) {
        ResultCode rc = VisualizeReplicationState.doMain(System.out, System.err, args);
        if (rc != ResultCode.SUCCESS) {
            int exitCode = Math.max(1, Math.min(rc.intValue(), 255));
            System.exit(exitCode);
        }
    }

    public static ResultCode doMain(OutputStream outStream, OutputStream errStream, String ... args) {
        VisualizeReplicationState visualizeReplicationState = new VisualizeReplicationState(outStream, errStream);
        return VisualizeReplicationState.doMain(visualizeReplicationState, args);
    }

    public static ResultCode doMain(VisualizeReplicationState visualizeReplicationState, String ... args) {
        return visualizeReplicationState.runTool(args);
    }

    public String getToolName() {
        return SCRIPT_NAME;
    }

    public String getToolDescription() {
        return UBIDTool2Messages.INFO_VISUALIZE_REPLICATION_STATE_TOOL_DESCRIPTION.get().toString();
    }

    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.monitorFileArg = new FileArgument(Character.valueOf('M'), "monitor-file", false, 0, null, UBIDTool2Messages.INFO_VRS_MONITOR_FILE_DESCRIPTION.get().toString(), true, true, true, false);
        parser.addArgument((Argument)this.monitorFileArg);
        this.csdFileArg = new FileArgument(null, "csd-file", false, 0, null, UBIDTool2Messages.INFO_VRS_CSD_FILE_DESCRIPTION.get().toString(), true, true, false, false);
        parser.addArgument((Argument)this.csdFileArg);
        parser.addExclusiveArgumentSet((Argument)this.monitorFileArg, (Argument)this.csdFileArg, new Argument[0]);
        parser.addRequiredArgumentSet((Argument)this.monitorFileArg, (Argument)this.csdFileArg, new Argument[0]);
        this.outputFolderArg = new FileArgument(null, "output-folder", false, 0, null, UBIDTool2Messages.INFO_VRS_OUTPUT_FOLDER_DESCRIPTION.get().toString(), false, true, false, true);
        parser.addArgument((Argument)this.outputFolderArg);
    }

    public void doExtendedArgumentValidation() throws ArgumentException {
        List matchingMonitorFiles;
        SupportDataArchive sda;
        ArrayList<LDIFFile> monitorFiles = new ArrayList<LDIFFile>();
        if (this.monitorFileArg.isPresent()) {
            try {
                monitorFiles.add(new LDIFFile(new File(this.monitorFileArg.getValue().getAbsolutePath())));
            }
            catch (Exception e) {
                this.err(new Object[]{e.getMessage()});
                throw new ArgumentException("Invalid Monitor File: " + this.monitorFileArg.getValue(), (Throwable)e);
            }
        }
        try {
            sda = new SupportDataArchive(this.csdFileArg.getValue());
            Pattern pattern = Pattern.compile("^.*monitor.\\d{14}.*$");
            matchingMonitorFiles = sda.listFiles().stream().sorted().filter(file -> pattern.matcher((CharSequence)file).matches() || file.endsWith("monitor.ldif")).collect(Collectors.toList());
            if (matchingMonitorFiles.isEmpty()) {
                throw new ArgumentException("Unable to find matching monitor files.  Check that the CSD folder is valid and the monitor files exist.");
            }
        }
        catch (IOException e) {
            throw new ArgumentException("Unable to create the CSD Archive for file " + this.csdFileArg.getValue());
        }
        for (String matchingMonitorFile : matchingMonitorFiles) {
            try {
                Filter filter = Filter.createORFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"objectClass", (String)"ds-replication-server-summary-monitor-entry"), Filter.createEqualityFilter((String)"cn", (String)"monitor")});
                List<Entry> entries = ServerUtils.getEntriesFromLDIF(sda.getFileInputStream(matchingMonitorFile), filter);
                LDIFFile tempFile = new LDIFFile(File.createTempFile("temp", "monitor"));
                for (Entry entry : entries) {
                    tempFile.add(entry);
                }
                if (tempFile.getEntries().isEmpty()) continue;
                monitorFiles.add(tempFile);
            }
            catch (LDIFException e) {
                this.err(new Object[]{e.getMessage()});
                throw new ArgumentException("Unrecoverable error while reading entries in the file: " + matchingMonitorFile, (Throwable)e);
            }
            catch (IOException e) {
                this.err(new Object[]{"Encountered an error creating the file: " + matchingMonitorFile + ", " + e});
            }
            catch (LDAPException e) {
                this.err(new Object[]{"Encountered an error while reading entries in the file: " + matchingMonitorFile + ", " + (Object)((Object)e)});
            }
        }
        for (LDIFFile monitorFile : monitorFiles) {
            try {
                ReplicationMonitorEntries replicationMonitorEntries = new ReplicationMonitorEntries(monitorFile);
                if (replicationMonitorEntries.isEmpty()) continue;
                this.monitorFilesToMonitorEntries.put(monitorFile, replicationMonitorEntries);
            }
            catch (Exception e) {
                this.err(new Object[]{"Error trying to parse the monitor file: " + monitorFile, e});
            }
        }
        if (this.monitorFilesToMonitorEntries.isEmpty()) {
            throw new ArgumentException("No valid replication monitor entries were found in the files passed into the tool.  This could mean that the monitor files are not valid or not from a server in a replication topology.");
        }
        this.toolOutputFolder = this.outputFolderArg.isPresent() ? this.outputFolderArg.getValue().getAbsolutePath() : SCRIPT_NAME + this.dateFormat.format(new Date()) + File.separator;
    }

    public ResultCode doToolProcessing() {
        if (!new File(this.toolOutputFolder).exists() && !new File(this.toolOutputFolder).mkdir()) {
            this.err(new Object[]{"Unable to create the parent directory " + this.toolOutputFolder});
            return ResultCode.LOCAL_ERROR;
        }
        try {
            this.createIndexFile();
        }
        catch (IOException e) {
            this.err(new Object[]{"Error creating index file: " + e});
            return ResultCode.LOCAL_ERROR;
        }
        ResultCode rc = ResultCode.SUCCESS;
        for (LDIFFile monitorFile : this.monitorFilesToMonitorEntries.keySet()) {
            rc = this.processMonitorFile(monitorFile);
            if (rc.equals((Object)ResultCode.SUCCESS)) continue;
            return rc;
        }
        return rc;
    }

    private void createIndexFile() throws IOException {
        File indexFile = new File(this.toolOutputFolder, "index.html");
        try (PrintWriter writer = new PrintWriter(new FileWriter(indexFile, true));){
            writer.println("<html><head>");
            writer.println("<style>");
            InputStream tableStylesStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(SCRIPT_NAME + File.separator + "styles.css");
            VisualizeReplicationState.streamDataToFile(tableStylesStream, writer);
            writer.println("</style>");
            writer.println("<script>");
            InputStream tableScriptStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(SCRIPT_NAME + File.separator + "scripts.js");
            VisualizeReplicationState.streamDataToFile(tableScriptStream, writer);
            writer.println("</script></head><body>");
            writer.println("<div class=\"navbar\">");
            for (LDIFFile monitorFile : this.monitorFilesToMonitorEntries.keySet()) {
                String fileName = FileBuilder.convertFilenameToTime(monitorFile);
                String path = fileName + ".html";
                writer.println("<a class=\"dropbtn\" href=\"" + path + "\">" + fileName + "</a>");
            }
            writer.println("</div>");
            writer.println("<div class=\"header\"><h1>Welcome to the Visualize Replication State Tool!</h1><br><br>");
            writer.println("<h3>Select a time at which you would like to see the state of the replication topology.</h3></div>");
        }
    }

    static void streamDataToFile(InputStream inStream, PrintWriter outStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = inStream.read(buffer)) != -1) {
            String str = new String(buffer, StandardCharsets.UTF_8);
            outStream.write(str, 0, bytesRead);
        }
        IOUtils.closeQuietly((InputStream)inStream);
    }

    private ResultCode processMonitorFile(LDIFFile currentMonitorFile) {
        try {
            ReplicationMonitorEntries baseDNToAllBacklog = this.monitorFilesToMonitorEntries.get(currentMonitorFile);
            File outputFile = new File(this.toolOutputFolder, FileBuilder.convertFilenameToTime(currentMonitorFile) + ".html");
            FileBuilder outputFileBuilder = new FileBuilder(outputFile, baseDNToAllBacklog.getBaseDNs(), this.monitorFilesToMonitorEntries.keySet(), currentMonitorFile);
            boolean defaultDisplay = true;
            for (String baseDN : baseDNToAllBacklog.getBaseDNs()) {
                outputFileBuilder.writeAllBacklogTable(baseDNToAllBacklog.getAllBacklogs(baseDN), baseDN, defaultDisplay);
                defaultDisplay = false;
            }
            outputFileBuilder.writeHtmlEnd();
            this.out(new Object[]{"Created the html file for: " + outputFile.getName()});
        }
        catch (Exception e) {
            this.err(new Object[]{"Encountered an error while creating the html-files: " + e});
            return ResultCode.LOCAL_ERROR;
        }
        return ResultCode.SUCCESS;
    }
}

