/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console.configkeymgr;

import com.pingidentity.common.util.ConsoleUtils;
import com.pingidentity.console.configkeymgr.CommandArgument;
import com.pingidentity.console.configkeymgr.ConfigKeyCommand;
import com.pingidentity.console.configkeymgr.DeleteCommand;
import com.pingidentity.console.configkeymgr.HelpCommand;
import com.pingidentity.console.configkeymgr.ListKeysCommand;
import com.pingidentity.console.configkeymgr.ReencryptCommand;
import com.pingidentity.console.configkeymgr.RotateKeyCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;

public class ConfigKeyManager {
    private static List<ConfigKeyCommand> commands = new ArrayList<ConfigKeyCommand>();
    public static final String logName = "configkeymgr.log";
    public static final String KEY_CREATION_DATE_PARAM = "creationDate";

    public static void main(String[] args) throws IOException {
        ConfigKeyCommand commandToRun;
        boolean isActiveConsole;
        commands.add(new ListKeysCommand());
        commands.add(new RotateKeyCommand());
        commands.add(new ReencryptCommand());
        commands.add(new DeleteCommand());
        commands.add(new HelpCommand());
        ConsoleUtils.doConsoleUtilityInitialization();
        boolean isRegularConsole = !ConfigKeyManager.isActivePassiveFeatureEnabled() && !ConfigKeyManager.isEngine();
        boolean bl = isActiveConsole = ConfigKeyManager.isActivePassiveFeatureEnabled() && ConfigKeyManager.isActiveNode();
        if ((isRegularConsole || isActiveConsole) && ConfigKeyManager.checkIfPFRunning()) {
            System.exit(-1);
        }
        if ((commandToRun = ConfigKeyManager.parseCommandLineArgs(args)) != null) {
            commandToRun.execute(args);
        } else {
            ConfigKeyManager.printUsage();
        }
    }

    public static ConfigKeyCommand parseCommandLineArgs(String[] args) {
        if (args != null && args.length > 0) {
            if (args[0].equals("--list")) {
                return new ListKeysCommand();
            }
            if (args[0].equals("--rotate")) {
                return new RotateKeyCommand();
            }
            if (args[0].equals("--reencrypt")) {
                return new ReencryptCommand();
            }
            if (args[0].equals("--delete")) {
                return new DeleteCommand();
            }
            if (args[0].equals("--help")) {
                return new HelpCommand();
            }
        }
        return null;
    }

    public static void printUsage() {
        System.out.println("Usage: ");
        for (ConfigKeyCommand command : commands) {
            System.out.format("%-34s%-32s%n", command.getCommand(), command.getCommandDescription());
            for (CommandArgument argument : command.getArguments()) {
                String argLabel = "--" + argument.longArg + (argument.hasArgument ? " <arg>" : "");
                System.out.format("%4s%-30s%-32s%n", "", argLabel, argument.description);
            }
        }
    }

    public static boolean isActivePassiveFeatureEnabled() {
        return MgmtFactory.getAdminNodeConfigManager().isEnabled();
    }

    private static boolean isActiveNode() {
        return MgmtFactory.getAdminNodeConfigManager().isActiveNode();
    }

    public static boolean isPassiveNode() {
        return MgmtFactory.getAdminNodeConfigManager().isPassiveNode();
    }

    public static boolean isEngine() {
        return !ModeSupport.isConsole();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkIfPFRunning() {
        File pidFile = new File(ConfigKeyManager.getPingFedPIDFilePath());
        if (!pidFile.exists()) return false;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pidFile), StandardCharsets.UTF_8));){
            String pidString = br.readLine();
            if (StringUtils.isEmpty((String)pidString)) {
                boolean bl = false;
                return bl;
            }
            boolean isActiveConsole = ConfigKeyManager.isActivePassiveFeatureEnabled() && ConfigKeyManager.isActiveNode();
            String errMsg = isActiveConsole ? "The configkeymgr utility cannot be run when the PingFederate console in active role is running." : "The configkeymgr utility cannot be run when the PingFederate console is running.";
            System.out.println(errMsg);
            System.out.println("The pingfederate.pid was detected at: " + ConfigKeyManager.getPingFedPIDFilePath() + " and contains a process id of " + pidString);
            System.out.println("Exiting...");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.out.println("Error reading the pingfederate.pid file to determine if PF is running. Exiting...");
        }
        return false;
    }

    private static String getPingFedPIDFilePath() {
        String pfRootDir = MgmtFactory.getSysDirInfo().getRootDir();
        Path pidFilePath = Paths.get(pfRootDir, "bin", "pingfederate.pid").normalize();
        return pidFilePath.toString();
    }

    public static void logAndOutputMessage(String message, Logger log) {
        System.out.println(message);
        log.info(message);
    }
}

