/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console.configkeymgr;

import com.pingidentity.console.configkeymgr.CommandArgument;
import com.pingidentity.console.configkeymgr.ConfigKeyBaseCommand;
import com.pingidentity.console.configkeymgr.ConfigKeyCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ListKeysCommand
extends ConfigKeyBaseCommand
implements ConfigKeyCommand {
    private static final Logger log = LogManager.getLogger(ListKeysCommand.class);

    public ListKeysCommand() {
        this.commandArguments = this.initializeArguments();
    }

    @Override
    public void execute(String[] args) {
        log.info(this.getPreambleLogString(args, "List Keys"));
        this.cmdLineArgs = Arrays.copyOf(args, args.length);
        List<String> argumentValidationErrors = this.validateArguments();
        if (!argumentValidationErrors.isEmpty()) {
            this.outputCmdLineArgumentErrors(argumentValidationErrors);
            return;
        }
        JsonWebKeySet keySet = MgmtFactory.getMasterKeySet().getJsonWebKeySet();
        List keyList = keySet.getJsonWebKeys();
        System.out.format("%-16s%-10s%n", "Key ID", "Timestamp");
        System.out.println(StringUtils.repeat((String)"-", (int)44));
        for (JsonWebKey key : keyList) {
            String keyId = key.getKeyId();
            Long dateValue = (Long)key.getOtherParameterValue("creationDate", Long.class);
            String creationDateString = dateValue != null ? new Date(dateValue * 1000L).toString() : "Unknown";
            System.out.format("%-16s%-32s%n", keyId, creationDateString);
        }
    }

    private List<String> validateArguments() {
        ArrayList<String> errors = new ArrayList<String>();
        this.checkForInvalidArguments(errors);
        return errors;
    }

    @Override
    public String getCommand() {
        return "--list";
    }

    @Override
    public String getCommandDescription() {
        return "Lists all of the configuration encryption keys";
    }

    @Override
    protected List<CommandArgument> initializeArguments() {
        return Collections.EMPTY_LIST;
    }
}

