/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console.configkeymgr;

import com.pingidentity.console.configkeymgr.CommandArgument;
import com.pingidentity.console.configkeymgr.ConfigKeyBaseCommand;
import com.pingidentity.console.configkeymgr.ConfigKeyCommand;
import com.pingidentity.crypto.jwk.MasterKeySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwk.JsonWebKey;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class RotateKeyCommand
extends ConfigKeyBaseCommand
implements ConfigKeyCommand {
    private static final Logger log = LogManager.getLogger(RotateKeyCommand.class);

    public RotateKeyCommand() {
        this.commandArguments = this.initializeArguments();
    }

    @Override
    public void execute(String[] args) {
        log.info(this.getPreambleLogString(args, "Rotate Key"));
        this.cmdLineArgs = Arrays.copyOf(args, args.length);
        List<String> argumentValidationErrors = this.validateArguments();
        if (!argumentValidationErrors.isEmpty()) {
            this.outputCmdLineArgumentErrors(argumentValidationErrors);
            return;
        }
        System.out.println("Rotating Configuration Encryption Key...");
        MasterKeySet masterKeySet = MgmtFactory.getMasterKeySet();
        JsonWebKey newKey = masterKeySet.addNewKeyToFirstPosition();
        log.info("A new Configuration Encryption Key with id " + newKey.getKeyId() + " has been created.");
        System.out.println("A new Configuration Encryption Key with id " + newKey.getKeyId() + " has been created.");
    }

    @Override
    public String getCommand() {
        return "--rotate";
    }

    private List<String> validateArguments() {
        ArrayList<String> errors = new ArrayList<String>();
        this.checkForInvalidArguments(errors);
        return errors;
    }

    @Override
    protected List<CommandArgument> initializeArguments() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getCommandDescription() {
        return "Creates a new key and sets it as the primary encryption key";
    }
}

