/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console.logfilter;

import com.pingidentity.common.util.Closer;
import com.pingidentity.console.logfilter.LogFilterException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogFilter {
    private static final Logger log = LogManager.getLogger(LogFilter.class);
    private static final PrintStream out = System.out;
    private static final String ENTITY_ID_SUBJECT_SEPERATOR = "#___#";
    private final Map<String, List<String>> usersToTrackingIdsMap;
    private final Map<String, Set<String>> trackingIdXrefMap;
    private final String logFilesDirectory;
    private final SimpleDateFormat logFileDateFormat;
    private final String outputFileName;

    public LogFilter(String logFilesDir, SimpleDateFormat dateFormat, String outFileName) {
        this.logFilesDirectory = logFilesDir;
        this.logFileDateFormat = dateFormat;
        this.outputFileName = outFileName;
        this.usersToTrackingIdsMap = new HashMap<String, List<String>>();
        this.trackingIdXrefMap = new HashMap<String, Set<String>>();
    }

    public void filterLogByUser(String entityId, String subject) throws LogFilterException {
        out.println("Entity Id: " + entityId);
        log.info("Entity Id: {}", (Object)entityId);
        out.println("Subject: " + subject);
        log.info("Subject: {}", (Object)subject);
        String[] serverLogFileNames = this.getServerLogFilesFromDirectory();
        List<File> sortedLogFiles = this.getSortedLogFilesList(serverLogFileNames);
        for (File logFile : sortedLogFiles) {
            this.populateMapsFromLogFile(logFile, this.usersToTrackingIdsMap, this.trackingIdXrefMap);
        }
        Set<String> trackingsIdsForUser = this.getAllTrackingIdsForUser(entityId, subject, this.usersToTrackingIdsMap, this.trackingIdXrefMap);
        this.filterLogFiles(sortedLogFiles, trackingsIdsForUser);
    }

    public void filterLogByRequestedId(String trackingOrSessionXrefId) throws LogFilterException {
        out.println("Id: " + trackingOrSessionXrefId);
        log.info("Id: {}", (Object)trackingOrSessionXrefId);
        String[] serverLogFileNames = this.getServerLogFilesFromDirectory();
        List<File> sortedLogFiles = this.getSortedLogFilesList(serverLogFileNames);
        for (File logFile : sortedLogFiles) {
            this.populateMapsFromLogFile(logFile, this.usersToTrackingIdsMap, this.trackingIdXrefMap);
        }
        Set<String> trackingsIdsForRequestedId = this.getAllTrackingIdsForRequestedId(trackingOrSessionXrefId, this.usersToTrackingIdsMap, this.trackingIdXrefMap);
        this.filterLogFiles(sortedLogFiles, trackingsIdsForRequestedId);
    }

    protected String[] getServerLogFilesFromDirectory() throws LogFilterException {
        File logFilesDirectoryFile = new File(this.logFilesDirectory);
        FilenameFilter serverLogFilenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("server.log");
            }
        };
        String[] serverLogFileNames = logFilesDirectoryFile.list(serverLogFilenameFilter);
        if (serverLogFileNames == null || serverLogFileNames.length == 0) {
            throw new LogFilterException("No server.log files were found in " + this.logFilesDirectory);
        }
        try {
            out.println(serverLogFileNames.length + " server log file(s) found in " + logFilesDirectoryFile.getCanonicalPath());
            log.info("{} server log file(s) found in {}", (Object)serverLogFileNames.length, (Object)logFilesDirectoryFile.getCanonicalPath());
        }
        catch (IOException e) {
            log.warn("Unable to get canonical path for {}. {}", (Object)this.logFilesDirectory, (Object)e);
        }
        return serverLogFileNames;
    }

    protected Set<String> getAllTrackingIdsForUser(String entityId, String subject, Map<String, List<String>> usersToTrackingIdsMap, Map<String, Set<String>> trackingIdXrefMap) throws LogFilterException {
        String requestedKey = this.generateUserToTrackingIdMapKey(entityId, subject);
        List<String> directUserTrackingIds = usersToTrackingIdsMap.get(requestedKey);
        if (directUserTrackingIds == null || directUserTrackingIds.isEmpty()) {
            throw new LogFilterException("There were no logging messages found for entityid=" + entityId + " subject=" + subject + " Ensure that the user you are tracking has completed transactions which contain a cross-reference-message tag or a PFSessionRefId.");
        }
        HashSet<String> allTrackingIdsForUser = new HashSet<String>();
        for (String trackingId : directUserTrackingIds) {
            Set<String> trackingAndXrefIDs = trackingIdXrefMap.get(trackingId);
            if (trackingAndXrefIDs != null) {
                for (String id : trackingAndXrefIDs) {
                    if (!id.startsWith("tid:")) continue;
                    allTrackingIdsForUser.add(StringUtils.substringAfter((String)id, (String)"tid:"));
                }
                continue;
            }
            allTrackingIdsForUser.add(trackingId);
        }
        return allTrackingIdsForUser;
    }

    protected Set<String> getAllTrackingIdsForRequestedId(String trackingOrSessionXrefId, Map<String, List<String>> usersToTrackingIdsMap, Map<String, Set<String>> trackingIdXrefMap) throws LogFilterException {
        Set<String> trackingAndXrefIDs = trackingIdXrefMap.get(trackingOrSessionXrefId);
        if (trackingAndXrefIDs == null || trackingAndXrefIDs.isEmpty()) {
            throw new LogFilterException("There were no logging messages found for id=" + trackingOrSessionXrefId + " Ensure that the transaction you are tracking has completed actions which contain a cross-reference-message tag or a PFSessionRefId.");
        }
        HashSet<String> allTrackingIdsForUser = new HashSet<String>();
        for (String id : trackingAndXrefIDs) {
            if (!id.startsWith("tid:")) continue;
            allTrackingIdsForUser.add(StringUtils.substringAfter((String)id, (String)"tid:"));
        }
        return allTrackingIdsForUser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void filterLogFiles(List<File> serverLogs, Set<String> trackingIds) throws LogFilterException {
        try {
            if (this.outputFileName == null) return;
            File outputFile = new File(this.outputFileName);
            out.println("Output file: " + outputFile.getCanonicalPath());
            log.info("Output file: {}", (Object)outputFile.getCanonicalPath());
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);
                 BufferedWriter bufferedWriter = new BufferedWriter(writer);){
                for (File serverLog : serverLogs) {
                    String logFileName = serverLog.getName();
                    try {
                        logFileName = serverLog.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    out.println("Filtering " + logFileName + "...");
                    log.info("Filtering {}...", (Object)logFileName);
                    try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(serverLog), StandardCharsets.UTF_8));){
                        String line;
                        StringBuffer currentMessage = null;
                        while ((line = input.readLine()) != null) {
                            if (this.isNewLoggingMessage(line)) {
                                if (currentMessage != null) {
                                    String currentMessageString = currentMessage.toString();
                                    bufferedWriter.write(currentMessageString);
                                    currentMessage = null;
                                }
                                boolean addMessageToFilteredOutput = false;
                                if (StringUtils.contains((String)line, (String)"tid:")) {
                                    String trackingIdFromMessage = StringUtils.substringBetween((String)line, (String)"tid:", (String)" ");
                                    addMessageToFilteredOutput = trackingIds.contains(trackingIdFromMessage);
                                }
                                if (!addMessageToFilteredOutput) continue;
                                currentMessage = new StringBuffer(line);
                                currentMessage.append(System.getProperty("line.separator"));
                                continue;
                            }
                            if (currentMessage == null) continue;
                            currentMessage.append(line);
                            currentMessage.append(System.getProperty("line.separator"));
                        }
                        if (currentMessage == null) continue;
                        String currentMessageString = currentMessage.toString();
                        bufferedWriter.write(currentMessageString);
                    }
                    catch (IOException ex) {
                        throw new LogFilterException("Error while reading " + serverLog.getPath(), ex);
                        return;
                    }
                }
            }
            catch (IOException e) {
                throw new LogFilterException("Error while creating output for filtered log file " + this.outputFileName, e);
            }
        }
        catch (IOException e) {
            throw new LogFilterException("Error while creating output for filtered log file " + this.outputFileName, e);
        }
    }

    protected void populateMapsFromLogFile(File serverLog, Map<String, List<String>> usersToTrackingIdsMap, Map<String, Set<String>> trackingIdXrefMap) throws LogFilterException {
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(serverLog), StandardCharsets.UTF_8));
            while ((line = input.readLine()) != null) {
                if (!this.isNewLoggingMessage(line) || !StringUtils.contains((String)line, (String)"[cross-reference-message]")) continue;
                String trackingId = StringUtils.substringBetween((String)line, (String)"tid:", (String)" ");
                if (StringUtils.contains((String)line, (String)"entityid:") && StringUtils.contains((String)line, (String)"subject:")) {
                    String subject;
                    String entityId = StringUtils.substringBetween((String)line, (String)"entityid:", (String)"subject:").trim();
                    String userToTrackingIdKey = this.generateUserToTrackingIdMapKey(entityId, subject = StringUtils.substringAfter((String)line, (String)"subject:").trim());
                    List<Object> usersTrackingIds = !usersToTrackingIdsMap.containsKey(userToTrackingIdKey) ? new ArrayList() : usersToTrackingIdsMap.get(userToTrackingIdKey);
                    if (usersTrackingIds.contains(trackingId)) continue;
                    usersTrackingIds.add(trackingId);
                    usersToTrackingIdsMap.put(userToTrackingIdKey, usersTrackingIds);
                    continue;
                }
                if (!StringUtils.contains((String)line, (String)"PFSessionXRefID:")) continue;
                String sessionXrefId = StringUtils.substringAfter((String)line, (String)"PFSessionXRefID:").trim();
                Set<String> trackingIdSet = trackingIdXrefMap.get(trackingId);
                Set<String> xrefSet = trackingIdXrefMap.get(sessionXrefId);
                if (trackingIdSet == null && xrefSet == null) {
                    HashSet<CallSite> newSet = new HashSet<CallSite>();
                    newSet.add((CallSite)((Object)("tid:" + trackingId)));
                    newSet.add((CallSite)((Object)("PFSessionXRefID:" + sessionXrefId)));
                    trackingIdXrefMap.put(trackingId, newSet);
                    trackingIdXrefMap.put(sessionXrefId, newSet);
                    continue;
                }
                if (trackingIdSet == null) {
                    xrefSet.add("tid:" + trackingId);
                    xrefSet.add("PFSessionXRefID:" + sessionXrefId);
                    trackingIdXrefMap.put(trackingId, xrefSet);
                    continue;
                }
                trackingIdSet.add("tid:" + trackingId);
                trackingIdSet.add("PFSessionXRefID:" + sessionXrefId);
                trackingIdXrefMap.put(sessionXrefId, trackingIdSet);
            }
        }
        catch (IOException ex) {
            try {
                throw new LogFilterException("Error while reading " + serverLog.getPath(), ex);
            }
            catch (Throwable throwable) {
                Closer.close(input);
                throw throwable;
            }
        }
        Closer.close((Closeable)input);
    }

    protected boolean isNewLoggingMessage(String line) {
        boolean newLoggingMessage = true;
        try {
            this.logFileDateFormat.parse(line);
        }
        catch (ParseException e) {
            newLoggingMessage = false;
        }
        return newLoggingMessage;
    }

    protected String generateUserToTrackingIdMapKey(String entityId, String subject) {
        return entityId + ENTITY_ID_SUBJECT_SEPERATOR + subject;
    }

    protected List<File> getSortedLogFilesList(String[] fileNames) throws LogFilterException {
        TreeMap<Date, File> sortedLogFilesMap = new TreeMap<Date, File>();
        for (String fileName : fileNames) {
            File logFile = new File(this.logFilesDirectory, fileName);
            boolean dateFound = false;
            try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFile), StandardCharsets.UTF_8));){
                String line;
                while ((line = input.readLine()) != null) {
                    try {
                        Date logFileDate = this.logFileDateFormat.parse(line);
                        sortedLogFilesMap.put(logFileDate, logFile);
                        dateFound = true;
                        break;
                    }
                    catch (ParseException parseException) {
                    }
                }
            }
            catch (IOException ex) {
                throw new LogFilterException("Error while reading " + logFile.getPath(), ex);
            }
            if (dateFound) continue;
            throw new LogFilterException("No Date found in " + logFile.getName());
        }
        return new ArrayList<File>(sortedLogFilesMap.values());
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }
}

