/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console.logfilter.utility;

import com.pingidentity.common.util.ConsoleUtils;
import com.pingidentity.console.logfilter.LogFilter;
import com.pingidentity.console.logfilter.LogFilterException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogFilterUtility {
    private static final Logger log = LogManager.getLogger(LogFilterUtility.class);
    private static final PrintStream out = System.out;
    private static final SimpleDateFormat DEFAULT_SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    protected static final String PARAMETER_NAME_HELP = "-help";
    protected static final String PARAMETER_NAME_ENTITY_ID = "-entityid";
    protected static final String PARAMETER_NAME_SUBJECT = "-subject";
    protected static final String PARAMETER_NAME_TRACKING_ID = "-trackingid";
    protected static final String PARAMETER_NAME_SESSION_XREF_ID = "-sessionxrefid";
    protected static final String PARAMETER_NAME_LOG_FILES_DIRECTORY = "-logsdir";
    protected static final String PARAMETER_NAME_OUTPUT_FILE_NAME = "-outputfile";
    protected static final String PARAMETER_NAME_OUTPUT_TO_CONSOLE = "-outputtoconsole";
    private static final String TRACKING_ID_PREFIX = "tid:";

    private static boolean isValidParameterName(String value) {
        return PARAMETER_NAME_HELP.equals(value) || PARAMETER_NAME_ENTITY_ID.equals(value) || PARAMETER_NAME_SUBJECT.equals(value) || PARAMETER_NAME_TRACKING_ID.equals(value) || PARAMETER_NAME_SESSION_XREF_ID.equals(value) || PARAMETER_NAME_LOG_FILES_DIRECTORY.equals(value) || PARAMETER_NAME_OUTPUT_FILE_NAME.equals(value) || PARAMETER_NAME_OUTPUT_TO_CONSOLE.equals(value);
    }

    public static void main(String[] args) {
        try {
            ConsoleUtils.doConsoleUtilityInitialization();
        }
        catch (IOException e) {
            out.println(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        Map<String, String> parametersMap = LogFilterUtility.buildUtilityParametersMap(args);
        boolean helpRequested = parametersMap.containsKey(PARAMETER_NAME_HELP);
        boolean parametersDefinedCorrectly = LogFilterUtility.isParametersUsedCorrectly(parametersMap);
        if (helpRequested || !parametersDefinedCorrectly) {
            System.out.println(LogFilterUtility.createUsageMessage());
        } else {
            String logFilesDirectory = System.getProperty("pingfederate.log.dir");
            String configuredLogDir = parametersMap.get(PARAMETER_NAME_LOG_FILES_DIRECTORY);
            if (StringUtils.isNotEmpty((String)configuredLogDir)) {
                logFilesDirectory = configuredLogDir;
            }
            boolean outputToConsole = parametersMap.containsKey(PARAMETER_NAME_OUTPUT_TO_CONSOLE);
            String outputFileName = parametersMap.get(PARAMETER_NAME_OUTPUT_FILE_NAME);
            Object outputFileNameForFilter = logFilesDirectory + File.separator + "logfilter_output.log";
            if (outputToConsole) {
                outputFileNameForFilter = null;
            } else if (outputFileName != null) {
                outputFileNameForFilter = outputFileName;
            }
            boolean errorDetected = LogFilterUtility.validateParameters(logFilesDirectory, parametersMap);
            if (!errorDetected) {
                LogFilter logFilter = new LogFilter(logFilesDirectory, DEFAULT_SDF, (String)outputFileNameForFilter);
                out.println("Executing filter...");
                log.info("Executing filter...");
                try {
                    if (parametersMap.containsKey(PARAMETER_NAME_TRACKING_ID)) {
                        logFilter.filterLogByRequestedId(parametersMap.get(PARAMETER_NAME_TRACKING_ID));
                    } else if (parametersMap.containsKey(PARAMETER_NAME_SESSION_XREF_ID)) {
                        logFilter.filterLogByRequestedId(parametersMap.get(PARAMETER_NAME_SESSION_XREF_ID));
                    } else {
                        logFilter.filterLogByUser(parametersMap.get(PARAMETER_NAME_ENTITY_ID), parametersMap.get(PARAMETER_NAME_SUBJECT));
                    }
                    out.println("Filter executed successfully.");
                    log.info("Filter executed successfully.");
                }
                catch (LogFilterException ex) {
                    out.println(ex.getMessage() + " -- See logfilter.log for more information.");
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private static String createUsageMessage() {
        String optionsUsageMessage = "[-logsdir <log-files-directory>] [-outputfile <output-file> | -outputtoconsole] ";
        String userUsageMessage = "logfilter -entityid <entity-id> -subject <subject> " + optionsUsageMessage;
        String trackingIdUsageMessage = "logfilter -trackingid <tracking-id> " + optionsUsageMessage;
        String sessionXrefUsageMessage = "logfilter -sessionxrefid <session-xref-id> " + optionsUsageMessage;
        return "usage: \t" + userUsageMessage + "\n\t" + trackingIdUsageMessage + "\n\t" + sessionXrefUsageMessage;
    }

    private static boolean validateParameters(String logFilesDirectory, Map<String, String> parametersMap) {
        String trackingId;
        boolean errorsDetected = false;
        File logFilesDirectoryFile = new File(logFilesDirectory);
        String directoryNameForErrorMsg = logFilesDirectory;
        try {
            directoryNameForErrorMsg = logFilesDirectoryFile.getCanonicalPath();
        }
        catch (IOException e) {
            log.warn("Unable to get canonical path for" + logFilesDirectory + " [LogFilter.Utility.validateParameters()]. " + e);
        }
        if (!logFilesDirectoryFile.exists()) {
            out.println(directoryNameForErrorMsg + " does not exist");
            errorsDetected = true;
        } else if (!logFilesDirectoryFile.isDirectory()) {
            out.println(directoryNameForErrorMsg + " is not a directory");
            errorsDetected = true;
        } else if (logFilesDirectoryFile.length() == 0L) {
            out.println(directoryNameForErrorMsg + " is empty");
            errorsDetected = true;
        }
        if (parametersMap.containsKey(PARAMETER_NAME_TRACKING_ID) && (trackingId = parametersMap.get(PARAMETER_NAME_TRACKING_ID)).startsWith(TRACKING_ID_PREFIX)) {
            log.error("A tracking prefix (tid:) was found and should not be included in tracking ID. The filter will be not besuccessful.");
            out.println("The tracking prefix (tid:) cannot not be included in tracking ID. Please retry your filter and omit the prefix (tid:).");
            errorsDetected = true;
        }
        return errorsDetected;
    }

    protected static boolean isParametersUsedCorrectly(Map<String, String> parametersMap) {
        boolean outputFileNameDefined;
        boolean configuredLogDirDefined;
        boolean sessionXrefIdDefined;
        boolean trackingIdDefined;
        boolean subjectDefined;
        boolean definedParametersHaveValues = true;
        boolean entityIdDefined = parametersMap.containsKey(PARAMETER_NAME_ENTITY_ID);
        if (entityIdDefined && StringUtils.isEmpty((String)parametersMap.get(PARAMETER_NAME_ENTITY_ID))) {
            definedParametersHaveValues = false;
        }
        if ((subjectDefined = parametersMap.containsKey(PARAMETER_NAME_SUBJECT)) && StringUtils.isEmpty((String)parametersMap.get(PARAMETER_NAME_SUBJECT))) {
            definedParametersHaveValues = false;
        }
        if ((trackingIdDefined = parametersMap.containsKey(PARAMETER_NAME_TRACKING_ID)) && StringUtils.isEmpty((String)parametersMap.get(PARAMETER_NAME_TRACKING_ID))) {
            definedParametersHaveValues = false;
        }
        if ((sessionXrefIdDefined = parametersMap.containsKey(PARAMETER_NAME_SESSION_XREF_ID)) && StringUtils.isEmpty((String)parametersMap.get(PARAMETER_NAME_SESSION_XREF_ID))) {
            definedParametersHaveValues = false;
        }
        if ((configuredLogDirDefined = parametersMap.containsKey(PARAMETER_NAME_LOG_FILES_DIRECTORY)) && StringUtils.isEmpty((String)parametersMap.get(PARAMETER_NAME_LOG_FILES_DIRECTORY))) {
            definedParametersHaveValues = false;
        }
        if ((outputFileNameDefined = parametersMap.containsKey(PARAMETER_NAME_OUTPUT_FILE_NAME)) && StringUtils.isEmpty((String)parametersMap.get(PARAMETER_NAME_OUTPUT_FILE_NAME))) {
            definedParametersHaveValues = false;
        }
        boolean outputToConsole = parametersMap.containsKey(PARAMETER_NAME_OUTPUT_TO_CONSOLE);
        boolean invalidParametersDefined = false;
        for (String parameterName : parametersMap.keySet()) {
            if (LogFilterUtility.isValidParameterName(parameterName)) continue;
            invalidParametersDefined = true;
            break;
        }
        boolean requiredParametersDefined = trackingIdDefined || sessionXrefIdDefined || entityIdDefined && subjectDefined;
        boolean requiredParametersIncompatible = trackingIdDefined && sessionXrefIdDefined || sessionXrefIdDefined && (entityIdDefined || subjectDefined) || trackingIdDefined && (entityIdDefined || subjectDefined);
        boolean optionalParametersIncompatible = outputToConsole && outputFileNameDefined;
        return !invalidParametersDefined && definedParametersHaveValues && requiredParametersDefined && !requiredParametersIncompatible && !optionalParametersIncompatible;
    }

    protected static Map<String, String> buildUtilityParametersMap(String[] args) {
        HashMap<String, String> utilityParametersMap = new HashMap<String, String>();
        if (args != null && args.length > 0) {
            int argsLength = args.length;
            for (int i = 0; i < argsLength; ++i) {
                if (LogFilterUtility.isValidParameterName(args[i])) {
                    int nextIndex = i + 1;
                    if (nextIndex < argsLength && !LogFilterUtility.isValidParameterName(args[nextIndex])) {
                        utilityParametersMap.put(args[i], args[nextIndex]);
                        ++i;
                        continue;
                    }
                    utilityParametersMap.put(args[i], null);
                    continue;
                }
                utilityParametersMap.put(args[i], null);
            }
        }
        return utilityParametersMap;
    }
}

