/*
 * Decompiled with CFR 0.152.
 */
package org.pingidentity;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.start.Main;
import org.pingidentity.utils.EnvironmentVariableUtil;
import org.pingidentity.utils.HivemoduleGenerator;
import org.pingidentity.utils.LoggingUtil;
import org.pingidentity.utils.VersionComparisonUtil;
import org.pingidentity.validate.AdminApiAuthPropertyValidator;

public class RunPF {
    private static final String RUN_PROPS = "run.properties";
    private static final String HSM_DATA_DIR_PATH = "pf.hsm.data.dir.path";
    private static final String KEY_PREF_IPV4_STACK = "java.net.preferIPv4Stack";
    private static final String KEY_USE_OAEP_PARAM_SPEC = "xmlsecurity.use.oaep.parameterspec";
    private static final String KEY_USE_DECRYPT_INSTEAD_OF_UNWRAP = "xmlsecurity.use.decrypt.instead.of.unwrap";
    private static String VERSION_KEY = "pingfederate.version";
    private static final String PF_AUTHENTICATION_PROPERTY = "pf.console.authentication";
    private static final String PF_AUTHENTICATION_ADMIN_API_PROPERTY = "pf.admin.api.authentication";
    private static final String PF_AUTHENTICATION_PROPERTY_CERT = "cert";
    private static final String PF_AUTHENTICATION_CERT = "pf.admin.authentication.cert";
    private static final String PF_ENGINE_PREFER_IPV4_PROPERTY = "pf.engine.prefer_ipv4";
    private static final String PF_RUNTIME_CONTEXT_PATH_PROPERTY = "pf.runtime.context.path";
    protected static final String PF_HOME = "pf.home";
    private static final String PF_LOG4J_JSON_TEMPLATES_URI = "pf.log4j.json.templates.uri";
    private static final String PF_LOG_DIR = "pf.log.dir";
    protected static final String PF_OPERATIONAL_MODE = "pf.operational.mode";
    protected static final String PF_OPERATIONAL_MODE_STANDALONE = "STANDALONE";
    private static final String PF_OPERATIONAL_MODE_CLUSTERED_CONSOLE = "CLUSTERED_CONSOLE";
    private static final String PF_OPERATIONAL_MODE_CLUSTERED_DUAL = "CLUSTERED_DUAL";
    protected static final String PF_OPERATIONAL_MODE_CLUSTERED_ENGINE = "CLUSTERED_ENGINE";
    protected static final String PF_HSM_MODE = "pf.hsm.mode";
    protected static final String PF_HSM_MODE_AWSCLOUDHSM = "AWSCLOUDHSM";
    private static final String PF_SERVER_DEFAULT_DIR = "pf.server.default.dir";
    private static final String PF_SERVER_DATA_DIR = "pf.server.data.dir";
    private static final String JETTY_LIB_DIR = "jetty.lib.dir";
    private static Logger jerseyPackagesResourceConfigLogger;
    private static Logger jerseyScanningResourceConfigLogger;
    private static Logger jerseyWebApplicationImplLogger;
    private static final String PF_JBOSS_HOME = "pf.jboss.home";
    private static final String JBOSS_HOME_DIR = "jboss.home.dir";
    private static final String JBOSS_SERVER_LOG_DIR = "jboss.server.log.dir";
    private static final String JBOSS_SERVER_HOME_DIR = "jboss.server.home.dir";
    private static final String JBOSS_SERVER_DATA_DIR = "jboss.server.data.dir";
    private static LoggingUtil loggingUtil;

    public static void main(String[] args) throws Exception {
        String log4jJsonTemplateDir;
        Path log4jJsonTemplateDirPath;
        String jsonTemplateDirUriStr;
        loggingUtil = new LoggingUtil();
        PrintStream bootLog = loggingUtil.getBootLog();
        loggingUtil.logPfEnvironmentVariables();
        String runPropsFile = System.getProperty(RUN_PROPS, "").trim();
        Properties properties = new Properties();
        if (runPropsFile.length() > 0) {
            try (FileInputStream inputStream = new FileInputStream(runPropsFile);){
                EnvironmentVariableUtil.loadPropertyWithEnvVar(properties, inputStream, RUN_PROPS);
            }
            catch (IOException e) {
                RunPF.attentionGetter("Warning: Unable to load " + runPropsFile + ": " + e.getMessage());
            }
        } else {
            RunPF.attentionGetter("Warning: No system property set for run.properties");
        }
        if (System.getProperty(KEY_PREF_IPV4_STACK) == null) {
            String preferIpv4 = properties.getProperty(PF_ENGINE_PREFER_IPV4_PROPERTY, "true");
            System.setProperty(KEY_PREF_IPV4_STACK, preferIpv4.trim());
        }
        try {
            HivemoduleGenerator.generateRuntimeHivemodule();
        }
        catch (Exception e) {
            loggingUtil.logErrorAndHaltStartup(e.toString());
        }
        String pfOperationalMode = properties.getProperty(PF_OPERATIONAL_MODE, PF_OPERATIONAL_MODE_STANDALONE);
        if (!(PF_OPERATIONAL_MODE_STANDALONE.equalsIgnoreCase(pfOperationalMode) || PF_OPERATIONAL_MODE_CLUSTERED_CONSOLE.equalsIgnoreCase(pfOperationalMode) || PF_OPERATIONAL_MODE_CLUSTERED_ENGINE.equalsIgnoreCase(pfOperationalMode) || PF_OPERATIONAL_MODE_CLUSTERED_DUAL.equalsIgnoreCase(pfOperationalMode))) {
            loggingUtil.logMessage(pfOperationalMode + " is not a valid operational mode. Defaulting to STANDALONE");
            pfOperationalMode = PF_OPERATIONAL_MODE_STANDALONE;
            properties.setProperty(PF_OPERATIONAL_MODE, pfOperationalMode);
        }
        loggingUtil.logMessage("pf.operational.mode: " + pfOperationalMode);
        if (PF_OPERATIONAL_MODE_CLUSTERED_ENGINE.equalsIgnoreCase(pfOperationalMode)) {
            loggingUtil.logMessage("Startup PingFederate Engine only...");
            properties.put("pf.admin.https.port", "-1");
        } else if (PF_OPERATIONAL_MODE_CLUSTERED_CONSOLE.equalsIgnoreCase(pfOperationalMode)) {
            loggingUtil.logMessage("Startup PingFederate Admin Console only...");
            properties.put("pf.http.port", "-1");
            properties.put("pf.https.port", "-1");
            properties.put("pf.secondary.https.port", "-1");
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String propertyValue = (String)entry.getValue();
            if (propertyValue == null) continue;
            properties.put(entry.getKey(), propertyValue.trim());
        }
        Object contextPath = properties.getProperty(PF_RUNTIME_CONTEXT_PATH_PROPERTY);
        if (contextPath != null) {
            if (!((String)contextPath).equals("/") && ((String)contextPath).endsWith("/")) {
                contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
            }
            if (!((String)contextPath).startsWith("/")) {
                contextPath = "/" + (String)contextPath;
            }
            properties.setProperty(PF_RUNTIME_CONTEXT_PATH_PROPERTY, (String)contextPath);
        }
        properties.setProperty(KEY_USE_OAEP_PARAM_SPEC, properties.getProperty(KEY_USE_OAEP_PARAM_SPEC, "true"));
        String pfHSMMode = properties.getProperty(PF_HSM_MODE);
        if (PF_HSM_MODE_AWSCLOUDHSM.equalsIgnoreCase(pfHSMMode)) {
            properties.setProperty(KEY_USE_DECRYPT_INSTEAD_OF_UNWRAP, properties.getProperty(KEY_USE_DECRYPT_INSTEAD_OF_UNWRAP, "true"));
        }
        properties.setProperty("log4j2.formatMsgNoLookups", "true");
        System.getProperties().putAll((Map<?, ?>)properties);
        loggingUtil.logMessage("Set " + properties.size() + " system properties from " + runPropsFile);
        RunPF.validatePortProperties();
        String logDir = System.getProperty(PF_LOG_DIR);
        if (logDir == null || "".equals(logDir)) {
            System.setProperty(PF_LOG_DIR, System.getProperty(PF_HOME) + File.separator + "log");
        }
        if ((jsonTemplateDirUriStr = (log4jJsonTemplateDirPath = Paths.get(log4jJsonTemplateDir = System.getProperty(PF_HOME, ".") + File.separator + "server" + File.separator + "default" + File.separator + "conf" + File.separator + "log4j" + File.separator + "json-templates", new String[0]).normalize()).toUri().toString()).endsWith(File.separator)) {
            jsonTemplateDirUriStr = jsonTemplateDirUriStr.substring(0, jsonTemplateDirUriStr.length() - 1);
        }
        System.setProperty(PF_LOG4J_JSON_TEMPLATES_URI, jsonTemplateDirUriStr);
        File hsmDataDir = new File(System.getProperty(PF_HOME, ".") + "/server/default/data");
        if (!hsmDataDir.exists() && args.length > 0) {
            hsmDataDir = new File(args[0] + "/server/default/data");
        }
        System.setProperty(HSM_DATA_DIR_PATH, hsmDataDir.getAbsolutePath());
        String authAdminApiProperty = System.getProperty(PF_AUTHENTICATION_ADMIN_API_PROPERTY);
        RunPF.validateAuthAdminApiProperty(authAdminApiProperty);
        boolean certAuthn = PF_AUTHENTICATION_PROPERTY_CERT.equalsIgnoreCase(System.getProperty(PF_AUTHENTICATION_PROPERTY)) || PF_AUTHENTICATION_PROPERTY_CERT.equalsIgnoreCase(System.getProperty(PF_AUTHENTICATION_ADMIN_API_PROPERTY));
        System.setProperty(PF_AUTHENTICATION_CERT, Boolean.toString(certAuthn));
        File tempDir = new File(System.getProperty(PF_HOME, ".") + "/server/default/tmp");
        if (!tempDir.exists()) {
            loggingUtil.logMessage("Creating temp directory: " + tempDir.getCanonicalPath());
            boolean mkdir = tempDir.mkdir();
            if (!mkdir) {
                loggingUtil.logError("Creating temp directory: " + tempDir.getCanonicalPath() + " failed");
            }
        }
        RunPF.version();
        RunPF.initPingFederateSystemProperties();
        RunPF.checkForDuplicateJars();
        bootLog.close();
        if (Boolean.parseBoolean(System.getProperty("disable.jersey.loggers", "true"))) {
            jerseyPackagesResourceConfigLogger = Logger.getLogger("com.sun.jersey.api.core.PackagesResourceConfig");
            jerseyPackagesResourceConfigLogger.setLevel(Level.SEVERE);
            jerseyScanningResourceConfigLogger = Logger.getLogger("com.sun.jersey.api.core.ScanningResourceConfig");
            jerseyScanningResourceConfigLogger.setLevel(Level.SEVERE);
            jerseyWebApplicationImplLogger = Logger.getLogger("com.sun.jersey.server.impl.application.WebApplicationImpl");
            jerseyWebApplicationImplLogger.setLevel(Level.SEVERE);
        }
        RunPF.initLegacySystemProperties();
        Main.main((String[])args);
    }

    private static void initPingFederateSystemProperties() {
        System.setProperty(PF_SERVER_DATA_DIR, System.getProperty(PF_HOME) + File.separator + "server" + File.separator + "default" + File.separator + "data");
        System.setProperty(JETTY_LIB_DIR, System.getProperty(PF_HOME) + File.separator + "lib");
    }

    private static void initLegacySystemProperties() {
        System.setProperty(JBOSS_HOME_DIR, System.getProperty(PF_HOME));
        System.setProperty(JBOSS_SERVER_LOG_DIR, System.getProperty(PF_HOME) + File.separator + "server" + File.separator + "default" + File.separator + "log");
        System.setProperty(PF_JBOSS_HOME, System.getProperty(PF_HOME));
        System.setProperty(JBOSS_SERVER_HOME_DIR, System.getProperty(PF_SERVER_DEFAULT_DIR));
        System.setProperty(JBOSS_SERVER_DATA_DIR, System.getProperty(PF_SERVER_DATA_DIR));
    }

    private static void version() {
        InputStream is = null;
        try {
            is = RunPF.class.getResourceAsStream("/META-INF/maven/pingfederate/pf-startup/pom.properties");
            Properties pomProps = new Properties();
            pomProps.load(is);
            String version = pomProps.getProperty("version");
            System.setProperty(VERSION_KEY, version);
        }
        catch (Exception e) {
            loggingUtil.logError("Problem reading version " + e);
        }
        finally {
            RunPF.closeInputStream(is);
        }
    }

    private static void closeInputStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                loggingUtil.logError("Problem  closing  stream " + e);
            }
        }
    }

    static void attentionGetter(String msg) {
        loggingUtil.logError("!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!-!");
        loggingUtil.logError("     " + msg);
        loggingUtil.logError("!-----------------------------------------------------------------------!");
    }

    private static void validatePortProperties() {
        RunPF.validatePortProperty("pf.admin.https.port");
        RunPF.validatePortProperty("pf.http.port");
        RunPF.validatePortProperty("pf.https.port");
        RunPF.validatePortProperty("pf.secondary.https.port");
    }

    private static void validatePortProperty(String propertyKey) {
        String port = System.getProperty(propertyKey);
        try {
            Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            loggingUtil.logError(propertyKey + " is not numeric: " + port);
            RunPF.haltStartup();
        }
    }

    private static void checkForDuplicateJars() {
        RunPF.checkForDuplicateJars("pf-authn-api-sdk");
    }

    public static void checkForDuplicateJars(String jarName) {
        String homedir = System.getProperty(PF_SERVER_DEFAULT_DIR, "jboss");
        loggingUtil.logMessage("Checking for duplicate copies of the " + jarName + " file. Scanning from " + homedir);
        File deployDir = new File(homedir + File.separator + "deploy");
        File libDir = new File(homedir + File.separator + "lib");
        File jettyLibDir = new File(System.getProperty(JETTY_LIB_DIR));
        ArrayList<File> allFiles = new ArrayList<File>();
        RunPF.addDirectoryFiles(deployDir, allFiles);
        RunPF.addDirectoryFiles(libDir, allFiles);
        RunPF.addDirectoryFiles(jettyLibDir, allFiles);
        ArrayList<File> matchingJarFiles = new ArrayList<File>();
        String pattern = jarName + ".*.jar";
        for (File f : allFiles) {
            if (!f.getName().matches(pattern)) continue;
            matchingJarFiles.add(f);
        }
        if (matchingJarFiles.size() > 1) {
            int result;
            StringBuilder message = new StringBuilder("Multiple copies of the " + jarName + " file were found. Files found: ");
            File highestVersion = (File)matchingJarFiles.get(0);
            message.append(RunPF.makeRelative(((File)matchingJarFiles.get(0)).getPath()));
            for (int i = 1; i < matchingJarFiles.size(); ++i) {
                message.append(", " + RunPF.makeRelative(((File)matchingJarFiles.get(i)).getPath()));
                result = VersionComparisonUtil.compareVersions(jarName, highestVersion.getName(), ((File)matchingJarFiles.get(i)).getName());
                if (result != -1) continue;
                highestVersion = (File)matchingJarFiles.get(i);
            }
            loggingUtil.logMessage(message.toString());
            loggingUtil.logMessage("The latest version of " + jarName + " found is " + highestVersion.getName());
            matchingJarFiles.remove(highestVersion);
            File duplicateDir = new File(libDir.getPath() + File.separator + "duplicate");
            if (!duplicateDir.exists() && (result = (int)(duplicateDir.mkdir() ? 1 : 0)) == 0) {
                loggingUtil.logErrorAndHaltStartup("Could not move duplicate " + jarName + " jars to the " + RunPF.makeRelative(duplicateDir.getPath()) + " directory. Please remove duplicates, keeping only the latest version.");
            }
            for (File f : matchingJarFiles) {
                loggingUtil.logMessage("Moving " + RunPF.makeRelative(f.getPath()) + " to the " + RunPF.makeRelative(duplicateDir.getPath()) + " directory.");
                String destinationPath = duplicateDir.getPath() + File.separator + f.getName();
                boolean result2 = f.renameTo(new File(destinationPath));
                if (result2) continue;
                loggingUtil.logErrorAndHaltStartup("Could not move " + RunPF.makeRelative(f.getPath()) + " to the /lib/duplicate directory. Please remove this file and any other duplicates.");
            }
        }
    }

    private static void addDirectoryFiles(File directory, List<File> fileList) {
        File[] files = directory.listFiles();
        if (files != null) {
            fileList.addAll(Arrays.asList(files));
        }
    }

    private static String makeRelative(String fullPathStr) {
        String homedir = System.getProperty(PF_SERVER_DEFAULT_DIR, "jboss");
        return RunPF.makeRelative(homedir, fullPathStr);
    }

    private static String makeRelative(String basePathStr, String fullPathStr) {
        try {
            Path basePath = new File(basePathStr).getCanonicalFile().toPath();
            Path fullPath = new File(fullPathStr).getCanonicalFile().toPath();
            return basePath.relativize(fullPath).toString();
        }
        catch (IOException | IllegalArgumentException e) {
            return fullPathStr;
        }
    }

    private static void validateAuthAdminApiProperty(String property) {
        AdminApiAuthPropertyValidator adminApiAuthPropertyValidator = new AdminApiAuthPropertyValidator(loggingUtil);
        if (!adminApiAuthPropertyValidator.isAdminApiAuthPropertyValid(property)) {
            RunPF.haltStartup();
        }
    }

    private static void haltStartup() {
        Runtime.getRuntime().halt(1);
    }
}

