/*
 * Decompiled with CFR 0.152.
 */
package org.pingidentity.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class EnvironmentVariableUtil {
    private static final String PF_PREFIX = "PF_";
    private static final char FILE_NAME_SEPARATOR = '-';
    private static final char ENV_VAR_NAME_SEPARATOR = '_';
    private static final char PROPERTY_NAME_SEPARATOR = '.';

    public static void loadPropertyWithEnvVar(Properties properties, InputStream inputStream, String fileName) throws IOException {
        properties.load(inputStream);
        EnvironmentVariableUtil.substituteEnvironmentVariables(properties, fileName);
    }

    public static void loadPropertyWithEnvVar(Properties properties, Reader reader, String fileName) throws IOException {
        properties.load(reader);
        EnvironmentVariableUtil.substituteEnvironmentVariables(properties, fileName);
    }

    private static void substituteEnvironmentVariables(Properties properties, String fileName) {
        Map<String, String> envs = System.getenv();
        String prefix = EnvironmentVariableUtil.getEnvVarNamePrefix(fileName);
        Map<String, String> propsNameMap = EnvironmentVariableUtil.getPropertyNameMap(properties);
        for (Map.Entry<String, String> env : envs.entrySet()) {
            EnvironmentVariableUtil.updateProperties(properties, prefix, env, propsNameMap);
        }
    }

    public static Map<String, String> getPropertyNameMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String value = (String)keys.nextElement();
            String key = value.toLowerCase().replace('_', '.');
            map.put(key, value);
        }
        return map;
    }

    public static void updateProperties(Properties properties, String prefix, Map.Entry<String, String> env, Map<String, String> propsNameMap) {
        String envName = env.getKey();
        String propertyName = EnvironmentVariableUtil.removeEnvNamePrefix(prefix, envName).replace('_', '.');
        if (propertyName.length() > 0) {
            properties.put(propsNameMap.getOrDefault(propertyName.toLowerCase(), propertyName), env.getValue());
        }
    }

    private static String removeEnvNamePrefix(String prefix, String envName) {
        if (envName != null && envName.toUpperCase().startsWith(prefix)) {
            return envName.substring(prefix.length());
        }
        return "";
    }

    public static String getEnvVarNamePrefix(String fileNameWithExt) {
        return PF_PREFIX + EnvironmentVariableUtil.formatFileName(fileNameWithExt) + "_";
    }

    public static String getEnvVarName(String fileNameWithExt, String ... variableNameSegments) {
        return EnvironmentVariableUtil.getEnvVarNamePrefix(fileNameWithExt) + String.join((CharSequence)String.valueOf('_'), variableNameSegments);
    }

    private static String formatFileName(String filenameWithExt) {
        String filename = filenameWithExt.split("\\.")[0];
        filename = filename.replace('-', '_');
        return filename.toUpperCase();
    }
}

