/*
 * Decompiled with CFR 0.152.
 */
package org.pingidentity.utils;

import java.util.Map;

public class StringSubstituter {
    public static final String PREFIX = "${";
    public static final String SUFFIX = "}";

    public static String substituteValues(String original, Map<Object, Object> substitutionValuesMap) throws UnRecognizedKeyException {
        return StringSubstituter.substituteValues(original, substitutionValuesMap, false);
    }

    private static String substituteValues(String original, Map<Object, Object> substitutionValuesMap, boolean suppressUnknownKey) throws UnRecognizedKeyException {
        if (original != null) {
            StringBuilder result = new StringBuilder();
            int lastIndex = 0;
            while (lastIndex < original.length()) {
                int beforeIndex = original.indexOf(PREFIX, lastIndex);
                int afterIndex = original.indexOf(SUFFIX, beforeIndex);
                if (beforeIndex == -1) {
                    String remainder = original.substring(lastIndex);
                    result.append(remainder);
                    break;
                }
                if (afterIndex == -1) {
                    throw new IncompleteKeyException("Incomplete key at " + original.substring(beforeIndex));
                }
                result.append(original.substring(lastIndex, beforeIndex));
                String key = original.substring(beforeIndex + PREFIX.length(), afterIndex);
                if (!substitutionValuesMap.containsKey(key) && !suppressUnknownKey) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Unknown Key (").append(key).append(") found attempting substitution with ");
                    msg.append(substitutionValuesMap).append(" on: ").append(original);
                    throw new UnRecognizedKeyException(msg.toString());
                }
                Object obj = substitutionValuesMap.get(key);
                String value = obj != null ? obj.toString() : "";
                result.append(value);
                lastIndex = afterIndex + 1;
            }
            return result.toString();
        }
        return null;
    }

    public static class IncompleteKeyException
    extends UnRecognizedKeyException {
        private static final long serialVersionUID = 1L;

        public IncompleteKeyException(String message) {
            super(message);
        }
    }

    public static class UnRecognizedKeyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnRecognizedKeyException(String msg) {
            super(msg);
        }
    }
}

