/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class Log {
    private static final int LOG_LEVEL_ERROR = 1;
    private static final int LOG_LEVEL_WARN = 2;
    private static final int LOG_LEVEL_INFO = 3;
    private static final int LOG_LEVEL_DEBUG = 4;
    private static final int LOG_LEVEL_TRACE = 5;
    private static final String ERROR_LEVEL_STRING = "ERROR";
    private static final String WARN_LEVEL_STRING = "WARN ";
    private static final String INFO_LEVEL_STRING = "INFO ";
    private static final String DEBUG_LEVEL_STRING = "DEBUG";
    private static final String TRACE_LEVEL_STRING = "TRACE";
    private static final String dateFormatStr = "yyyy-MM-dd HH:mm:ss";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static int logLevel = -1;
    private static PrintWriter logFilePrintStream = null;
    private static boolean log4jInitialized = false;

    private static boolean logLevel(int level) {
        if (logLevel == -1) {
            String logLevelStr = System.getProperty("ucu.log.level");
            if (logLevelStr == null || logLevelStr.equals("")) {
                logLevel = 3;
            } else {
                try {
                    logLevel = Integer.parseInt(logLevelStr);
                }
                catch (NumberFormatException e) {
                    logLevel = 3;
                }
            }
        } else if (System.getProperty("ucu.log.level") != null && !System.getProperty("ucu.log.level").equals("")) {
            logLevel = Integer.parseInt(System.getProperty("ucu.log.level"));
        }
        if (log4jInitialized) {
            LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig("");
            switch (logLevel) {
                case 5: {
                    if (LogManager.getRootLogger().getLevel().equals(Level.TRACE)) break;
                    loggerConfig.setLevel(Level.TRACE);
                    break;
                }
                default: {
                    if (LogManager.getRootLogger().getLevel().equals(Level.WARN)) break;
                    loggerConfig.setLevel(Level.WARN);
                }
            }
            ctx.updateLoggers();
        }
        return level <= logLevel;
    }

    public static synchronized void init() throws FileNotFoundException {
        if (logFilePrintStream == null) {
            logFilePrintStream = new PrintWriter(new FileOutputStream("usercount.log", true), true);
            try {
                LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
                Configuration config = ctx.getConfiguration();
                LoggerConfig loggerConfig = config.getLoggerConfig("");
                PatternLayout patternLayout = PatternLayout.newBuilder().withPattern("%d{yyyy-MM-dd HH:mm:ss} %-5p [%c] %m%n").withConfiguration(config).build();
                WriterAppender writerAppender = WriterAppender.createAppender(patternLayout, null, logFilePrintStream, "Writer Appender", false, false);
                writerAppender.start();
                loggerConfig.addAppender(writerAppender, null, null);
                ctx.updateLoggers();
                log4jInitialized = true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    public static synchronized void shutdown() {
        if (logFilePrintStream != null) {
            logFilePrintStream.close();
        }
    }

    public static boolean isTrace() {
        return Log.logLevel(5);
    }

    public static boolean isDebug() {
        return Log.logLevel(4);
    }

    public static boolean isInfo() {
        return Log.logLevel(3);
    }

    public static boolean isWarn() {
        return Log.logLevel(2);
    }

    public static boolean isError() {
        return Log.logLevel(1);
    }

    public static synchronized void trace(Class c, String str, boolean logToFile, boolean logToSystemOut) {
        if (Log.isTrace()) {
            Log.log(c, TRACE_LEVEL_STRING, str, logToFile, logToSystemOut);
        }
    }

    public static void trace(Class c, String str) {
        Log.trace(c, str, true, false);
    }

    public static void trace(Class c, String str, Throwable t) {
        Log.trace(c, str);
        Log.trace(c, Log.getStackTraceString(t));
    }

    public static void trace(Class c, Throwable t) {
        Log.trace(c, Log.getStackTraceString(t));
    }

    public static synchronized void debug(Class c, String str, boolean logToFile, boolean logToSystemOut) {
        if (Log.isDebug()) {
            Log.log(c, DEBUG_LEVEL_STRING, str, logToFile, logToSystemOut);
        }
    }

    public static void debug(Class c, String str) {
        Log.debug(c, str, true, false);
    }

    public static void debug(Class c, String str, Throwable t) {
        Log.debug(c, str);
        Log.debug(c, Log.getStackTraceString(t));
    }

    public static void debug(Class c, Throwable t) {
        Log.debug(c, Log.getStackTraceString(t));
    }

    public static synchronized void info(Class c, String str, boolean logToFile, boolean logToSystemOut) {
        if (Log.isInfo()) {
            Log.log(c, INFO_LEVEL_STRING, str, logToFile, logToSystemOut);
        }
    }

    public static void info(Class c, String str) {
        Log.info(c, str, true, true);
    }

    public static void info(Class c, String str, Throwable t) {
        Log.info(c, str);
        Log.info(c, Log.getStackTraceString(t));
    }

    public static void info(Class c, Throwable t) {
        Log.info(c, Log.getStackTraceString(t));
    }

    public static synchronized void warn(Class c, String str, boolean logToFile, boolean logToSystemOut) {
        if (Log.isWarn()) {
            Log.log(c, WARN_LEVEL_STRING, str, logToFile, logToSystemOut);
        }
    }

    public static void warn(Class c, String str) {
        Log.warn(c, str, true, true);
    }

    public static void warn(Class c, String str, Throwable t) {
        Log.warn(c, str);
        Log.warn(c, Log.getStackTraceString(t));
    }

    public static void warn(Class c, Throwable t) {
        Log.warn(c, Log.getStackTraceString(t));
    }

    public static synchronized void error(Class c, String str, boolean logToFile, boolean logToSystemOut) {
        if (Log.isError()) {
            Log.log(c, ERROR_LEVEL_STRING, str, logToFile, logToSystemOut);
        }
    }

    public static void error(Class c, String str) {
        Log.error(c, str, true, true);
    }

    public static void error(Class c, String str, Throwable t) {
        Log.error(c, str);
        Log.error(c, Log.getStackTraceString(t));
    }

    public static void error(Class c, Throwable t) {
        Log.error(c, Log.getStackTraceString(t));
    }

    private static void log(Class c, String level, String str, boolean logToFile, boolean logToSystemOut) {
        Log.logToFile(c, level, str, logToFile);
        Log.logToSystemOut(c, level, str, logToSystemOut);
    }

    private static void logToFile(Class c, String level, String str, boolean logToFile) {
        if (logToFile && logFilePrintStream != null) {
            logFilePrintStream.print(Log.getMsg(c, level, str));
            logFilePrintStream.flush();
        }
    }

    private static void logToSystemOut(Class c, String level, String str, boolean logToSystemOut) {
        if (logToSystemOut) {
            if (level.equals(INFO_LEVEL_STRING)) {
                System.out.println(str);
            } else {
                System.out.println(level + ": " + str);
            }
        }
    }

    private static String getMsg(Class c, String level, String str) {
        String[] lines = str.split("\\n");
        StringBuilder sb = new StringBuilder();
        Date date = new Date();
        for (int i = 0; i < lines.length; ++i) {
            sb.append(dateFormat.format(date) + " " + level + " [" + c.getSimpleName() + "] " + lines[i] + System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private static String getStackTraceString(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        t.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }
}

