/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu.doer;

import com.pingidentity.pf.support.ucu.Aggregator;
import com.pingidentity.pf.support.ucu.Log;
import com.pingidentity.pf.support.ucu.conf.AppenderConfig;
import com.pingidentity.pf.support.ucu.doer.Doer;
import com.pingidentity.pf.support.ucu.exception.UserCountException;
import com.pingidentity.pf.support.ucu.util.UniqueUser;
import com.pingidentity.pf.support.ucu.util.User;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DatabaseDoerImpl
extends Doer {
    private AppenderConfig appenderConfig;

    public DatabaseDoerImpl(AppenderConfig appenderConfig) {
        this.appenderConfig = appenderConfig;
    }

    @Override
    public Map<String, List<UniqueUser>> doitPerSession() {
        boolean perSession = true;
        List<Aggregator> aggregators = this.readDatabaseAndPopulateAggregators(perSession);
        return this.doAggregationPerSession(aggregators);
    }

    @Override
    public Map<String, Set<String>> doitPerApp() throws UserCountException {
        boolean perSession = false;
        List<Aggregator> aggregators = this.readDatabaseAndPopulateAggregators(perSession);
        return this.doAggregationPerApp(aggregators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Aggregator> readDatabaseAndPopulateAggregators(boolean perSession) {
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        Aggregator aggregator = new Aggregator();
        Aggregator ssoAggregator = new Aggregator();
        ssoAggregator.setEvent("SSO");
        Aggregator oauthAggregator = new Aggregator();
        oauthAggregator.setEvent("OAuth");
        Aggregator stsAggregator = new Aggregator();
        stsAggregator.setEvent("STS");
        String databaseType = this.appenderConfig.getDatabaseType();
        String databaseUrl = this.appenderConfig.getDatabaseUrl();
        String databaseDriver = this.appenderConfig.getDatabaseDriver();
        String databaseUsername = this.appenderConfig.getDatabaseUsername();
        String databasePassword = this.appenderConfig.getDatabasePassword();
        String tableName = this.appenderConfig.getTableName();
        Log.debug(this.getClass(), "databaseType = " + databaseType);
        Log.debug(this.getClass(), "databaseUrl = " + databaseUrl);
        Log.debug(this.getClass(), "databaseDriver = " + databaseDriver);
        Log.debug(this.getClass(), "databaseUsername = ****");
        Log.debug(this.getClass(), "databasePassword = ****");
        Log.debug(this.getClass(), "tableName = " + tableName);
        Connection conn = null;
        try {
            if (databaseDriver != null) {
                Class.forName(databaseDriver).newInstance();
                conn = DriverManager.getConnection(databaseUrl, databaseUsername, databasePassword);
            } else if (databaseType.equals("mysql")) {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
                conn = DriverManager.getConnection(databaseUrl, databaseUsername, databasePassword);
            } else if (databaseType.equals("oracle")) {
                Class.forName("oracle.jdbc.OracleDriver").newInstance();
                conn = DriverManager.getConnection(databaseUrl, databaseUsername, databasePassword);
            } else if (databaseType.equals("sqlserver")) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver").newInstance();
                conn = DriverManager.getConnection(databaseUrl, databaseUsername, databasePassword);
            }
        }
        catch (SQLException ex) {
            Log.error(this.getClass(), "SQLException: " + ex.getMessage());
            Log.error(this.getClass(), "SQLState: " + ex.getSQLState());
            Log.error(this.getClass(), "VendorError: " + ex.getErrorCode());
        }
        catch (Exception e) {
            Log.error(this.getClass(), "Database connection error: " + e.getMessage());
        }
        boolean eventExists = true;
        boolean subjectExists = true;
        boolean roleExists = true;
        boolean statusExists = true;
        boolean connectionidExists = true;
        boolean trackingidExists = true;
        boolean dtimeExists = true;
        Statement stmt = null;
        ResultSet rs = null;
        String eventDBName = this.appenderConfig.getColumnNameForPattern("%X{event}");
        String usernameDBName = this.appenderConfig.getColumnNameForPattern("%X{subject}");
        String roleDBName = this.appenderConfig.getColumnNameForPattern("%X{role}");
        String statusDBName = this.appenderConfig.getColumnNameForPattern("%X{status}");
        String connectionidDBName = this.appenderConfig.getColumnNameForPattern("%X{connectionid}");
        String trackingidDBName = this.appenderConfig.getColumnNameForPattern("%X{trackingid}");
        String sql = "SELECT ";
        int fields = 0;
        if (eventDBName != null) {
            sql = sql + eventDBName;
            ++fields;
        }
        if (usernameDBName != null && !usernameDBName.isEmpty()) {
            if (fields > 0) {
                sql = sql + ",";
            }
            sql = sql + usernameDBName;
            ++fields;
        }
        if (roleDBName != null && !roleDBName.isEmpty()) {
            if (fields > 0) {
                sql = sql + ",";
            }
            sql = sql + roleDBName;
            ++fields;
        }
        if (statusDBName != null && !statusDBName.isEmpty()) {
            if (fields > 0) {
                sql = sql + ",";
            }
            sql = sql + statusDBName;
            ++fields;
        }
        if (connectionidDBName != null && !connectionidDBName.isEmpty()) {
            if (fields > 0) {
                sql = sql + ",";
            }
            sql = sql + connectionidDBName;
            ++fields;
        }
        if (trackingidDBName != null && !trackingidDBName.isEmpty()) {
            if (fields > 0) {
                sql = sql + ",";
            }
            sql = sql + trackingidDBName;
            ++fields;
        }
        sql = sql + " FROM " + tableName;
        try {
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt.setFetchSize(50);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String event = "";
                String username = "";
                String role = "";
                String status = "";
                String connectionid = "";
                String trackingid = "";
                String dtime = "";
                try {
                    event = rs.getString(eventDBName);
                }
                catch (SQLException e) {
                    eventExists = false;
                }
                try {
                    username = rs.getString(usernameDBName);
                }
                catch (SQLException e) {
                    subjectExists = false;
                }
                try {
                    role = rs.getString(roleDBName);
                }
                catch (SQLException e) {
                    roleExists = false;
                }
                try {
                    status = rs.getString(statusDBName);
                }
                catch (SQLException e) {
                    statusExists = false;
                }
                try {
                    connectionid = rs.getString(connectionidDBName);
                }
                catch (SQLException e) {
                    connectionidExists = false;
                }
                try {
                    trackingid = rs.getString(trackingidDBName);
                }
                catch (SQLException e) {
                    trackingidExists = false;
                }
                User tempUser = new User();
                tempUser.role = role;
                tempUser.connectionid = connectionid;
                tempUser.subject = username;
                tempUser.trackingid = trackingid;
                if (tempUser.subject == null || tempUser.subject.equals("") || status == null || !status.equals("success") || event == null) continue;
                try {
                    if (event.equals("SSO")) {
                        this.addUserForAggregation(perSession, ssoAggregator, tempUser);
                    } else if (event.equals("STS")) {
                        this.addUserForAggregation(perSession, stsAggregator, tempUser);
                    } else if (event.equals("OAuth")) {
                        this.addUserForAggregation(perSession, oauthAggregator, tempUser);
                    }
                    if (event.equals("SLO") || event.equals("GET User") || event.equals("POST User") || event.equals("PUT User") || event.equals("PATCH User")) continue;
                    aggregator.addUser(tempUser);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (SQLException ex) {
            System.out.println("SQLException: " + ex.getMessage());
            System.out.println("SQLState: " + ex.getSQLState());
            System.out.println("VendorError: " + ex.getErrorCode());
            System.out.println("Query: " + sql);
            Log.error(this.getClass(), "Error!!!!! Caught exception: " + ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
                stmt = null;
            }
        }
        if (!eventExists) {
            Log.warn(this.getClass(), "Missing 'event' field in database");
        }
        if (!subjectExists) {
            Log.warn(this.getClass(), "Missing 'username' field in database");
        }
        if (!roleExists) {
            Log.warn(this.getClass(), "Missing 'role' field in database");
        }
        if (!statusExists) {
            Log.warn(this.getClass(), "Missing 'status' field in database");
        }
        if (!connectionidExists) {
            Log.warn(this.getClass(), "Missing 'connectionid' field in database");
        }
        if (!trackingidExists) {
            Log.warn(this.getClass(), "Missing 'trackingid' field in database");
        }
        aggregators.add(ssoAggregator);
        aggregators.add(stsAggregator);
        aggregators.add(oauthAggregator);
        aggregators.add(aggregator);
        return aggregators;
    }

    private void addUserForAggregation(boolean perSession, Aggregator aggregator, User tempUser) {
        if (perSession) {
            aggregator.addUser(tempUser);
        } else {
            aggregator.addUserToAggregatePerApp(tempUser);
        }
    }
}

