/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.support.ucu.fileUCUCollector;

import com.pingidentity.pf.support.ucu.Aggregator;
import com.pingidentity.pf.support.ucu.Log;
import com.pingidentity.pf.support.ucu.exception.UserCountUtilityException;
import com.pingidentity.pf.support.ucu.util.UniqueUser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ucu-shaded.org.jose4j.json.internal.json_simple.parser.JSONParser;

public class UCUOutputFileUniqueUserCollector {
    Map<String, Set<String>> userIdsByApp = new HashMap<String, Set<String>>();
    Map<String, List<UniqueUser>> uniqueUsersByEvent = new HashMap<String, List<UniqueUser>>();

    public UCUOutputFileUniqueUserCollector(List<String> fileList) throws UserCountUtilityException {
        this.collectUniqueUsersFromFiles(fileList);
    }

    public void collectUniqueUsersFromFiles(List<String> fileList) throws UserCountUtilityException {
        ArrayList<Object> aggregateFiles = new ArrayList<Object>();
        String rootDirName = System.getProperty("user.dir");
        if (fileList == null || fileList.size() < 1) {
            for (File fileEntry : new File(rootDirName).listFiles()) {
                if (fileEntry.isDirectory() || !fileEntry.getName().endsWith(".ucu")) continue;
                Log.debug(this.getClass(), "Files to Aggregate: " + rootDirName + "/" + fileEntry.getName());
                aggregateFiles.add(fileEntry);
            }
        } else {
            for (String filename : fileList) {
                aggregateFiles.add(new File(filename));
            }
        }
        this.uniqueUsersByEvent = new HashMap<String, List<UniqueUser>>();
        HashMap<String, Aggregator> aggregators = new HashMap<String, Aggregator>();
        try {
            JSONParser parser = new JSONParser();
            for (int fileNum = 0; fileNum < aggregateFiles.size(); ++fileNum) {
                String fileName = rootDirName + "/" + ((File)aggregateFiles.get(fileNum)).getName();
                Log.debug(this.getClass(), "Processing " + fileName);
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                String line = in.readLine();
                while (line != null) {
                    Map jsonMap = (Map)parser.parse(line);
                    if (jsonMap.containsKey("trackingids")) {
                        UniqueUser tempUser = new UniqueUser();
                        tempUser.setEvent(jsonMap.get("event").toString());
                        tempUser.addSubjectRoleConnectionids((List)jsonMap.get("subjectRoleConnectionids"));
                        tempUser.addAppUserIds((List)jsonMap.get("trackingids"));
                        if (!aggregators.keySet().contains(tempUser.getEvent())) {
                            Aggregator aggregator = new Aggregator();
                            aggregator.setEvent(tempUser.getEvent());
                            aggregators.put(tempUser.getEvent(), aggregator);
                        }
                        ((Aggregator)aggregators.get(tempUser.getEvent())).addUniqueUser(tempUser);
                    } else {
                        Map.Entry<String, Object> jsonEntry = jsonMap.entrySet().iterator().next();
                        String appName = ((String)jsonEntry.getKey()).trim();
                        Set<String> userIds = this.processEntryUserIds(jsonEntry);
                        this.userIdsByApp.computeIfAbsent(appName, k -> new HashSet()).addAll(userIds);
                    }
                    line = in.readLine();
                }
                in.close();
                Log.info(this.getClass(), "Processed file: " + fileName);
            }
            for (String event : aggregators.keySet()) {
                Log.debug(this.getClass(), "Aggregating " + event + " users...");
                List<UniqueUser> subResult = ((Aggregator)aggregators.get(event)).aggregate();
                this.uniqueUsersByEvent.put(event, subResult);
                Log.debug(this.getClass(), event + " Unique Users: " + subResult.size());
            }
        }
        catch (Exception e) {
            Log.error(this.getClass(), "Caught exception: " + e);
        }
    }

    private Set<String> processEntryUserIds(Map.Entry<String, Object> jsonEntry) {
        String[] userIdsArray = jsonEntry.getValue().toString().replaceAll("^\"|\"$", "").replaceAll("\\[|\\]", "").split(",");
        HashSet<String> userIdsSet = new HashSet<String>(Arrays.asList(userIdsArray));
        return userIdsSet;
    }

    public Map<String, Set<String>> getUserIdsByApp() {
        return this.userIdsByApp;
    }

    public Map<String, List<UniqueUser>> getUniqueUsersByEvent() {
        return this.uniqueUsersByEvent;
    }
}

